/*
 * Decompiled with CFR 0.152.
 */
package net.rk.overpoweredmastery.datagen;

import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.stream.Stream;
import net.minecraft.client.color.item.ItemTintSource;
import net.minecraft.client.data.models.BlockModelGenerators;
import net.minecraft.client.data.models.ItemModelGenerators;
import net.minecraft.client.data.models.ModelProvider;
import net.minecraft.client.data.models.model.ModelLocationUtils;
import net.minecraft.client.data.models.model.ModelTemplate;
import net.minecraft.client.data.models.model.ModelTemplates;
import net.minecraft.client.data.models.model.TextureSlot;
import net.minecraft.client.renderer.item.BlockModelWrapper;
import net.minecraft.client.renderer.item.ClientItem;
import net.minecraft.client.renderer.item.ItemModel;
import net.minecraft.core.Holder;
import net.minecraft.data.PackOutput;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;
import net.rk.overpoweredmastery.block.InertEssenceOre;
import net.rk.overpoweredmastery.block.OMBlocks;
import net.rk.overpoweredmastery.item.OMItems;
import net.rk.overpoweredmastery.item.custom.AbstractSpear;
import net.rk.overpoweredmastery.item.custom.AbstractWubs;
import net.rk.overpoweredmastery.item.custom.InertEssence;

public class OMModels
extends ModelProvider {
    public BlockModelGenerators gen;
    public ItemModelGenerators genItem;
    public static final TextureSlot MAIN = TextureSlot.create((String)"main", null);
    public static final TextureSlot OVERLAY = TextureSlot.create((String)"overlay", null);
    public static final ModelTemplate BASE_BLOCK_WITH_EMISSIVE_OVERLAY_TEMPLATE = new ModelTemplate(Optional.of(ModelLocationUtils.decorateBlockModelLocation((String)"base_overlay_block_emissive")), Optional.empty(), new TextureSlot[]{MAIN, OVERLAY});

    public OMModels(PackOutput output) {
        super(output, "overpoweredmastery");
    }

    protected void registerModels(BlockModelGenerators blockModels, ItemModelGenerators itemModels) {
        this.gen = blockModels;
        this.genItem = itemModels;
        itemModels.generateCrossbow(OMItems.ENDARKENED_CROSSBOW.asItem());
        blockModels.createTrivialCube((Block)OMBlocks.MOVING_PROBABLE_BLOCK.get());
        itemModels.generateFlatItem(OMItems.BONE_SWORD.asItem(), ModelTemplates.FLAT_HANDHELD_ITEM);
        itemModels.generateFlatItem(OMItems.PENULTIMATE_SWORD_DARK.asItem(), ModelTemplates.FLAT_HANDHELD_ITEM);
        itemModels.generateFlatItem(OMItems.PENULTIMATE_SWORD_LIGHT.asItem(), ModelTemplates.FLAT_HANDHELD_ITEM);
        itemModels.generateFlatItem(OMItems.WOODEN_TOOL_BINDING.asItem(), ModelTemplates.FLAT_ITEM);
        itemModels.generateFlatItem(OMItems.METAL_TOOL_BINDING.asItem(), ModelTemplates.FLAT_ITEM);
        itemModels.generateFlatItem(OMItems.DIAMOND_TOOL_BINDING.asItem(), ModelTemplates.FLAT_ITEM);
        itemModels.generateFlatItem(OMItems.NETHERITE_TOOL_BINDING.asItem(), ModelTemplates.FLAT_ITEM);
        itemModels.generateFlatItem(OMItems.ULTIMATE_STAFF.asItem(), ModelTemplates.FLAT_HANDHELD_ITEM);
        blockModels.createTrivialCube((Block)OMBlocks.INERT_DARK_ESSENCE_ORE.get());
        itemModels.declareCustomModelItem(OMItems.INERT_BLUE_ESSENCE_ORE.asItem());
        itemModels.declareCustomModelItem(OMItems.INERT_GREEN_ESSENCE_ORE.asItem());
        itemModels.declareCustomModelItem(OMItems.INERT_YELLOW_ESSENCE_ORE.asItem());
        itemModels.declareCustomModelItem(OMItems.INERT_ORANGE_ESSENCE_ORE.asItem());
        itemModels.declareCustomModelItem(OMItems.INERT_RED_ESSENCE_ORE.asItem());
        itemModels.declareCustomModelItem(OMItems.INERT_LIGHT_ESSENCE_ORE.asItem());
        itemModels.declareCustomModelItem(OMItems.INERT_AURORAN_ESSENCE_ORE.asItem());
        itemModels.declareCustomModelItem(OMItems.INERT_DARK_ESSENCE_ORE.asItem());
        itemModels.generateFlatItem(OMItems.ESSENCE_ELECTRONIC_CORE.asItem(), ModelTemplates.FLAT_ITEM);
        itemModels.generateFlatItem(OMItems.AURORAN_PROCESSOR.asItem(), ModelTemplates.FLAT_ITEM);
        itemModels.generateFlatItem(OMItems.REDSTONE_BASE_COMPONENT.asItem(), ModelTemplates.FLAT_ITEM);
        itemModels.generateFlatItem(OMItems.STRANGE_STONE.asItem(), ModelTemplates.FLAT_ITEM);
        itemModels.generateFlatItem(OMItems.ULTIMATE_INGOT.asItem(), ModelTemplates.FLAT_ITEM);
        itemModels.generateFlatItem(OMItems.ULTRA_INGOT.asItem(), ModelTemplates.FLAT_ITEM);
    }

    protected Stream<? extends Holder<Block>> getKnownBlocks() {
        return OMBlocks.BLOCKS.getEntries().stream().filter(x -> !(x.value() instanceof InertEssenceOre) && !x.is(OMBlocks.SELECTION_BLOCK));
    }

    protected Stream<? extends Holder<Item>> getKnownItems() {
        return OMItems.ITEMS.getEntries().stream().filter(x -> !x.is(OMItems.ULTRA_SWORD) && !(x.value() instanceof InertEssence) && !(x.value() instanceof AbstractWubs) && !(x.value() instanceof AbstractSpear));
    }

    public void customItemModel(Block block, String customLocation) {
        ResourceLocation rs = ResourceLocation.parse((String)customLocation);
        this.gen.itemModelOutput.register(block.asItem(), new ClientItem((ItemModel.Unbaked)new BlockModelWrapper.Unbaked(rs, Collections.emptyList()), new ClientItem.Properties(true, false)));
    }

    public void customItemModel(Block block) {
        this.gen.itemModelOutput.register(block.asItem(), new ClientItem((ItemModel.Unbaked)new BlockModelWrapper.Unbaked(ModelLocationUtils.getModelLocation((Item)block.asItem()), Collections.emptyList()), new ClientItem.Properties(true, false)));
    }

    public void customItemModel(Item item) {
        this.gen.itemModelOutput.register(item, new ClientItem((ItemModel.Unbaked)new BlockModelWrapper.Unbaked(ModelLocationUtils.getModelLocation((Item)item), Collections.emptyList()), new ClientItem.Properties(true, false)));
    }

    public void customItemModelNoSwap(Item item) {
        this.gen.itemModelOutput.register(item, new ClientItem((ItemModel.Unbaked)new BlockModelWrapper.Unbaked(ModelLocationUtils.getModelLocation((Item)item), Collections.emptyList()), new ClientItem.Properties(false, false)));
    }

    public void customItemModelNoSwapOversized(Item item) {
        this.gen.itemModelOutput.register(item, new ClientItem((ItemModel.Unbaked)new BlockModelWrapper.Unbaked(ModelLocationUtils.getModelLocation((Item)item), Collections.emptyList()), new ClientItem.Properties(false, true)));
    }

    public void customItemModel(Item item, String customLocation) {
        this.gen.itemModelOutput.register(item, new ClientItem((ItemModel.Unbaked)new BlockModelWrapper.Unbaked(ResourceLocation.parse((String)customLocation), Collections.emptyList()), new ClientItem.Properties(true, false)));
    }

    public void customItemModel(Item item, String customLocation, List<ItemTintSource> sources) {
        this.gen.itemModelOutput.register(item, new ClientItem((ItemModel.Unbaked)new BlockModelWrapper.Unbaked(ResourceLocation.parse((String)customLocation), sources), new ClientItem.Properties(true, false)));
    }
}

