/*
 * Decompiled with CFR 0.152.
 */
package net.rk.overpoweredmastery.datagen;

import java.util.List;
import java.util.concurrent.CompletableFuture;
import net.minecraft.core.HolderGetter;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.PackOutput;
import net.minecraft.data.recipes.RecipeCategory;
import net.minecraft.data.recipes.RecipeOutput;
import net.minecraft.data.recipes.RecipeProvider;
import net.minecraft.tags.ItemTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.neoforged.neoforge.common.Tags;
import net.rk.overpoweredmastery.item.OMItems;

public class OMRecipe
extends RecipeProvider {
    public final HolderGetter<Item> items;

    protected OMRecipe(HolderLookup.Provider registries, RecipeOutput output) {
        super(registries, output);
        this.items = registries.lookupOrThrow(Registries.ITEM);
    }

    protected void buildRecipes() {
        this.shapeless(RecipeCategory.COMBAT, (ItemLike)OMItems.ENDARKENED_CROSSBOW, 1).requires(Ingredient.of((ItemLike)Items.CROSSBOW)).requires(Ingredient.of((ItemLike)Items.CRYING_OBSIDIAN)).requires(Ingredient.of((ItemLike)Items.CRYING_OBSIDIAN)).requires(Ingredient.of((ItemLike)Items.HEART_OF_THE_SEA)).unlockedBy("has_thingy", this.has((ItemLike)Items.CROSSBOW)).save(this.output, "endarkened_crossbow");
        this.shaped(RecipeCategory.COMBAT, (ItemLike)OMItems.RED_WUBS, 1).define(Character.valueOf('i'), (ItemLike)Items.IRON_INGOT).define(Character.valueOf('g'), (ItemLike)Items.CROSSBOW).define(Character.valueOf('d'), (ItemLike)Items.MUSIC_DISC_CHIRP).define(Character.valueOf('t'), ItemTags.TRAPDOORS).define(Character.valueOf('j'), (ItemLike)Items.JUKEBOX).pattern("gii").pattern("idt").pattern("ijt").unlockedBy("has_thingy", this.has((ItemLike)Items.MUSIC_DISC_CHIRP)).save(this.output, "red_wubs");
        this.shaped(RecipeCategory.COMBAT, (ItemLike)OMItems.GREEN_WUBS, 1).define(Character.valueOf('i'), (ItemLike)Items.IRON_INGOT).define(Character.valueOf('g'), (ItemLike)Items.CROSSBOW).define(Character.valueOf('d'), (ItemLike)Items.MUSIC_DISC_CAT).define(Character.valueOf('c'), (ItemLike)Items.CACTUS).define(Character.valueOf('t'), ItemTags.TRAPDOORS).define(Character.valueOf('j'), (ItemLike)Items.JUKEBOX).pattern("gii").pattern("cdt").pattern("ijt").unlockedBy("has_thingy", this.has((ItemLike)Items.MUSIC_DISC_CAT)).save(this.output, "green_wubs");
        this.shaped(RecipeCategory.COMBAT, (ItemLike)OMItems.PURPLE_WUBS, 1).define(Character.valueOf('o'), (ItemLike)Items.OBSIDIAN).define(Character.valueOf('g'), (ItemLike)Items.CROSSBOW).define(Character.valueOf('d'), (ItemLike)Items.MUSIC_DISC_MALL).define(Character.valueOf('c'), (ItemLike)Items.CRYING_OBSIDIAN).define(Character.valueOf('t'), ItemTags.TRAPDOORS).define(Character.valueOf('j'), (ItemLike)Items.JUKEBOX).pattern("goo").pattern("cdt").pattern("ojt").unlockedBy("has_thingy", this.has((ItemLike)Items.MUSIC_DISC_MALL)).save(this.output, "purple_wubs");
        this.shaped(RecipeCategory.COMBAT, (ItemLike)OMItems.CHICKEN_WUBS, 1).define(Character.valueOf('i'), (ItemLike)Items.IRON_INGOT).define(Character.valueOf('g'), (ItemLike)Items.CROSSBOW).define(Character.valueOf('d'), (ItemLike)Items.MUSIC_DISC_LAVA_CHICKEN).define(Character.valueOf('s'), (ItemLike)Items.SMOKER).define(Character.valueOf('l'), (ItemLike)Items.LAVA_BUCKET).define(Character.valueOf('t'), ItemTags.TRAPDOORS).define(Character.valueOf('j'), (ItemLike)Items.JUKEBOX).pattern("gii").pattern("sdl").pattern("ijt").unlockedBy("has_thingy", this.has((ItemLike)Items.MUSIC_DISC_LAVA_CHICKEN)).save(this.output, "chicken_wubs");
        this.shaped(RecipeCategory.COMBAT, (ItemLike)OMItems.NETHER_WUBS, 1).define(Character.valueOf('r'), (ItemLike)Items.NETHERRACK).define(Character.valueOf('g'), (ItemLike)Items.CROSSBOW).define(Character.valueOf('d'), (ItemLike)Items.MUSIC_DISC_PIGSTEP).define(Character.valueOf('n'), (ItemLike)Items.NETHERITE_BLOCK).define(Character.valueOf('b'), (ItemLike)Items.LAVA_BUCKET).define(Character.valueOf('t'), ItemTags.TRAPDOORS).define(Character.valueOf('j'), (ItemLike)Items.JUKEBOX).pattern("grr").pattern("bdn").pattern("rjt").unlockedBy("has_thingy", this.has((ItemLike)Items.MUSIC_DISC_PIGSTEP)).save(this.output, "nether_wubs");
        this.shaped(RecipeCategory.COMBAT, (ItemLike)OMItems.TRIAL_WUBS, 1).define(Character.valueOf('c'), (ItemLike)Items.COPPER_BLOCK).define(Character.valueOf('g'), (ItemLike)Items.CROSSBOW).define(Character.valueOf('d'), (ItemLike)Items.MUSIC_DISC_PRECIPICE).define(Character.valueOf('n'), (ItemLike)Items.CHISELED_TUFF_BRICKS).define(Character.valueOf('j'), (ItemLike)Items.JUKEBOX).pattern("gcc").pattern("ndn").pattern("cjn").unlockedBy("has_thingy", this.has((ItemLike)Items.MUSIC_DISC_PRECIPICE)).save(this.output, "trial_wubs");
        this.shaped(RecipeCategory.COMBAT, (ItemLike)OMItems.OXIDIZED_TRIAl_WUBS, 1).define(Character.valueOf('c'), (ItemLike)Items.OXIDIZED_COPPER).define(Character.valueOf('g'), (ItemLike)Items.CROSSBOW).define(Character.valueOf('d'), (ItemLike)Items.MUSIC_DISC_CREATOR).define(Character.valueOf('n'), (ItemLike)Items.CHISELED_TUFF_BRICKS).define(Character.valueOf('j'), (ItemLike)Items.JUKEBOX).pattern("gcc").pattern("ndn").pattern("cjn").unlockedBy("has_thingy", this.has((ItemLike)Items.MUSIC_DISC_CREATOR)).save(this.output, "oxidized_trial_wubs");
        this.shapeless(RecipeCategory.MISC, (ItemLike)OMItems.MOVING_PROBABLE_BLOCK_ITEM, 1).requires(Ingredient.of((ItemLike)Items.LAPIS_BLOCK)).requires(ItemTags.TRIM_MATERIALS).requires(ItemTags.TRIM_MATERIALS).requires(ItemTags.LOGS).requires(ItemTags.STONE_CRAFTING_MATERIALS).unlockedBy("has_thingy", this.has((ItemLike)Items.LAPIS_BLOCK)).save(this.output, "moving_probable_block");
        this.shaped(RecipeCategory.COMBAT, (ItemLike)OMItems.BONE_SWORD).define(Character.valueOf('s'), (ItemLike)Items.STICK).define(Character.valueOf('b'), (ItemLike)Items.BONE).pattern("b").pattern("b").pattern("s").unlockedBy("has_thingy", this.has((ItemLike)Items.STICK)).save(this.output, "bone_sword");
        this.shaped(RecipeCategory.MISC, (ItemLike)OMItems.WOODEN_TOOL_BINDING).define(Character.valueOf('m'), ItemTags.PLANKS).define(Character.valueOf('s'), (ItemLike)Items.STICK).pattern("s s").pattern(" m ").pattern("s s").unlockedBy("has_thingy", this.has(ItemTags.PLANKS)).save(this.output, "wooden_tool_binding");
        this.shaped(RecipeCategory.MISC, (ItemLike)OMItems.METAL_TOOL_BINDING).define(Character.valueOf('b'), OMItems.WOODEN_TOOL_BINDING).define(Character.valueOf('m'), Tags.Items.INGOTS_IRON).pattern("m m").pattern(" b ").pattern("m m").unlockedBy("has_thingy", this.has(Tags.Items.INGOTS_IRON)).save(this.output, "metal_tool_binding");
        this.shaped(RecipeCategory.MISC, (ItemLike)OMItems.DIAMOND_TOOL_BINDING).define(Character.valueOf('b'), OMItems.METAL_TOOL_BINDING).define(Character.valueOf('m'), Tags.Items.GEMS_DIAMOND).pattern("m m").pattern(" b ").pattern("m m").unlockedBy("has_thingy", this.has(Tags.Items.GEMS_DIAMOND)).save(this.output, "diamond_tool_binding");
        this.createSpearRecipePair("wooden_spear", OMItems.WOODEN_SPEAR.asItem(), (TagKey<Item>)ItemTags.PLANKS, OMItems.WOODEN_TOOL_BINDING.asItem(), Items.COPPER_INGOT);
        this.createSpearRecipePair("stone_spear", OMItems.STONE_SPEAR.asItem(), (TagKey<Item>)ItemTags.STONE_CRAFTING_MATERIALS, OMItems.WOODEN_TOOL_BINDING.asItem(), Items.COPPER_INGOT);
        this.createSpearRecipePair("gold_spear", OMItems.GOLD_SPEAR.asItem(), (TagKey<Item>)ItemTags.GOLD_TOOL_MATERIALS, OMItems.WOODEN_TOOL_BINDING.asItem(), Items.COPPER_INGOT);
        this.createSpearRecipePair("iron_spear", OMItems.IRON_SPEAR.asItem(), (TagKey<Item>)ItemTags.IRON_TOOL_MATERIALS, OMItems.METAL_TOOL_BINDING.asItem(), Items.COPPER_INGOT);
        this.createSpearRecipePair("diamond_spear", OMItems.DIAMOND_SPEAR.asItem(), (TagKey<Item>)ItemTags.DIAMOND_TOOL_MATERIALS, OMItems.DIAMOND_TOOL_BINDING.asItem(), Items.COPPER_INGOT);
        this.netheriteSmithing(OMItems.DIAMOND_TOOL_BINDING.asItem(), RecipeCategory.COMBAT, OMItems.NETHERITE_TOOL_BINDING.asItem());
        this.netheriteSmithing(OMItems.DIAMOND_SPEAR.asItem(), RecipeCategory.COMBAT, OMItems.NETHERITE_SPEAR.asItem());
        this.shaped(RecipeCategory.MISC, (ItemLike)OMItems.REDSTONE_BASE_COMPONENT).define(Character.valueOf('r'), (ItemLike)Items.REDSTONE).define(Character.valueOf('s'), (ItemLike)Items.SMOOTH_STONE).define(Character.valueOf('c'), OMItems.STRANGE_STONE).pattern("srs").pattern("rcr").pattern("srs").unlockedBy("has_thingy", this.has((ItemLike)OMItems.STRANGE_STONE)).save(this.output, "redstone_base_component");
        this.shaped(RecipeCategory.MISC, (ItemLike)OMItems.AURORAN_PROCESSOR).define(Character.valueOf('g'), (ItemLike)Items.GOLD_INGOT).define(Character.valueOf('a'), OMItems.INERT_AURORAN_ESSENCE).define(Character.valueOf('c'), (ItemLike)Items.GREEN_CONCRETE).pattern("cgc").pattern("gag").pattern("cgc").unlockedBy("has_thingy", this.has((ItemLike)OMItems.INERT_AURORAN_ESSENCE)).save(this.output, "auroran_processor");
        this.shaped(RecipeCategory.MISC, (ItemLike)OMItems.ESSENCE_ELECTRONIC_CORE).define(Character.valueOf('b'), OMItems.INERT_BLUE_ESSENCE).define(Character.valueOf('y'), OMItems.INERT_YELLOW_ESSENCE).define(Character.valueOf('g'), OMItems.INERT_GREEN_ESSENCE).define(Character.valueOf('r'), OMItems.INERT_RED_ESSENCE).define(Character.valueOf('c'), OMItems.AURORAN_PROCESSOR).define(Character.valueOf('i'), (ItemLike)Items.IRON_INGOT).pattern("iyi").pattern("rcg").pattern("ibi").unlockedBy("has_thingy", this.has(Tags.Items.INGOTS_IRON)).save(this.output, "essence_electronic_core");
        this.createInertOreSmeltingAndBlasting(OMItems.INERT_BLUE_ESSENCE_ORE.asItem(), OMItems.INERT_BLUE_ESSENCE.asItem());
        this.createInertOreSmeltingAndBlasting(OMItems.INERT_GREEN_ESSENCE_ORE.asItem(), OMItems.INERT_GREEN_ESSENCE.asItem());
        this.createInertOreSmeltingAndBlasting(OMItems.INERT_YELLOW_ESSENCE_ORE.asItem(), OMItems.INERT_YELLOW_ESSENCE.asItem());
        this.createInertOreSmeltingAndBlasting(OMItems.INERT_ORANGE_ESSENCE_ORE.asItem(), OMItems.INERT_ORANGE_ESSENCE.asItem());
        this.createInertOreSmeltingAndBlasting(OMItems.INERT_RED_ESSENCE_ORE.asItem(), OMItems.INERT_RED_ESSENCE.asItem());
        this.createInertOreSmeltingAndBlasting(OMItems.INERT_LIGHT_ESSENCE_ORE.asItem(), OMItems.INERT_LIGHT_ESSENCE.asItem());
        this.createInertOreSmeltingAndBlasting(OMItems.INERT_AURORAN_ESSENCE_ORE.asItem(), OMItems.INERT_AURORAN_ESSENCE.asItem());
        this.createInertOreSmeltingAndBlasting(OMItems.INERT_DARK_ESSENCE_ORE.asItem(), OMItems.INERT_DARK_ESSENCE.asItem());
    }

    public void createInertOreSmeltingAndBlasting(Item oreItem, Item resultItem) {
        this.oreSmelting(List.of(oreItem), RecipeCategory.MISC, (ItemLike)resultItem, 1.0f, 100, "inert_essence_smelting");
        this.oreBlasting(List.of(oreItem), RecipeCategory.MISC, (ItemLike)resultItem, 1.2f, 50, "inert_essence_blasting");
    }

    public void createSpearRecipePair(String recipeId, Item spearToMake, TagKey<Item> spearHeadMaterials, Item toolBinding, Item heldEndItem) {
        this.shaped(RecipeCategory.COMBAT, (ItemLike)spearToMake).define(Character.valueOf('m'), spearHeadMaterials).define(Character.valueOf('s'), (ItemLike)toolBinding).define(Character.valueOf('i'), (ItemLike)heldEndItem).pattern("m  ").pattern(" s ").pattern("  i").unlockedBy("has_thingy", this.has(spearHeadMaterials)).save(this.output, recipeId);
        this.shaped(RecipeCategory.COMBAT, (ItemLike)spearToMake).define(Character.valueOf('m'), spearHeadMaterials).define(Character.valueOf('s'), (ItemLike)toolBinding).define(Character.valueOf('i'), (ItemLike)heldEndItem).pattern("  m").pattern(" s ").pattern("i  ").unlockedBy("has_thingy", this.has(spearHeadMaterials)).save(this.output, recipeId + "_alt");
    }

    public static class RecipeRunner
    extends RecipeProvider.Runner {
        protected RecipeRunner(PackOutput packOutput, CompletableFuture<HolderLookup.Provider> registries) {
            super(packOutput, registries);
        }

        protected RecipeProvider createRecipeProvider(HolderLookup.Provider registries, RecipeOutput output) {
            return new OMRecipe(registries, output);
        }

        public String getName() {
            return "Overpowered Mastery Recipes";
        }
    }
}

