/*
 * Decompiled with CFR 0.152.
 */
package net.rk.overpoweredmastery.entity.custom;

import net.minecraft.core.particles.DustParticleOptions;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.animal.Chicken;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.monster.Zombie;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.AbstractHurtingProjectile;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.storage.ValueInput;
import net.minecraft.world.level.storage.ValueOutput;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.Vec3;
import net.rk.overpoweredmastery.Config;
import net.rk.overpoweredmastery.entity.OMEntityTypes;
import org.jetbrains.annotations.Nullable;

public class ChickenWubEnergyBall
extends AbstractHurtingProjectile {
    int count = 0;

    public ChickenWubEnergyBall(double x, double y, double z, Vec3 vector, Level level) {
        super((EntityType)OMEntityTypes.CHICKEN_WUB_ENERGY_BALL.get(), x, y, z, vector, level);
    }

    public ChickenWubEnergyBall(LivingEntity livingEntity, Vec3 vector, Level level) {
        super((EntityType)OMEntityTypes.CHICKEN_WUB_ENERGY_BALL.get(), livingEntity, vector, level);
    }

    public ChickenWubEnergyBall(EntityType<ChickenWubEnergyBall> redWubEnergyBallEntityType, Level level) {
        super(redWubEnergyBallEntityType, level);
    }

    protected void addAdditionalSaveData(ValueOutput value) {
        super.addAdditionalSaveData(value);
        value.putInt("count", this.count);
    }

    protected void readAdditionalSaveData(ValueInput value) {
        super.readAdditionalSaveData(value);
        this.count = value.getIntOr("count", 0);
    }

    protected boolean shouldBurn() {
        return false;
    }

    public void tick() {
        boolean isMovingZ;
        super.tick();
        ++this.count;
        boolean isMovingX = this.getDeltaMovement().x > 0.0 || this.getDeltaMovement().x < 0.0;
        boolean isMovingY = this.getDeltaMovement().y > 0.0 || this.getDeltaMovement().y < 0.0;
        boolean bl = isMovingZ = this.getDeltaMovement().z > 0.0 || this.getDeltaMovement().z < 0.0;
        if (this.count >= 70) {
            this.discard();
        }
        if (isMovingX || isMovingY || isMovingZ) {
            int allTheColors = this.level().getRandom().nextInt(-16000, 16000);
            this.level().addParticle((ParticleOptions)new DustParticleOptions(allTheColors, 1.0f), this.getX(), this.getY() + 0.5, this.getZ(), 0.0, 0.0, 0.0);
        } else {
            this.discard();
        }
    }

    @Nullable
    protected ParticleOptions getTrailParticle() {
        return null;
    }

    public void onHitBlock(BlockHitResult result) {
        Level level = this.level();
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            boolean hasChickenInName = serverLevel.getBlockState(result.getBlockPos()).getBlock().getDescriptionId().toLowerCase().contains("chicken");
            boolean hasJockeyInName = serverLevel.getBlockState(result.getBlockPos()).getBlock().getDescriptionId().toLowerCase().contains("jockey");
            if (this.getOwner() != null && (hasChickenInName || hasJockeyInName) && this.getBlockStateOn().canEntityDestroy((BlockGetter)this.level(), result.getBlockPos(), this.getOwner())) {
                serverLevel.destroyBlock(result.getBlockPos(), true, (Entity)this, 0);
                serverLevel.updateNeighborsAt(result.getBlockPos(), serverLevel.getBlockState(result.getBlockPos()).getBlock());
            }
        }
        this.discard();
    }

    public void onHitEntity(EntityHitResult result) {
        Entity entity = result.getEntity();
        if (entity instanceof Chicken) {
            Chicken chicken = (Chicken)entity;
            Level level = this.level();
            if (level instanceof ServerLevel) {
                serverLevel = (ServerLevel)level;
                chicken.setRemainingFireTicks(120);
                chicken.hurtServer((ServerLevel)serverLevel, this.damageSources().magic(), (float)((Integer)Config.CHICKEN_WUBS_DAMAGE_BASE_CHICKEN.get()).intValue());
            }
        } else {
            serverLevel = result.getEntity();
            if (serverLevel instanceof Zombie) {
                Level level;
                Zombie zombie = (Zombie)serverLevel;
                if (zombie.isBaby() && (level = this.level()) instanceof ServerLevel) {
                    serverLevel = (ServerLevel)level;
                    zombie.setAggressive(true);
                    zombie.setRemainingFireTicks(120);
                    zombie.hurtServer((ServerLevel)serverLevel, this.damageSources().magic(), (float)((Integer)Config.CHICKEN_WUBS_DAMAGE_BASE_BABY_ZOMBIE.get()).intValue());
                }
            } else {
                serverLevel = result.getEntity();
                if (serverLevel instanceof LivingEntity) {
                    LivingEntity livingEntity = (LivingEntity)serverLevel;
                    Level level = this.level();
                    if (level instanceof ServerLevel) {
                        serverLevel = (ServerLevel)level;
                        if (!(livingEntity instanceof Player)) {
                            boolean hasChicken = livingEntity.getName().getString().toLowerCase().contains("chicken");
                            boolean hasJockey = livingEntity.getName().getString().toLowerCase().contains("jockey");
                            if (hasChicken || hasJockey) {
                                livingEntity.hurtServer((ServerLevel)serverLevel, this.damageSources().magic(), (float)((Integer)Config.CHICKEN_WUBS_DAMAGE_BASE_IS_CHICKEN_JOCKEY.get()).intValue());
                                serverLevel.addFreshEntity((Entity)new ItemEntity((Level)serverLevel, this.getX(), this.getY(), this.getZ(), new ItemStack((ItemLike)Items.EGG)));
                            } else {
                                livingEntity.hurtServer((ServerLevel)serverLevel, this.damageSources().magic(), 5.0f);
                            }
                        }
                    }
                }
            }
        }
        this.discard();
    }
}

