/*
 * Decompiled with CFR 0.152.
 */
package net.rk.overpoweredmastery.entity.custom;

import java.util.Optional;
import net.minecraft.core.Holder;
import net.minecraft.core.particles.DustParticleOptions;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.BlockTags;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.projectile.AbstractHurtingProjectile;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.CropBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.storage.ValueInput;
import net.minecraft.world.level.storage.ValueOutput;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.Vec3;
import net.rk.overpoweredmastery.entity.OMEntityTypes;
import org.jetbrains.annotations.Nullable;

public class GreenWubEnergyBall
extends AbstractHurtingProjectile {
    int count = 0;

    public GreenWubEnergyBall(double x, double y, double z, Vec3 vector, Level level) {
        super((EntityType)OMEntityTypes.GREEN_WUB_ENERGY_BALL.get(), x, y, z, vector, level);
    }

    public GreenWubEnergyBall(LivingEntity livingEntity, Vec3 vector, Level level) {
        super((EntityType)OMEntityTypes.GREEN_WUB_ENERGY_BALL.get(), livingEntity, vector, level);
    }

    public GreenWubEnergyBall(EntityType<GreenWubEnergyBall> redWubEnergyBallEntityType, Level level) {
        super(redWubEnergyBallEntityType, level);
    }

    protected void addAdditionalSaveData(ValueOutput value) {
        super.addAdditionalSaveData(value);
        value.putInt("count", this.count);
    }

    protected void readAdditionalSaveData(ValueInput value) {
        super.readAdditionalSaveData(value);
        this.count = value.getIntOr("count", 0);
    }

    protected boolean shouldBurn() {
        return false;
    }

    public void tick() {
        boolean isMovingZ;
        super.tick();
        ++this.count;
        boolean isMovingX = this.getDeltaMovement().x > 0.0 || this.getDeltaMovement().x < 0.0;
        boolean isMovingY = this.getDeltaMovement().y > 0.0 || this.getDeltaMovement().y < 0.0;
        boolean bl = isMovingZ = this.getDeltaMovement().z > 0.0 || this.getDeltaMovement().z < 0.0;
        if (this.count >= 150) {
            this.discard();
        }
        if (isMovingX || isMovingY || isMovingZ) {
            int greenish = 6604850;
            int bluegreenish = 65350;
            this.level().addParticle((ParticleOptions)new DustParticleOptions(this.count % 2 == 0 ? greenish : bluegreenish, 1.0f), this.getX(), this.getY() + 0.5, this.getZ(), 0.0, 0.0, 0.0);
        } else {
            this.discard();
        }
    }

    @Nullable
    protected ParticleOptions getTrailParticle() {
        return null;
    }

    public void onHitBlock(BlockHitResult result) {
        Level level = this.level();
        if (level instanceof ServerLevel) {
            Optional<Holder.Reference> blockRef;
            ServerLevel serverLevel = (ServerLevel)level;
            BlockState state = this.level().getBlockState(result.getBlockPos().above());
            if (state.getBlock() instanceof CropBlock) {
                CropBlock crop = (CropBlock)state.getBlock();
                crop.growCrops(this.level(), result.getBlockPos().above(), state);
            } else if (this.level().getBlockState(result.getBlockPos()).is(BlockTags.DIRT)) {
                this.level().setBlock(result.getBlockPos(), (BlockState)Blocks.FARMLAND.defaultBlockState().setValue((Property)BlockStateProperties.MOISTURE, (Comparable)Integer.valueOf(7)), 3);
            } else if (this.level().getBlockState(result.getBlockPos()).is(BlockTags.BASE_STONE_OVERWORLD)) {
                this.level().setBlock(result.getBlockPos(), Blocks.DIRT.defaultBlockState(), 3);
            } else if (this.level().getBlockState(result.getBlockPos()).is(BlockTags.LOGS) && (blockRef = BuiltInRegistries.BLOCK.getRandom(this.level().getRandom()).filter(x -> x.is(BlockTags.LOGS))).isPresent()) {
                this.level().setBlock(result.getBlockPos(), ((Block)blockRef.get().value()).defaultBlockState(), 3);
                this.level().playSound(null, result.getBlockPos(), SoundEvents.ENDERMAN_TELEPORT, SoundSource.BLOCKS, 0.75f, 1.0f);
            }
        }
        this.discard();
    }

    public void onHitEntity(EntityHitResult result) {
        Entity entity = result.getEntity();
        if (entity instanceof LivingEntity) {
            LivingEntity livingEntity = (LivingEntity)entity;
            Level level = this.level();
            if (level instanceof ServerLevel) {
                ServerLevel serverLevel = (ServerLevel)level;
                if (livingEntity instanceof Monster) {
                    ((Monster)livingEntity).setNoAi(true);
                    livingEntity.hurtServer(serverLevel, this.damageSources().magic(), 7.0f);
                } else {
                    livingEntity.hurtServer(serverLevel, this.damageSources().magic(), 3.0f);
                }
            }
        }
        this.discard();
    }
}

