/*
 * Decompiled with CFR 0.152.
 */
package net.rk.overpoweredmastery.entity.custom;

import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.DustParticleOptions;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.AbstractHurtingProjectile;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.storage.ValueInput;
import net.minecraft.world.level.storage.ValueOutput;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.common.Tags;
import net.rk.overpoweredmastery.entity.OMEntityTypes;
import org.jetbrains.annotations.Nullable;

public class PurpleWubEnergyBall
extends AbstractHurtingProjectile {
    int count = 0;

    public PurpleWubEnergyBall(double x, double y, double z, Vec3 vector, Level level) {
        super((EntityType)OMEntityTypes.PURPLE_WUB_ENERGY_BALL.get(), x, y, z, vector, level);
    }

    public PurpleWubEnergyBall(LivingEntity livingEntity, Vec3 vector, Level level) {
        super((EntityType)OMEntityTypes.PURPLE_WUB_ENERGY_BALL.get(), livingEntity, vector, level);
    }

    public PurpleWubEnergyBall(EntityType<PurpleWubEnergyBall> redWubEnergyBallEntityType, Level level) {
        super(redWubEnergyBallEntityType, level);
    }

    @Nullable
    public Entity getOwner() {
        Level level;
        if (this.owner != null && (level = this.level()) instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            return (Entity)this.owner.getEntity(uuid1 -> this.findOwner(serverLevel, uuid1), Entity.class);
        }
        return super.getOwner();
    }

    public Entity findOwner(ServerLevel level, UUID uuid) {
        Entity entity = level.getEntity(uuid);
        if (entity != null) {
            return entity;
        }
        for (ServerLevel serverlevel : level.getServer().getAllLevels()) {
            if (serverlevel == level || (entity = serverlevel.getEntity(uuid)) == null) continue;
            return entity;
        }
        return null;
    }

    protected void addAdditionalSaveData(ValueOutput value) {
        super.addAdditionalSaveData(value);
        value.putInt("count", this.count);
    }

    protected void readAdditionalSaveData(ValueInput value) {
        super.readAdditionalSaveData(value);
        this.count = value.getIntOr("count", 0);
    }

    protected boolean shouldBurn() {
        return false;
    }

    public void tick() {
        boolean isMovingZ;
        super.tick();
        ++this.count;
        boolean isMovingX = this.getDeltaMovement().x > 0.0 || this.getDeltaMovement().x < 0.0;
        boolean isMovingY = this.getDeltaMovement().y > 0.0 || this.getDeltaMovement().y < 0.0;
        boolean bl = isMovingZ = this.getDeltaMovement().z > 0.0 || this.getDeltaMovement().z < 0.0;
        if (this.count >= 100) {
            this.discard();
        }
        if (isMovingX || isMovingY || isMovingZ) {
            int greenish = 0xAA00FF;
            int bluegreenish = 0x9000FF;
            this.level().addParticle((ParticleOptions)new DustParticleOptions(this.count % 2 == 0 ? greenish : bluegreenish, 2.0f), this.getX(), this.getY() + 0.5, this.getZ(), 0.0, 0.0, 0.0);
        } else {
            this.discard();
        }
    }

    @Nullable
    protected ParticleOptions getTrailParticle() {
        return null;
    }

    public void onHitBlock(BlockHitResult result) {
        Level level = this.level();
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            BlockPos hitPos = result.getBlockPos();
            if (!this.getOwner().mayInteract(serverLevel, hitPos)) {
                this.discard();
                return;
            }
            if (BlockPos.breadthFirstTraversal((BlockPos)hitPos, (int)8, (int)32, (pos1, consumer) -> {
                for (Direction direction : Direction.values()) {
                    consumer.accept(pos1.relative(direction));
                }
            }, pos -> {
                if (pos.equals((Object)hitPos)) {
                    if (serverLevel.getBlockState(pos).is(Tags.Blocks.STONES)) {
                        if (serverLevel.getRandom().nextIntBetweenInclusive(1, 10) >= 7) {
                            serverLevel.setBlock(pos, Blocks.AIR.defaultBlockState(), 3);
                        }
                    } else if (serverLevel.getBlockState(pos).is(Tags.Blocks.SANDS) || serverLevel.getBlockState(pos).is(Tags.Blocks.SANDSTONE_BLOCKS)) {
                        serverLevel.setBlock(pos, Blocks.AIR.defaultBlockState(), 3);
                    } else if (serverLevel.getBlockState(pos).is(Tags.Blocks.ORES)) {
                        serverLevel.destroyBlock(pos, true, this.getOwner());
                        serverLevel.setBlock(pos, Blocks.COAL_BLOCK.defaultBlockState(), 3);
                    } else if (serverLevel.getBlockState(pos).is(Blocks.COAL_BLOCK)) {
                        serverLevel.destroyBlock(pos, true, this.getOwner());
                        serverLevel.setBlock(pos, Blocks.COAL_BLOCK.defaultBlockState(), 3);
                    } else if (serverLevel.getBlockState(pos).is(Blocks.OBSIDIAN)) {
                        serverLevel.explode(null, (double)pos.getX(), (double)pos.getY(), (double)pos.getZ(), 16.0f, Level.ExplosionInteraction.BLOCK);
                    }
                    return BlockPos.TraversalNodeStatus.ACCEPT;
                }
                return BlockPos.TraversalNodeStatus.SKIP;
            }) > 1) {
                // empty if block
            }
        }
        this.discard();
    }

    public void onHitEntity(EntityHitResult result) {
        Entity entity;
        if (this.getOwner() == null) {
            this.discard();
        }
        if (result.getEntity() != this.getOwner() && (entity = result.getEntity()) instanceof LivingEntity) {
            LivingEntity livingEntity = (LivingEntity)entity;
            Level level = this.level();
            if (level instanceof ServerLevel) {
                ServerLevel serverLevel = (ServerLevel)level;
                if (result.getEntity() instanceof Player && result.getEntity().getTeam() == this.getTeam()) {
                    this.discard();
                }
                if (livingEntity.canFreeze()) {
                    livingEntity.setTicksFrozen(30);
                }
                livingEntity.hurtServer(serverLevel, this.damageSources().magic(), livingEntity.getHealth() - 2.0f);
            }
        }
        this.discard();
    }
}

