/*
 * Decompiled with CFR 0.152.
 */
package net.rk.overpoweredmastery.entity.custom;

import net.minecraft.core.particles.DustParticleOptions;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.projectile.AbstractHurtingProjectile;
import net.minecraft.world.entity.raid.Raider;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.storage.ValueInput;
import net.minecraft.world.level.storage.ValueOutput;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.Vec3;
import net.rk.overpoweredmastery.entity.OMEntityTypes;
import org.jetbrains.annotations.Nullable;

public class RedWubEnergyBall
extends AbstractHurtingProjectile {
    int count = 0;

    public RedWubEnergyBall(double x, double y, double z, Vec3 vector, Level level) {
        super((EntityType)OMEntityTypes.RED_WUB_ENERGY_BALL.get(), x, y, z, vector, level);
    }

    public RedWubEnergyBall(LivingEntity livingEntity, Vec3 vector, Level level) {
        super((EntityType)OMEntityTypes.RED_WUB_ENERGY_BALL.get(), livingEntity, vector, level);
    }

    public RedWubEnergyBall(EntityType<RedWubEnergyBall> redWubEnergyBallEntityType, Level level) {
        super(redWubEnergyBallEntityType, level);
    }

    protected void addAdditionalSaveData(ValueOutput value) {
        super.addAdditionalSaveData(value);
        value.putInt("count", this.count);
    }

    protected void readAdditionalSaveData(ValueInput value) {
        super.readAdditionalSaveData(value);
        this.count = value.getIntOr("count", 0);
    }

    protected boolean shouldBurn() {
        return false;
    }

    public void tick() {
        boolean isMovingZ;
        super.tick();
        ++this.count;
        boolean isMovingX = this.getDeltaMovement().x > 0.0 || this.getDeltaMovement().x < 0.0;
        boolean isMovingY = this.getDeltaMovement().y > 0.0 || this.getDeltaMovement().y < 0.0;
        boolean bl = isMovingZ = this.getDeltaMovement().z > 0.0 || this.getDeltaMovement().z < 0.0;
        if (this.count >= 240) {
            this.discard();
        }
        if (isMovingX || isMovingY || isMovingZ) {
            this.level().addParticle((ParticleOptions)new DustParticleOptions(0xFF0000, 1.0f), this.getX(), this.getY() + 0.5, this.getZ(), 0.0, 0.0, 0.0);
        } else {
            this.discard();
        }
    }

    @Nullable
    protected ParticleOptions getTrailParticle() {
        return null;
    }

    public void onHitBlock(BlockHitResult result) {
        this.level().explode((Entity)this, this.getX(), this.getY(), this.getZ(), 1.0f, Level.ExplosionInteraction.MOB);
        this.discard();
    }

    public void onHitEntity(EntityHitResult result) {
        Entity entity = result.getEntity();
        if (entity instanceof Raider) {
            Level level;
            Raider raider = (Raider)entity;
            if (this.getOwner() instanceof LivingEntity && (level = this.level()) instanceof ServerLevel) {
                ServerLevel serverLevel = (ServerLevel)level;
                raider.hurtServer(serverLevel, this.damageSources().magic(), 5.0f);
                raider.setTarget((LivingEntity)this.getOwner());
                raider.setAggressive(true);
                raider.setRemainingFireTicks(200);
            }
        }
        this.discard();
    }
}

