/*
 * Decompiled with CFR 0.152.
 */
package net.rk.overpoweredmastery.entity.custom;

import java.util.List;
import java.util.stream.Collectors;
import net.minecraft.Util;
import net.minecraft.core.Holder;
import net.minecraft.core.component.DataComponentPatch;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.particles.DustParticleOptions;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.Difficulty;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntitySpawnReason;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.projectile.AbstractHurtingProjectile;
import net.minecraft.world.entity.projectile.ThrownLingeringPotion;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.alchemy.Potion;
import net.minecraft.world.item.alchemy.PotionContents;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.storage.ValueInput;
import net.minecraft.world.level.storage.ValueOutput;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.common.Tags;
import net.neoforged.neoforge.event.EventHooks;
import net.rk.overpoweredmastery.entity.OMEntityTypes;
import net.rk.overpoweredmastery.util.OPUtil;
import org.jetbrains.annotations.Nullable;

public class TrialWubEnergyBall
extends AbstractHurtingProjectile {
    int count = 0;
    private static final EntityDataAccessor<Boolean> DATA_OXIDIZED = SynchedEntityData.defineId(TrialWubEnergyBall.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);

    public TrialWubEnergyBall(double x, double y, double z, Vec3 vector, Level level) {
        super((EntityType)OMEntityTypes.TRIAL_WUB_ENERGY_BALL.get(), x, y, z, vector, level);
    }

    public TrialWubEnergyBall(LivingEntity livingEntity, Vec3 vector, Level level) {
        super((EntityType)OMEntityTypes.TRIAL_WUB_ENERGY_BALL.get(), livingEntity, vector, level);
    }

    public TrialWubEnergyBall(EntityType<TrialWubEnergyBall> energyBallEntityType, Level level) {
        super(energyBallEntityType, level);
    }

    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        super.defineSynchedData(builder);
        builder.define(DATA_OXIDIZED, (Object)false);
    }

    public void setOxidized(boolean oxidizedVersion) {
        this.entityData.set(DATA_OXIDIZED, (Object)oxidizedVersion);
    }

    public boolean getOxidized() {
        return (Boolean)this.entityData.get(DATA_OXIDIZED);
    }

    protected void addAdditionalSaveData(ValueOutput value) {
        super.addAdditionalSaveData(value);
        value.putInt("count", this.count);
        value.putBoolean("oxidized", this.getOxidized());
    }

    protected void readAdditionalSaveData(ValueInput value) {
        super.readAdditionalSaveData(value);
        this.count = value.getIntOr("count", 0);
        this.setOxidized(value.getBooleanOr("oxidized", false));
    }

    protected boolean shouldBurn() {
        return false;
    }

    protected ClipContext.Block getClipType() {
        return ClipContext.Block.OUTLINE;
    }

    public void tick() {
        boolean isMovingZ;
        super.tick();
        ++this.count;
        boolean isMovingX = this.getDeltaMovement().x > 0.0 || this.getDeltaMovement().x < 0.0;
        boolean isMovingY = this.getDeltaMovement().y > 0.0 || this.getDeltaMovement().y < 0.0;
        boolean bl = isMovingZ = this.getDeltaMovement().z > 0.0 || this.getDeltaMovement().z < 0.0;
        if (this.count >= 120) {
            this.discard();
        }
        if (isMovingX || isMovingY || isMovingZ) {
            int lightorangeish = 16761442;
            int orangeish = 16751202;
            int oxidizedDarkCopper = 5279864;
            int oxidizedLightCopper = 7583379;
            if (this.getOxidized()) {
                this.level().addParticle((ParticleOptions)new DustParticleOptions(this.count % 2 == 0 ? oxidizedLightCopper : oxidizedDarkCopper, 1.0f), this.getX(), this.getY() + 0.5, this.getZ(), 0.0, 0.0, 0.0);
            } else {
                this.level().addParticle((ParticleOptions)new DustParticleOptions(this.count % 2 == 0 ? lightorangeish : orangeish, 1.0f), this.getX(), this.getY() + 0.5, this.getZ(), 0.0, 0.0, 0.0);
            }
        } else {
            this.discard();
        }
    }

    @Nullable
    protected ParticleOptions getTrailParticle() {
        return null;
    }

    public void onHitBlock(BlockHitResult result) {
        Level level = this.level();
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            if (!this.getOxidized()) {
                if (OPUtil.nextFloatBetweenInclusive(0.0f, 1.0f) <= 0.02f) {
                    ItemStack lingeringPotion = new ItemStack((ItemLike)Items.LINGERING_POTION);
                    List list = BuiltInRegistries.POTION.listElements().filter(holderrefpotion -> !((Potion)holderrefpotion.value()).getEffects().isEmpty() && this.level().potionBrewing().isBrewablePotion((Holder)holderrefpotion)).collect(Collectors.toList());
                    Holder holder = (Holder)Util.getRandom(list, (RandomSource)this.level().getRandom());
                    DataComponentPatch componentPatch = DataComponentPatch.builder().set(DataComponents.POTION_CONTENTS, (Object)new PotionContents(holder)).set(DataComponents.POTION_DURATION_SCALE, (Object)Float.valueOf(0.02f)).build();
                    lingeringPotion.applyComponents(componentPatch);
                    ThrownLingeringPotion potion = new ThrownLingeringPotion((Level)serverLevel, this.getX(), this.getY(), this.getZ(), lingeringPotion);
                    potion.setSilent(true);
                    potion.setGlowingTag(true);
                    serverLevel.addFreshEntity((Entity)potion);
                }
                boolean canCauseFire = EventHooks.canEntityGrief((ServerLevel)serverLevel, (Entity)this.getOwner()) && !serverLevel.getDifficulty().equals((Object)Difficulty.PEACEFUL);
                serverLevel.explode((Entity)this, this.getX(), this.getY(), this.getZ(), (float)this.level().getRandom().nextIntBetweenInclusive(1, 2), canCauseFire, Level.ExplosionInteraction.BLOCK);
            } else if (serverLevel.getBlockState(result.getBlockPos()).getBlock().getDescriptionId().contains("Copper") || serverLevel.getBlockState(result.getBlockPos()).getBlock().getDescriptionId().contains("Tuff")) {
                serverLevel.playSound((Entity)this, result.getBlockPos(), SoundEvents.ILLUSIONER_CAST_SPELL, SoundSource.NEUTRAL, 1.0f, 1.0f);
                serverLevel.setBlock(result.getBlockPos(), Blocks.AIR.defaultBlockState(), 3);
            } else if (serverLevel.getBlockState(result.getBlockPos()).getBlock().getDescriptionId().contains("Oxidized")) {
                serverLevel.explode((Entity)this, this.getX(), this.getY(), this.getZ(), 10.0f, Level.ExplosionInteraction.TNT);
                serverLevel.explode((Entity)this, this.getX(), this.getY() + 2.0, this.getZ(), 1.15f, Level.ExplosionInteraction.MOB);
                serverLevel.explode((Entity)this, this.getX(), this.getY() - 2.0, this.getZ(), 1.15f, Level.ExplosionInteraction.MOB);
                serverLevel.explode((Entity)this, this.getX() - 2.0, this.getY(), this.getZ(), 1.1f, Level.ExplosionInteraction.MOB);
                serverLevel.explode((Entity)this, this.getX() + 2.0, this.getY(), this.getZ(), 1.1f, Level.ExplosionInteraction.MOB);
                serverLevel.explode((Entity)this, this.getX(), this.getY(), this.getZ() - 2.0, 1.1f, Level.ExplosionInteraction.MOB);
                serverLevel.explode((Entity)this, this.getX(), this.getY(), this.getZ() + 2.0, 1.1f, Level.ExplosionInteraction.MOB);
            }
        }
        this.discard();
    }

    public void onHitEntity(EntityHitResult result) {
        Level level = result.getEntity().level();
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            result.getEntity().setDeltaMovement(0.0, result.getEntity().getDeltaMovement().y * 2.0, 0.0);
            if (result.getEntity() instanceof LivingEntity && this.getOxidized() && BuiltInRegistries.ENTITY_TYPE.getRandom(serverLevel.getRandom()).isPresent()) {
                if (!(((EntityType)((Holder.Reference)BuiltInRegistries.ENTITY_TYPE.getRandom(serverLevel.getRandom()).get()).value()).is(Tags.EntityTypes.BOSSES) || ((EntityType)((Holder.Reference)BuiltInRegistries.ENTITY_TYPE.getRandom(serverLevel.getRandom()).get()).value()).is(Tags.EntityTypes.BOATS) || ((EntityType)((Holder.Reference)BuiltInRegistries.ENTITY_TYPE.getRandom(serverLevel.getRandom()).get()).value()).is(Tags.EntityTypes.MINECARTS))) {
                    this.discard();
                    return;
                }
                Entity copyEntity = result.getEntity();
                copyEntity.remove(Entity.RemovalReason.DISCARDED);
                Entity entity = ((EntityType)((Holder.Reference)BuiltInRegistries.ENTITY_TYPE.getRandom(serverLevel.getRandom()).get()).value()).create(serverLevel, null, copyEntity.getOnPos(), EntitySpawnReason.MOB_SUMMONED, true, false);
                serverLevel.addFreshEntity(entity);
            }
        }
        this.discard();
    }
}

