/*
 * Decompiled with CFR 0.152.
 */
package net.rk.overpoweredmastery.event;

import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.event.level.BlockEvent;
import net.rk.overpoweredmastery.Config;
import net.rk.overpoweredmastery.datagen.OMTags;
import net.rk.overpoweredmastery.item.OMItems;
import net.rk.overpoweredmastery.util.OPUtil;

@EventBusSubscriber(modid="overpoweredmastery")
public class OMWorldEvents {
    @SubscribeEvent
    public static void onBreakBlock(BlockEvent.BreakEvent event) {
        if (!event.isCanceled() && !event.getPlayer().isCreative()) {
            try {
                LevelAccessor levelAccessor = event.getLevel();
                if (levelAccessor instanceof ServerLevel) {
                    ServerLevel serverLevel = (ServerLevel)levelAccessor;
                    if (!event.getPlayer().blockActionRestricted((Level)serverLevel, event.getPos(), event.getPlayer().gameMode()) && event.getState().is(OMTags.CAN_DROP_STRANGE_STONE) && !((Double)Config.STRANGE_STONE_DROP_CHANCE.get()).isNaN() && !((Double)Config.STRANGE_STONE_DROP_CHANCE.get()).isInfinite() && serverLevel.getRandom().nextDouble() <= Config.STRANGE_STONE_DROP_CHANCE.getAsDouble()) {
                        int fortuneLevel = event.getPlayer().getItemInHand(event.getPlayer().getUsedItemHand()).getEnchantmentLevel(OPUtil.getEnchantmentHolderFromKeyStatic((Level)serverLevel, (ResourceKey<Enchantment>)Enchantments.FORTUNE));
                        int hasSilkTouch = event.getPlayer().getItemInHand(event.getPlayer().getUsedItemHand()).getEnchantmentLevel(OPUtil.getEnchantmentHolderFromKeyStatic((Level)serverLevel, (ResourceKey<Enchantment>)Enchantments.SILK_TOUCH));
                        if (hasSilkTouch > 0) {
                            return;
                        }
                        if (fortuneLevel > 0) {
                            if (fortuneLevel > 10) {
                                fortuneLevel = 10;
                            }
                            for (int xtraItem = 0; xtraItem < fortuneLevel; ++xtraItem) {
                                serverLevel.addFreshEntity((Entity)new ItemEntity((Level)serverLevel, (double)event.getPos().getX(), (double)event.getPos().getY(), (double)event.getPos().getZ(), new ItemStack((ItemLike)OMItems.STRANGE_STONE.asItem())));
                            }
                        } else {
                            serverLevel.addFreshEntity((Entity)new ItemEntity((Level)serverLevel, (double)event.getPos().getX(), (double)event.getPos().getY(), (double)event.getPos().getZ(), new ItemStack((ItemLike)OMItems.STRANGE_STONE.asItem())));
                        }
                    }
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }
}

