/*
 * Decompiled with CFR 0.152.
 */
package net.rk.overpoweredmastery.item.custom;

import java.util.function.Consumer;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ItemUtils;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.component.TooltipDisplay;
import net.minecraft.world.level.Level;

public abstract class AbstractSpear
extends Item {
    public static final ResourceLocation BASE_SPEAR_REACH = ResourceLocation.fromNamespaceAndPath((String)"overpoweredmastery", (String)"base_spear_reach");

    public AbstractSpear(Item.Properties properties) {
        super(properties.stacksTo(1));
    }

    public ItemStack finishUsingItem(ItemStack stack, Level level, LivingEntity livingEntity) {
        return stack;
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext context, TooltipDisplay tooltipDisplay, Consumer<Component> tooltipAdder, TooltipFlag flag) {
        tooltipAdder.accept((Component)Component.translatable((String)"item.overpoweredmastery.spear.desc").withStyle(ChatFormatting.GRAY));
    }

    public InteractionResult use(Level level, Player player, InteractionHand hand) {
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            return ItemUtils.startUsingInstantly((Level)level, (Player)player, (InteractionHand)hand);
        }
        return InteractionResult.SUCCESS;
    }

    public boolean releaseUsing(ItemStack stack, Level level, LivingEntity entity, int timeLeft) {
        return true;
    }

    public void onUseTick(Level level, LivingEntity livingEntity, ItemStack stack, int remainingUseDuration) {
        this.extraOnUseTick(level, livingEntity, stack, remainingUseDuration);
    }

    public abstract void extraOnUseTick(Level var1, LivingEntity var2, ItemStack var3, int var4);
}

