/*
 * Decompiled with CFR 0.152.
 */
package net.rk.overpoweredmastery.item.custom;

import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Predicate;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.particles.DustParticleOptions;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.ARGB;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ItemUtils;
import net.minecraft.world.item.ProjectileWeaponItem;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.component.TooltipDisplay;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.neoforged.neoforge.common.Tags;
import net.rk.overpoweredmastery.datagen.OMEnchantments;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractStaff
extends ProjectileWeaponItem {
    public static final ResourceLocation STAFF_MOVEMENT_SPEED_MODIFIER = ResourceLocation.fromNamespaceAndPath((String)"overpoweredmastery", (String)"staff_movement_speed");
    public static final ResourceLocation STAFF_BLOCK_REACH_MODIFIER = ResourceLocation.fromNamespaceAndPath((String)"overpoweredmastery", (String)"staff_block_reach");
    public static final ResourceLocation STAFF_ENTITY_REACH_MODIFIER = ResourceLocation.fromNamespaceAndPath((String)"overpoweredmastery", (String)"staff_entity_reach");
    public static final ResourceLocation STAFF_SAFE_FALL_DISTANCE = ResourceLocation.fromNamespaceAndPath((String)"overpoweredmastery", (String)"staff_safe_fall_distance");
    public static final ResourceLocation STAFF_FALL_DAMAGE_MULTIPLIER = ResourceLocation.fromNamespaceAndPath((String)"overpoweredmastery", (String)"staff_fall_damage_multiplier");

    public AbstractStaff(Item.Properties p) {
        super(p.stacksTo(1));
    }

    public boolean makesPiglinsNeutral(ItemStack stack, LivingEntity wearer) {
        return true;
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext context, TooltipDisplay tooltipDisplay, Consumer<Component> tooltipAdder, TooltipFlag flag) {
        tooltipAdder.accept((Component)Component.translatable((String)"item.overpoweredmastery.staff.desc"));
    }

    public ItemStack finishUsingItem(ItemStack stack, Level level, LivingEntity livingEntity) {
        return stack;
    }

    public boolean releaseUsing(ItemStack stack, Level level, LivingEntity livingEntity, int timeLeft) {
        return true;
    }

    public InteractionResult use(Level level, Player player, InteractionHand hand) {
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            return ItemUtils.startUsingInstantly((Level)level, (Player)player, (InteractionHand)hand);
        }
        return InteractionResult.SUCCESS;
    }

    public boolean supportsEnchantment(ItemStack stack, Holder<Enchantment> enchantment) {
        return enchantment.is(OMEnchantments.INSTAREPAIR) || enchantment.is(Enchantments.UNBREAKING) || enchantment.is(Enchantments.MENDING) || enchantment.is(Tags.Enchantments.INCREASE_ENTITY_DROPS);
    }

    public void onUseTick(Level level, LivingEntity livingEntity, ItemStack stack, int remainingUseDuration) {
        if (livingEntity.getAttributes().hasAttribute(Attributes.MOVEMENT_SPEED) && livingEntity.getAttributes().getValue(Attributes.MOVEMENT_SPEED) < 0.7 && livingEntity.isUsingItem() && !livingEntity.hasEffect(MobEffects.SPEED)) {
            livingEntity.addEffect(new MobEffectInstance(MobEffects.SPEED, 10, 2, true, false, false));
        }
        this.extraOnUse(level, livingEntity, stack, remainingUseDuration);
    }

    public abstract void extraOnUse(Level var1, LivingEntity var2, ItemStack var3, int var4);

    public abstract void action(Level var1, LivingEntity var2, ItemStack var3, int var4, int var5);

    public void staffDefaultParticles(Level level, LivingEntity livingEntity) {
        int allTheColors = ARGB.color((int)Mth.randomBetweenInclusive((RandomSource)level.getRandom(), (int)0, (int)255), (int)Mth.randomBetweenInclusive((RandomSource)level.getRandom(), (int)0, (int)255), (int)Mth.randomBetweenInclusive((RandomSource)level.getRandom(), (int)0, (int)255));
        if (livingEntity.getUsedItemHand() == InteractionHand.MAIN_HAND) {
            double x = livingEntity.getDeltaMovement().x;
            double z = livingEntity.getDeltaMovement().z;
            if (x < 0.0 && z < 0.0) {
                level.addParticle((ParticleOptions)new DustParticleOptions(allTheColors, 1.0f), livingEntity.getX() + 0.3, livingEntity.getY() + 2.5, livingEntity.getZ() + 0.3, 0.0, 1.0, 0.0);
            } else if (x > 0.0 && z < 0.0) {
                level.addParticle((ParticleOptions)new DustParticleOptions(allTheColors, 1.0f), livingEntity.getX() + 0.3, livingEntity.getY() + 2.5, livingEntity.getZ() + 0.3, 0.0, 1.0, 0.0);
            } else if (x > 0.0 && z > 0.0) {
                level.addParticle((ParticleOptions)new DustParticleOptions(allTheColors, 1.0f), livingEntity.getX() + 0.3, livingEntity.getY() + 2.5, livingEntity.getZ() - 0.3, 0.0, 1.0, 0.0);
            } else if (x < 0.0 && z > 0.0) {
                level.addParticle((ParticleOptions)new DustParticleOptions(allTheColors, 1.0f), livingEntity.getX() + 0.3, livingEntity.getY() + 2.5, livingEntity.getZ() + 0.3, 0.0, 1.0, 0.0);
            } else {
                level.addParticle((ParticleOptions)new DustParticleOptions(allTheColors, 1.0f), livingEntity.getX(), livingEntity.getY() + 2.5, livingEntity.getZ(), 0.0, 1.0, 0.0);
            }
        } else if (livingEntity.getUsedItemHand() == InteractionHand.OFF_HAND) {
            level.addParticle((ParticleOptions)new DustParticleOptions(allTheColors, 1.0f), livingEntity.getX() + (double)livingEntity.yHeadRot, livingEntity.getY() + 2.5, livingEntity.getZ() - (double)livingEntity.yHeadRot, 0.0, 1.0, 0.0);
        }
    }

    public Predicate<ItemStack> getAllSupportedProjectiles() {
        return stack -> stack.getItem() instanceof Item;
    }

    public int getDefaultProjectileRange() {
        return 100;
    }

    protected void shootProjectile(LivingEntity shooter, Projectile projectile, int index, float velocity, float inaccuracy, float angle, @Nullable LivingEntity target) {
        shooter.playSound(SoundEvents.ILLUSIONER_CAST_SPELL, 0.5f, shooter.getRandom().triangle(0.87f, 1.0f));
    }

    public List<BlockPos> getClippingBlocks(int blockRangeX, int blockRangeY, int blockRangeZ, ClipContext.Fluid allowedFluidClipType, ClipContext.Block allowedBlockClipType, BlockPos start, ServerPlayer serverPlayer) {
        ArrayList<BlockPos> clippingBlocks = new ArrayList<BlockPos>();
        BlockHitResult result = serverPlayer.level().clip(new ClipContext(serverPlayer.getEyePosition(1.0f), serverPlayer.getEyePosition(1.0f).add(serverPlayer.getViewVector(1.0f).scale(6.0)), allowedBlockClipType, allowedFluidClipType, (Entity)serverPlayer));
        Direction resultDir = result.getDirection();
        double resultDist = result.getBlockPos().distToCenterSqr((double)start.getX(), (double)start.getY(), (double)start.getZ());
        if (result.getType() == HitResult.Type.MISS) {
            return clippingBlocks;
        }
        for (int x = -blockRangeX; x <= blockRangeX; ++x) {
            for (int y = -blockRangeY; y <= blockRangeY; ++y) {
                for (int z = -blockRangeZ; z <= blockRangeZ; ++z) {
                    int posZ;
                    int posY;
                    int posX;
                    if (resultDir == Direction.DOWN || resultDir == Direction.UP) {
                        posX = start.getX() + x;
                        posY = start.getY() + z;
                        posZ = start.getZ() + y;
                        clippingBlocks.add(new BlockPos(posX, posY, posZ));
                    }
                    if (resultDir == Direction.NORTH || resultDir == Direction.SOUTH) {
                        posX = start.getX() + x;
                        posY = start.getY() + y;
                        posZ = start.getZ() + z;
                        clippingBlocks.add(new BlockPos(posX, posY, posZ));
                    }
                    if (resultDir != Direction.EAST && resultDir != Direction.WEST) continue;
                    posX = start.getX() + z;
                    posY = start.getY() + y;
                    posZ = start.getZ() + x;
                    clippingBlocks.add(new BlockPos(posX, posY, posZ));
                }
            }
        }
        return clippingBlocks;
    }
}

