/*
 * Decompiled with CFR 0.152.
 */
package net.rk.overpoweredmastery.item.custom;

import java.util.function.Consumer;
import java.util.function.Predicate;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ItemUtils;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.component.TooltipDisplay;
import net.minecraft.world.level.Level;
import net.rk.overpoweredmastery.OverpoweredMastery;
import net.rk.overpoweredmastery.entity.custom.ChickenWubEnergyBall;
import net.rk.overpoweredmastery.item.custom.AbstractWubs;
import org.jetbrains.annotations.Nullable;

public class ChickenWubs
extends AbstractWubs {
    public ChickenWubs(Item.Properties p) {
        super(p.enchantable(16).rarity(Rarity.EPIC));
    }

    @Override
    public void appendHoverText(ItemStack stack, Item.TooltipContext context, TooltipDisplay tooltipDisplay, Consumer<Component> tooltipAdder, TooltipFlag flag) {
        super.appendHoverText(stack, context, tooltipDisplay, tooltipAdder, flag);
        tooltipAdder.accept((Component)Component.translatable((String)"item.overpoweredmastery.chicken_wubs.desc").withColor(0xFF0060));
    }

    public int getUseDuration(ItemStack stack, LivingEntity entity) {
        return 1000;
    }

    @Override
    public ItemStack finishUsingItem(ItemStack stack, Level level, LivingEntity livingEntity) {
        livingEntity.setData(OverpoweredMastery.USING_WUB_ITEM, (Object)false);
        return stack;
    }

    @Override
    public boolean releaseUsing(ItemStack stack, Level level, LivingEntity livingEntity, int timeLeft) {
        return true;
    }

    public void onUseTick(Level level, LivingEntity livingEntity, ItemStack stack, int remainingUseDuration) {
        if (livingEntity instanceof Player) {
            if (!((Boolean)livingEntity.getData(OverpoweredMastery.USING_WUB_ITEM)).booleanValue()) {
                livingEntity.setData(OverpoweredMastery.USING_WUB_ITEM, (Object)true);
            }
            if (level instanceof ServerLevel) {
                ServerLevel serverLevel = (ServerLevel)level;
                if (remainingUseDuration % 7 == 0 && remainingUseDuration < 994 && !((Player)livingEntity).isSecondaryUseActive()) {
                    ChickenWubEnergyBall fireball = new ChickenWubEnergyBall(livingEntity, livingEntity.getViewVector((float)remainingUseDuration), level);
                    fireball.setPos(fireball.getX(), livingEntity.getEyeY() - 0.5, fireball.getZ());
                    serverLevel.addFreshEntity((Entity)fireball);
                    if (!livingEntity.hasEffect(MobEffects.SPEED)) {
                        livingEntity.addEffect(new MobEffectInstance(MobEffects.SPEED, 14, 12, true, false));
                    }
                    if (!livingEntity.hasEffect(MobEffects.SLOW_FALLING)) {
                        livingEntity.addEffect(new MobEffectInstance(MobEffects.SLOW_FALLING, 24, 2, true, false));
                    }
                }
            }
        }
    }

    @Override
    public InteractionResult use(Level level, Player player, InteractionHand hand) {
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            return ItemUtils.startUsingInstantly((Level)level, (Player)player, (InteractionHand)hand);
        }
        return InteractionResult.SUCCESS;
    }

    @Override
    public Predicate<ItemStack> getAllSupportedProjectiles() {
        return stack -> stack.getItem() instanceof Item;
    }

    public int getDefaultProjectileRange() {
        return 42;
    }

    @Override
    protected void shootProjectile(LivingEntity shooter, Projectile projectile, int index, float velocity, float inaccuracy, float angle, @Nullable LivingEntity target) {
        if (shooter instanceof Player) {
            // empty if block
        }
    }
}

