/*
 * Decompiled with CFR 0.152.
 */
package net.rk.overpoweredmastery.item.custom;

import java.util.function.Consumer;
import java.util.function.Predicate;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ItemUseAnimation;
import net.minecraft.world.item.ItemUtils;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.component.TooltipDisplay;
import net.minecraft.world.level.Level;
import net.rk.overpoweredmastery.OverpoweredMastery;
import net.rk.overpoweredmastery.entity.custom.PurpleWubEnergyBall;
import net.rk.overpoweredmastery.item.custom.AbstractWubs;
import org.jetbrains.annotations.Nullable;

public class PurpleWubs
extends AbstractWubs {
    public PurpleWubs(Item.Properties p) {
        super(p.fireResistant().enchantable(42).rarity(Rarity.EPIC).stacksTo(1));
    }

    @Override
    public void appendHoverText(ItemStack stack, Item.TooltipContext context, TooltipDisplay tooltipDisplay, Consumer<Component> tooltipAdder, TooltipFlag flag) {
        super.appendHoverText(stack, context, tooltipDisplay, tooltipAdder, flag);
        tooltipAdder.accept((Component)Component.translatable((String)"item.overpoweredmastery.purple_wubs.desc").withStyle(ChatFormatting.DARK_PURPLE));
    }

    public int getUseDuration(ItemStack stack, LivingEntity entity) {
        return 1000;
    }

    public ItemUseAnimation getUseAnimation(ItemStack stack) {
        return ItemUseAnimation.NONE;
    }

    @Override
    public ItemStack finishUsingItem(ItemStack stack, Level level, LivingEntity livingEntity) {
        livingEntity.setData(OverpoweredMastery.USING_WUB_ITEM, (Object)false);
        return stack;
    }

    @Override
    public boolean releaseUsing(ItemStack stack, Level level, LivingEntity livingEntity, int timeLeft) {
        return true;
    }

    public void onUseTick(Level level, LivingEntity livingEntity, ItemStack stack, int remainingUseDuration) {
        if (livingEntity instanceof Player) {
            if (!((Boolean)livingEntity.getData(OverpoweredMastery.USING_WUB_ITEM)).booleanValue()) {
                livingEntity.setData(OverpoweredMastery.USING_WUB_ITEM, (Object)true);
            }
            if (level instanceof ServerLevel) {
                ServerLevel serverLevel = (ServerLevel)level;
                if (remainingUseDuration % 40 == 0 && remainingUseDuration < 998 && !((Player)livingEntity).isSecondaryUseActive()) {
                    if (!livingEntity.hasEffect(MobEffects.SPEED)) {
                        livingEntity.addEffect(new MobEffectInstance(MobEffects.SPEED, 39, 12, true, false));
                    }
                    if (!livingEntity.hasEffect(MobEffects.RESISTANCE)) {
                        livingEntity.addEffect(new MobEffectInstance(MobEffects.RESISTANCE, 100, 100, true, false, true));
                    }
                    if (!livingEntity.hasEffect(MobEffects.ABSORPTION)) {
                        livingEntity.addEffect(new MobEffectInstance(MobEffects.ABSORPTION, 200, 10, true, false, true));
                    }
                    PurpleWubEnergyBall fireball = new PurpleWubEnergyBall(livingEntity, livingEntity.getViewVector((float)remainingUseDuration), level);
                    fireball.setPos(fireball.getX(), livingEntity.getEyeY() - 0.5, fireball.getZ());
                    serverLevel.addFreshEntity((Entity)fireball);
                }
            }
        }
    }

    @Override
    public InteractionResult use(Level level, Player player, InteractionHand hand) {
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            return ItemUtils.startUsingInstantly((Level)level, (Player)player, (InteractionHand)hand);
        }
        return InteractionResult.SUCCESS;
    }

    @Override
    public Predicate<ItemStack> getAllSupportedProjectiles() {
        return stack -> stack.getItem() instanceof Item;
    }

    public int getDefaultProjectileRange() {
        return 72;
    }

    @Override
    protected void shootProjectile(LivingEntity shooter, Projectile projectile, int index, float velocity, float inaccuracy, float angle, @Nullable LivingEntity target) {
    }
}

