/*
 * Decompiled with CFR 0.152.
 */
package net.rk.overpoweredmastery.item.custom;

import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.component.DataComponents;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.stats.Stats;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.TagKey;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntitySelector;
import net.minecraft.world.entity.EquipmentSlotGroup;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.entity.projectile.windcharge.WindCharge;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.ToolMaterial;
import net.minecraft.world.item.component.ItemAttributeModifiers;
import net.minecraft.world.item.component.Tool;
import net.minecraft.world.item.component.Weapon;
import net.minecraft.world.item.enchantment.Enchantable;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.common.Tags;
import net.rk.overpoweredmastery.datagen.OMEnchantments;
import net.rk.overpoweredmastery.datagen.OMTags;
import net.rk.overpoweredmastery.item.custom.AbstractSpear;
import net.rk.overpoweredmastery.util.OPUtil;

public class SpearItem
extends AbstractSpear {
    public SpearItem(Item.Properties properties) {
        super(properties.component(DataComponents.WEAPON, (Object)new Weapon(1, 2.0f)).component(DataComponents.BREAK_SOUND, (Object)Holder.direct((Object)((SoundEvent)SoundEvents.ARMOR_EQUIP_GENERIC.value()))).component(DataComponents.ENCHANTABLE, (Object)new Enchantable(5)).repairable(Items.LEATHER).durability(1999).tool(ToolMaterial.GOLD, BlockTags.SWORD_INSTANTLY_MINES, 1.0f, 2.0f, 1.0f).attributes(ItemAttributeModifiers.builder().add(Attributes.ENTITY_INTERACTION_RANGE, new AttributeModifier(BASE_SPEAR_REACH, 2.5, AttributeModifier.Operation.ADD_VALUE), EquipmentSlotGroup.HAND).add(Attributes.ATTACK_DAMAGE, new AttributeModifier(Item.BASE_ATTACK_DAMAGE_ID, 2.0, AttributeModifier.Operation.ADD_VALUE), EquipmentSlotGroup.HAND).add(Attributes.ATTACK_SPEED, new AttributeModifier(Item.BASE_ATTACK_SPEED_ID, 2.0, AttributeModifier.Operation.ADD_VALUE), EquipmentSlotGroup.HAND).build()));
    }

    public SpearItem(Item.Properties properties, ResourceKey id, int damage, float speed, Weapon weapon, Holder<SoundEvent> breakSound, Enchantable enchantable, Tool tool, int usesTillBreak, Item repairItem) {
        super(properties.setId(id).component(DataComponents.WEAPON, (Object)weapon).component(DataComponents.BREAK_SOUND, breakSound).component(DataComponents.ENCHANTABLE, (Object)enchantable).component(DataComponents.TOOL, (Object)tool).repairable(repairItem).durability(usesTillBreak).attributes(ItemAttributeModifiers.builder().add(Attributes.ENTITY_INTERACTION_RANGE, new AttributeModifier(BASE_SPEAR_REACH, 2.5, AttributeModifier.Operation.ADD_VALUE), EquipmentSlotGroup.HAND).add(Attributes.ATTACK_DAMAGE, new AttributeModifier(Item.BASE_ATTACK_DAMAGE_ID, (double)damage, AttributeModifier.Operation.ADD_VALUE), EquipmentSlotGroup.HAND).add(Attributes.ATTACK_SPEED, new AttributeModifier(Item.BASE_ATTACK_SPEED_ID, (double)speed, AttributeModifier.Operation.ADD_VALUE), EquipmentSlotGroup.HAND).build()));
    }

    public SpearItem(Item.Properties properties, ResourceKey id, int damage, float speed, Weapon weapon, Holder<SoundEvent> breakSound, Enchantable enchantable, Tool tool, int usesTillBreak, TagKey<Item> repairTag) {
        super(properties.setId(id).component(DataComponents.WEAPON, (Object)weapon).component(DataComponents.BREAK_SOUND, breakSound).component(DataComponents.ENCHANTABLE, (Object)enchantable).component(DataComponents.TOOL, (Object)tool).repairable(repairTag).durability(usesTillBreak).attributes(ItemAttributeModifiers.builder().add(Attributes.ENTITY_INTERACTION_RANGE, new AttributeModifier(BASE_SPEAR_REACH, 2.5, AttributeModifier.Operation.ADD_VALUE), EquipmentSlotGroup.HAND).add(Attributes.ATTACK_DAMAGE, new AttributeModifier(Item.BASE_ATTACK_DAMAGE_ID, (double)damage, AttributeModifier.Operation.ADD_VALUE), EquipmentSlotGroup.HAND).add(Attributes.ATTACK_SPEED, new AttributeModifier(Item.BASE_ATTACK_SPEED_ID, (double)speed, AttributeModifier.Operation.ADD_VALUE), EquipmentSlotGroup.HAND).build()));
    }

    public boolean supportsEnchantment(ItemStack stack, Holder<Enchantment> enchantment) {
        return enchantment.is(OMTags.SPEAR_SUPPORTED) || enchantment.is(OMEnchantments.INSTAREPAIR) || enchantment.is(Enchantments.MENDING) || enchantment.is(Tags.Enchantments.INCREASE_ENTITY_DROPS) || enchantment.is(Tags.Enchantments.WEAPON_DAMAGE_ENHANCEMENTS);
    }

    public int getUseDuration(ItemStack stack, LivingEntity entity) {
        return 1700;
    }

    public boolean onEntitySwing(ItemStack stack, LivingEntity entity, InteractionHand hand) {
        Player player;
        if (entity instanceof Player && (player = (Player)entity).getCooldowns().isOnCooldown(stack)) {
            entity.stopUsingItem();
            return false;
        }
        if (entity.getUseItemRemainingTicks() <= 40) {
            if (stack.getEnchantmentLevel(OPUtil.getEnchantmentHolderFromKeyStatic(entity.level(), (ResourceKey<Enchantment>)Enchantments.RIPTIDE)) > 0 && entity.isSwimming()) {
                int riptideLevel = stack.getEnchantmentLevel(OPUtil.getEnchantmentHolderFromKeyStatic(entity.level(), (ResourceKey<Enchantment>)Enchantments.RIPTIDE));
                entity.addDeltaMovement(entity.getLookAngle().multiply(1.0 + (double)riptideLevel, 0.0, 1.0 + (double)riptideLevel).normalize().scale(0.41 / (entity.getAttributeValue(Attributes.MOVEMENT_EFFICIENCY) + 1.0)));
                if (stack.getEnchantmentLevel(OPUtil.getEnchantmentHolderFromKeyStatic(entity.level(), (ResourceKey<Enchantment>)Enchantments.UNBREAKING)) > 0) {
                    int unbreakingLevel = stack.getEnchantmentLevel(OPUtil.getEnchantmentHolderFromKeyStatic(entity.level(), (ResourceKey<Enchantment>)Enchantments.UNBREAKING));
                    if ((unbreakingLevel = Mth.clamp((int)unbreakingLevel, (int)1, (int)99)) * 10 % 100 != 0) {
                        stack.hurtAndBreak(riptideLevel + 1, entity, entity.getUsedItemHand());
                    }
                } else {
                    stack.hurtAndBreak(riptideLevel + 1, entity, entity.getUsedItemHand());
                }
                if (entity instanceof Player) {
                    Player player2 = (Player)entity;
                    player2.getCooldowns().addCooldown(stack, 15);
                }
                return true;
            }
            if (stack.getEnchantmentLevel(OPUtil.getEnchantmentHolderFromKeyStatic(entity.level(), (ResourceKey<Enchantment>)Enchantments.WIND_BURST)) > 0) {
                Player player3;
                int chargeLevel = stack.getEnchantmentLevel(OPUtil.getEnchantmentHolderFromKeyStatic(entity.level(), (ResourceKey<Enchantment>)Enchantments.WIND_BURST));
                if (entity instanceof Player && (player3 = (Player)entity).getCooldowns().isOnCooldown(stack)) {
                    return true;
                }
                Level level = entity.level();
                if (level instanceof ServerLevel) {
                    ServerLevel serverLevel = (ServerLevel)level;
                    if (entity instanceof Player) {
                        Player player4 = (Player)entity;
                        Projectile.spawnProjectileFromRotation((lvl, entity1, stack1) -> new WindCharge(player4, (Level)serverLevel, player4.position().x(), player4.getEyePosition().y(), player4.position().z()), (ServerLevel)serverLevel, (ItemStack)stack, (LivingEntity)player4, (float)0.0f, (float)(0.75f + (float)chargeLevel / 10.0f), (float)0.125f);
                        player4.awardStat(Stats.ITEM_USED.get((Object)this));
                        if (stack.getEnchantmentLevel(OPUtil.getEnchantmentHolderFromKeyStatic(entity.level(), (ResourceKey<Enchantment>)Enchantments.UNBREAKING)) > 0) {
                            int unbreakingLevel = stack.getEnchantmentLevel(OPUtil.getEnchantmentHolderFromKeyStatic(entity.level(), (ResourceKey<Enchantment>)Enchantments.UNBREAKING));
                            if ((unbreakingLevel = Mth.clamp((int)unbreakingLevel, (int)1, (int)99)) * 10 % 100 != 0) {
                                stack.hurtAndBreak(2, (LivingEntity)player4, hand);
                            }
                        } else {
                            stack.hurtAndBreak(2, (LivingEntity)player4, hand);
                        }
                        player4.getCooldowns().addCooldown(stack, 27);
                    }
                }
            }
            return true;
        }
        return false;
    }

    public void onStopUsing(ItemStack stack, LivingEntity entity, int count) {
        if (entity instanceof Player) {
            Player player = (Player)entity;
            int timeAccumulated = (int)((float)entity.getTicksUsingItem() / 5.0f);
            int clampedTime = Mth.clamp((int)(20 + timeAccumulated), (int)20, (int)200);
            player.getCooldowns().addCooldown(stack, clampedTime);
        }
    }

    @Override
    public void extraOnUseTick(Level level, LivingEntity livingEntity, ItemStack itemStack, int remainingDuration) {
        Player player;
        if (livingEntity instanceof Player && (player = (Player)livingEntity).getCooldowns().isOnCooldown(itemStack)) {
            livingEntity.stopUsingItem();
            return;
        }
        if (livingEntity.getUseItemRemainingTicks() <= 0) {
            livingEntity.stopUsingItem();
            return;
        }
        if (remainingDuration >= 40 && !livingEntity.isSwimming()) {
            double effSpeed = livingEntity.getAttributeValue(Attributes.MOVEMENT_EFFICIENCY);
            double limitLow = -8.0;
            double limitHigh = 8.0;
            if (level.isRainingAt(livingEntity.getOnPos().above()) && itemStack.getEnchantmentLevel(OPUtil.getEnchantmentHolderFromKeyStatic(livingEntity.level(), (ResourceKey<Enchantment>)Enchantments.RIPTIDE)) > 0) {
                if (livingEntity.getDeltaMovement().x > limitLow && livingEntity.getDeltaMovement().x < limitHigh && livingEntity.getDeltaMovement().z > limitLow && livingEntity.getDeltaMovement().z < limitHigh && livingEntity.getDeltaMovement().y > limitLow && livingEntity.getDeltaMovement().y < limitHigh) {
                    livingEntity.addDeltaMovement(livingEntity.getLookAngle().multiply(0.75, 0.75, 0.75).normalize().scale(0.2 / (effSpeed + 1.0)));
                }
            } else if (!livingEntity.isJumping() && livingEntity.onGround()) {
                livingEntity.addDeltaMovement(livingEntity.getLookAngle().multiply(1.0, 0.0, 1.0).normalize().scale(0.2 / (effSpeed + 1.0)));
            }
            if (livingEntity.getDeltaMovement().x != 0.0 || livingEntity.getDeltaMovement().z != 0.0) {
                if (itemStack.getEnchantmentLevel(OPUtil.getEnchantmentHolderFromKeyStatic(livingEntity.level(), (ResourceKey<Enchantment>)Enchantments.UNBREAKING)) > 0) {
                    int unbreakingLevel = itemStack.getEnchantmentLevel(OPUtil.getEnchantmentHolderFromKeyStatic(livingEntity.level(), (ResourceKey<Enchantment>)Enchantments.UNBREAKING));
                    if ((unbreakingLevel = Mth.clamp((int)unbreakingLevel, (int)1, (int)99)) * 10 % 100 != 0) {
                        itemStack.hurtAndBreak(1, livingEntity, livingEntity.getUsedItemHand());
                    }
                } else {
                    itemStack.hurtAndBreak(1, livingEntity, livingEntity.getUsedItemHand());
                }
            }
        }
        AABB boxToCheckForEntities = AABB.ofSize((Vec3)livingEntity.getOnPos().getCenter(), (double)4.0, (double)2.0, (double)4.0);
        AABB boxToCheckForBlocks = AABB.ofSize((Vec3)new BlockPos(livingEntity.getBlockX(), livingEntity.getBlockY(), livingEntity.getBlockZ()).getBottomCenter(), (double)3.35, (double)2.5, (double)3.35);
        List blockPoses = BlockPos.betweenClosedStream((AABB)boxToCheckForBlocks).toList();
        if (!level.getEntities((Entity)livingEntity, boxToCheckForEntities, EntitySelector.NO_CREATIVE_OR_SPECTATOR).isEmpty()) {
            List entities = level.getEntities((Entity)livingEntity, boxToCheckForEntities, EntitySelector.NO_CREATIVE_OR_SPECTATOR);
            for (Entity entity : entities) {
                if (!livingEntity.isUsingItem()) continue;
                int deltaBasedDamage = 1 + (int)Math.round(livingEntity.getDeltaMovement().x * livingEntity.getDeltaMovement().z);
                int additiveDamage = 0;
                if (!itemStack.getAttributeModifiers().modifiers().isEmpty()) {
                    for (ItemAttributeModifiers.Entry entry : itemStack.getAttributeModifiers().modifiers()) {
                        if (!entry.attribute().is(Attributes.ATTACK_DAMAGE) || !(entry.modifier().amount() > 0.0)) continue;
                        additiveDamage = (int)Math.round(entry.modifier().amount());
                    }
                }
                if (itemStack.getEnchantmentLevel(OPUtil.getEnchantmentHolderFromKeyStatic(level, (ResourceKey<Enchantment>)Enchantments.IMPALING)) > 0) {
                    deltaBasedDamage += itemStack.getEnchantmentLevel(OPUtil.getEnchantmentHolderFromKeyStatic(level, (ResourceKey<Enchantment>)Enchantments.IMPALING));
                }
                int finalDamageCount = deltaBasedDamage + additiveDamage;
                entity.hurt(livingEntity.damageSources().generic(), (float)finalDamageCount);
                if (itemStack.getEnchantmentLevel(OPUtil.getEnchantmentHolderFromKeyStatic(livingEntity.level(), (ResourceKey<Enchantment>)Enchantments.UNBREAKING)) > 0) {
                    int unbreakingLevel = itemStack.getEnchantmentLevel(OPUtil.getEnchantmentHolderFromKeyStatic(livingEntity.level(), (ResourceKey<Enchantment>)Enchantments.UNBREAKING));
                    if ((unbreakingLevel = Mth.clamp((int)unbreakingLevel, (int)1, (int)99)) * 10 % 100 == 0) continue;
                    itemStack.hurtAndBreak(deltaBasedDamage, livingEntity, livingEntity.getUsedItemHand());
                    continue;
                }
                itemStack.hurtAndBreak(deltaBasedDamage, livingEntity, livingEntity.getUsedItemHand());
            }
        }
        if (!blockPoses.isEmpty()) {
            for (BlockPos pos : blockPoses) {
                ServerLevel serverLevel;
                if (!(level instanceof ServerLevel) || !(serverLevel = (ServerLevel)level).getBlockState(pos).is(OMTags.CORRECT_FOR_SPEAR)) continue;
                if (livingEntity instanceof Player) {
                    Player player2 = (Player)livingEntity;
                    serverLevel.destroyBlock(pos, true, (Entity)player2);
                }
                if (itemStack.getEnchantmentLevel(OPUtil.getEnchantmentHolderFromKeyStatic((Level)serverLevel, (ResourceKey<Enchantment>)Enchantments.UNBREAKING)) > 0) {
                    int unbreakingLevel = itemStack.getEnchantmentLevel(OPUtil.getEnchantmentHolderFromKeyStatic((Level)serverLevel, (ResourceKey<Enchantment>)Enchantments.UNBREAKING));
                    if ((unbreakingLevel = Mth.clamp((int)unbreakingLevel, (int)1, (int)99)) * 10 % 100 == 0) continue;
                    itemStack.hurtAndBreak(1, livingEntity, livingEntity.getUsedItemHand());
                    continue;
                }
                itemStack.hurtAndBreak(1, livingEntity, livingEntity.getUsedItemHand());
            }
        }
    }
}

