/*
 * Decompiled with CFR 0.152.
 */
package net.rk.overpoweredmastery.resource;

import net.minecraft.client.resources.sounds.AbstractTickableSoundInstance;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.player.Player;
import net.rk.overpoweredmastery.item.OMItems;

public class OxidizedTrialWubGunTickableSound
extends AbstractTickableSoundInstance {
    public Player player;
    int count = 0;

    public OxidizedTrialWubGunTickableSound(Player player, RandomSource randomSource) {
        super((SoundEvent)SoundEvents.MUSIC_DISC_CREATOR.value(), SoundSource.PLAYERS, randomSource);
        this.player = player;
        this.looping = true;
        this.delay = 0;
        this.x = player.getX();
        this.y = player.getY();
        this.z = player.getZ();
    }

    public boolean canPlaySound() {
        return !this.player.isScoping() && !this.player.isSecondaryUseActive();
    }

    public boolean canStartSilent() {
        return true;
    }

    public void stopSound() {
        this.looping = true;
        this.pitch = 0.0f;
        this.volume = 0.0f;
        this.stop();
    }

    public void tick() {
        ++this.count;
        if (this.player.getItemInHand(this.player.getUsedItemHand()).is(OMItems.OXIDIZED_TRIAl_WUBS)) {
            if (!this.player.isUsingItem()) {
                this.pitch = 0.1f;
                this.volume = 0.0f;
                this.x = this.player.getX();
                this.y = this.player.getY();
                this.z = this.player.getZ();
                this.looping = true;
            } else if (this.player.isUsingItem()) {
                if (this.player.level().tickRateManager().runsNormally()) {
                    this.pitch = 1.0f;
                    this.volume = Mth.lerp((float)this.count, (float)0.0f, (float)1.0f);
                    this.x = this.player.getX();
                    this.y = this.player.getY();
                    this.z = this.player.getZ();
                } else {
                    this.pitch = 1.0f;
                    this.volume = 1.0f;
                    this.looping = true;
                }
            }
        } else {
            this.pitch = 0.1f;
            this.volume = 0.0f;
            this.looping = true;
        }
        if (this.count > Short.MAX_VALUE) {
            this.count = 0;
        }
    }
}

