/*
 * Decompiled with CFR 0.152.
 */
package net.rk.overpoweredmastery.resource;

import net.minecraft.client.resources.sounds.AbstractTickableSoundInstance;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.player.Player;
import net.rk.overpoweredmastery.item.OMItems;
import net.rk.overpoweredmastery.resource.OMSoundEvents;

public class PurpleWubGunTickableSound
extends AbstractTickableSoundInstance {
    public Player player;
    int count = 0;

    public PurpleWubGunTickableSound(Player player, RandomSource randomSource) {
        super(OMSoundEvents.PURPLE_WUBS.get(), SoundSource.PLAYERS, randomSource);
        this.player = player;
        this.looping = true;
        this.delay = 0;
        this.x = player.getX();
        this.y = player.getY();
        this.z = player.getZ();
    }

    public boolean canPlaySound() {
        return !this.player.isScoping() && !this.player.isSecondaryUseActive();
    }

    public boolean canStartSilent() {
        return true;
    }

    public void stopSound() {
        this.stop();
    }

    public void tick() {
        ++this.count;
        if (this.player.getItemInHand(this.player.getUsedItemHand()).is(OMItems.PURPLE_WUBS)) {
            if (!this.player.isUsingItem()) {
                if (this.volume > 0.0f) {
                    this.volume -= 0.1f;
                }
                this.x = this.player.getX();
                this.y = this.player.getY();
                this.z = this.player.getZ();
            } else if (this.player.isUsingItem()) {
                if (this.player.level().tickRateManager().runsNormally()) {
                    this.pitch = 1.0f;
                    this.volume = Mth.lerp((float)this.count, (float)0.0f, (float)1.0f);
                    this.x = this.player.getX();
                    this.y = this.player.getY();
                    this.z = this.player.getZ();
                } else {
                    this.pitch = 0.0f;
                    this.volume = 0.0f;
                }
            }
        } else {
            this.stop();
        }
        if (this.count > Short.MAX_VALUE) {
            this.count = 0;
        }
    }
}

