/*
 * Decompiled with CFR 0.152.
 */
package com.ebicep.damagetintplus;

import com.ebicep.damagetintplus.config.Config;
import com.ebicep.damagetintplus.config.ConfigScreen;
import com.mojang.blaze3d.platform.NativeImage;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.VertexFormat;
import dev.architectury.event.events.client.ClientTickEvent;
import java.awt.Color;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.RenderStateShard;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.layers.EquipmentLayerRenderer;
import net.minecraft.client.renderer.entity.state.LivingEntityRenderState;
import net.minecraft.client.renderer.texture.DynamicTexture;
import net.minecraft.client.resources.model.EquipmentClientInfo;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.TriState;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\r\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\r\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0003J\u0015\u0010\t\u001a\u00020\b2\u0006\u0010\u0007\u001a\u00020\u0006\u00a2\u0006\u0004\b\t\u0010\nJ\r\u0010\u000b\u001a\u00020\u0004\u00a2\u0006\u0004\b\u000b\u0010\u0003J\u000f\u0010\r\u001a\u00020\fH\u0002\u00a2\u0006\u0004\b\r\u0010\u000eR\u0017\u0010\u0010\u001a\u00020\u000f8\u0006\u00a2\u0006\f\n\u0004\b\u0010\u0010\u0011\u001a\u0004\b\u0012\u0010\u0013R\"\u0010\u0015\u001a\u00020\u00148\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\b\u0015\u0010\u0016\u001a\u0004\b\u0017\u0010\u0018\"\u0004\b\u0019\u0010\u001aR$\u0010\u001c\u001a\u0004\u0018\u00010\u001b8\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\b\u001c\u0010\u001d\u001a\u0004\b\u001e\u0010\u001f\"\u0004\b \u0010!R$\u0010#\u001a\u0004\u0018\u00010\"8\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\b#\u0010$\u001a\u0004\b%\u0010&\"\u0004\b'\u0010(R$\u0010*\u001a\u0004\u0018\u00010)8\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\b*\u0010+\u001a\u0004\b,\u0010-\"\u0004\b.\u0010/R\"\u00100\u001a\u00020\u00148\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\b0\u0010\u0016\u001a\u0004\b1\u0010\u0018\"\u0004\b2\u0010\u001aR\"\u00103\u001a\u00020\u00148\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\b3\u0010\u0016\u001a\u0004\b4\u0010\u0018\"\u0004\b5\u0010\u001a\u00a8\u00066"}, d2={"Lcom/ebicep/damagetintplus/DamageTintPlus;", "", "<init>", "()V", "", "init", "Lnet/minecraft/resources/ResourceLocation;", "resourceLocation", "Lnet/minecraft/client/renderer/RenderType$CompositeRenderType;", "getOverrideRenderType", "(Lnet/minecraft/resources/ResourceLocation;)Lnet/minecraft/client/renderer/RenderType$CompositeRenderType;", "resetTintColor", "", "getTintColor", "()I", "Lorg/apache/logging/log4j/Logger;", "LOGGER", "Lorg/apache/logging/log4j/Logger;", "getLOGGER", "()Lorg/apache/logging/log4j/Logger;", "", "updateTintColor", "Z", "getUpdateTintColor", "()Z", "setUpdateTintColor", "(Z)V", "Lnet/minecraft/client/resources/model/EquipmentClientInfo$LayerType;", "equipmentLayerType", "Lnet/minecraft/client/resources/model/EquipmentClientInfo$LayerType;", "getEquipmentLayerType", "()Lnet/minecraft/client/resources/model/EquipmentClientInfo$LayerType;", "setEquipmentLayerType", "(Lnet/minecraft/client/resources/model/EquipmentClientInfo$LayerType;)V", "Lnet/minecraft/client/renderer/entity/layers/EquipmentLayerRenderer;", "lastRenderer", "Lnet/minecraft/client/renderer/entity/layers/EquipmentLayerRenderer;", "getLastRenderer", "()Lnet/minecraft/client/renderer/entity/layers/EquipmentLayerRenderer;", "setLastRenderer", "(Lnet/minecraft/client/renderer/entity/layers/EquipmentLayerRenderer;)V", "Lnet/minecraft/client/renderer/entity/state/LivingEntityRenderState;", "lastLivingEntityRenderState", "Lnet/minecraft/client/renderer/entity/state/LivingEntityRenderState;", "getLastLivingEntityRenderState", "()Lnet/minecraft/client/renderer/entity/state/LivingEntityRenderState;", "setLastLivingEntityRenderState", "(Lnet/minecraft/client/renderer/entity/state/LivingEntityRenderState;)V", "customHeadRender", "getCustomHeadRender", "setCustomHeadRender", "lastHurt", "getLastHurt", "setLastHurt", "damagetintplus-common"})
public final class DamageTintPlus {
    @NotNull
    public static final DamageTintPlus INSTANCE = new DamageTintPlus();
    @NotNull
    private static final Logger LOGGER;
    private static boolean updateTintColor;
    @Nullable
    private static EquipmentClientInfo.LayerType equipmentLayerType;
    @Nullable
    private static EquipmentLayerRenderer lastRenderer;
    @Nullable
    private static LivingEntityRenderState lastLivingEntityRenderState;
    private static boolean customHeadRender;
    private static boolean lastHurt;

    private DamageTintPlus() {
    }

    @NotNull
    public final Logger getLOGGER() {
        return LOGGER;
    }

    public final boolean getUpdateTintColor() {
        return updateTintColor;
    }

    public final void setUpdateTintColor(boolean bl) {
        updateTintColor = bl;
    }

    @Nullable
    public final EquipmentClientInfo.LayerType getEquipmentLayerType() {
        return equipmentLayerType;
    }

    public final void setEquipmentLayerType(@Nullable EquipmentClientInfo.LayerType layerType) {
        equipmentLayerType = layerType;
    }

    @Nullable
    public final EquipmentLayerRenderer getLastRenderer() {
        return lastRenderer;
    }

    public final void setLastRenderer(@Nullable EquipmentLayerRenderer equipmentLayerRenderer) {
        lastRenderer = equipmentLayerRenderer;
    }

    @Nullable
    public final LivingEntityRenderState getLastLivingEntityRenderState() {
        return lastLivingEntityRenderState;
    }

    public final void setLastLivingEntityRenderState(@Nullable LivingEntityRenderState livingEntityRenderState) {
        lastLivingEntityRenderState = livingEntityRenderState;
    }

    public final boolean getCustomHeadRender() {
        return customHeadRender;
    }

    public final void setCustomHeadRender(boolean bl) {
        customHeadRender = bl;
    }

    public final boolean getLastHurt() {
        return lastHurt;
    }

    public final void setLastHurt(boolean bl) {
        lastHurt = bl;
    }

    public final void init() {
        Config.INSTANCE.load();
        ClientTickEvent.CLIENT_POST.register(DamageTintPlus::init$lambda$0);
    }

    @NotNull
    public final RenderType.CompositeRenderType getOverrideRenderType(@NotNull ResourceLocation resourceLocation) {
        Intrinsics.checkNotNullParameter((Object)resourceLocation, (String)"resourceLocation");
        RenderType.CompositeRenderType compositeRenderType = RenderType.create((String)"damagetintplus_override", (VertexFormat)DefaultVertexFormat.NEW_ENTITY, (VertexFormat.Mode)VertexFormat.Mode.QUADS, (int)1536, (boolean)true, (boolean)false, (RenderType.CompositeState)RenderType.CompositeState.builder().setShaderState(RenderStateShard.RENDERTYPE_ENTITY_CUTOUT_NO_CULL_SHADER).setTextureState((RenderStateShard.EmptyTextureStateShard)new RenderStateShard.TextureStateShard(resourceLocation, TriState.FALSE, false)).setTransparencyState(RenderStateShard.NO_TRANSPARENCY).setCullState(RenderStateShard.NO_CULL).setLightmapState(RenderStateShard.LIGHTMAP).setOverlayState(RenderStateShard.OVERLAY).setLayeringState(RenderStateShard.VIEW_OFFSET_Z_LAYERING).setDepthTestState(RenderStateShard.LEQUAL_DEPTH_TEST).createCompositeState(true));
        Intrinsics.checkNotNullExpressionValue((Object)compositeRenderType, (String)"create(...)");
        return compositeRenderType;
    }

    public final void resetTintColor() {
        updateTintColor = false;
        DynamicTexture texture = Minecraft.getInstance().gameRenderer.overlayTexture().texture;
        NativeImage nativeImage = texture.getPixels();
        if (nativeImage == null) {
            LOGGER.error("Failed to allocate memory for overlay color texture");
            return;
        }
        int color = this.getTintColor();
        LOGGER.info("Setting overlay color to " + color);
        for (int i = 0; i < 16; ++i) {
            for (int j = 0; j < 16; ++j) {
                if (i < 8) {
                    nativeImage.setPixel(j, i, color);
                    continue;
                }
                int k = (int)((1.0f - (float)j / 15.0f * 0.75f) * 255.0f);
                nativeImage.setPixel(j, i, k << 24 | 0xFFFFFF);
            }
        }
        RenderSystem.activeTexture((int)33985);
        texture.bind();
        texture.setFilter(false, false);
        texture.setClamp(true);
        nativeImage.upload(0, 0, 0, 0, 0, nativeImage.getWidth(), nativeImage.getHeight(), false);
        RenderSystem.activeTexture((int)33984);
    }

    private final int getTintColor() {
        return Config.INSTANCE.getValues().getOverrideVanillaColor() ? new Color(Config.INSTANCE.getValues().getOverrideColor(), true).getRGB() : -1291911168;
    }

    private static final void init$lambda$0(Minecraft it) {
        ConfigScreen.INSTANCE.handleOpenScreen();
    }

    static {
        Logger logger = LogManager.getLogger((String)"damagetintplus");
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getLogger(...)");
        LOGGER = logger;
    }
}

