/*
 * Decompiled with CFR 0.152.
 */
package me.libreh.rulebook.config;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import eu.pb4.placeholders.api.PlaceholderContext;
import eu.pb4.placeholders.api.Placeholders;
import eu.pb4.placeholders.api.TextParserUtils;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.UUID;
import me.libreh.rulebook.Rulebook;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_2561;
import net.minecraft.class_3222;

public class Config {
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().disableHtmlEscaping().create();
    private static Config CONFIG;
    public String rulesHeader = "Rules Header\n";
    public String ruleSchema = "%rule_number%. %rule_title%\n%rule_description%\n";
    public String finalPage = "By closing the rulebook <bold>%player:name%</bold> you hereby agree to <underline>all the rules</underline>";
    public KickMessage kickMessages = new KickMessage();
    public List<Rule> rules = Arrays.asList(new Rule("title", "description"), new Rule("more title", "more description"));
    public List<UUID> acceptedPlayers = new ArrayList<UUID>();

    public static Config getConfig() {
        return CONFIG;
    }

    public static boolean loadConfig() {
        boolean success;
        Config oldConfig = CONFIG;
        CONFIG = null;
        try {
            File configFile = Config.getConfigFile();
            CONFIG = configFile.exists() ? (Config)GSON.fromJson((Reader)new InputStreamReader((InputStream)new FileInputStream(configFile), StandardCharsets.UTF_8), Config.class) : new Config();
            Config.saveConfig();
            success = true;
        }
        catch (IOException exception) {
            success = false;
            CONFIG = oldConfig;
            Rulebook.LOGGER.error("Something went wrong while reading config!");
            exception.printStackTrace();
        }
        return success;
    }

    public static void saveConfig() {
        try {
            File configFile = Config.getConfigFile();
            BufferedWriter writer = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(configFile), StandardCharsets.UTF_8));
            writer.write(GSON.toJson((Object)CONFIG));
            writer.close();
        }
        catch (Exception exception) {
            Rulebook.LOGGER.error("Something went wrong while saving config!", (Throwable)exception);
        }
    }

    private static File getConfigFile() {
        return new File(FabricLoader.getInstance().getConfigDir().toFile(), "rulebook.json");
    }

    public static boolean hasAccepted(class_3222 player) {
        return Config.getConfig().acceptedPlayers.contains(player.method_5667());
    }

    public static void accept(class_3222 player) {
        Config.getConfig().acceptedPlayers.add(player.method_5667());
        Config.saveConfig();
    }

    public static void unaccept(class_3222 player) {
        Config.getConfig().acceptedPlayers.remove(player.method_5667());
        Config.saveConfig();
        player.field_13987.method_52396(Placeholders.parseText((class_2561)TextParserUtils.formatText((String)Config.getConfig().kickMessages.updatedRules), (PlaceholderContext)PlaceholderContext.of((class_3222)player)));
    }

    public static class KickMessage {
        public String didntRead = "<red>You didn't read all the rules!</red>";
        public String updatedRules = "<yellow>Rules updated, please reconnect!</yellow>";
    }

    public static class Rule {
        public String title;
        public String description;

        Rule(String title, String description) {
            this.title = title;
            this.description = description;
        }
    }
}

