/*
 * Decompiled with CFR 0.152.
 */
package me.libreh.rulebook.mixin;

import com.mojang.authlib.GameProfile;
import eu.pb4.placeholders.api.TextParserUtils;
import eu.pb4.sgui.api.elements.BookElementBuilder;
import eu.pb4.sgui.api.gui.BookGui;
import eu.pb4.sgui.virtual.book.BookScreenHandler;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import me.libreh.rulebook.Rulebook;
import me.libreh.rulebook.config.Config;
import me.libreh.rulebook.config.PlayerData;
import net.minecraft.class_1657;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2558;
import net.minecraft.class_2561;
import net.minecraft.class_3222;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={class_3222.class})
public abstract class ServerPlayerEntityMixin
extends class_1657 {
    @Unique
    private final class_3222 player = (class_3222)this;
    @Unique
    private final UUID playerUuid = this.method_5667();
    @Unique
    private int rulebookTick;

    public ServerPlayerEntityMixin(class_1937 world, class_2338 pos, float yaw, GameProfile gameProfile) {
        super(world, pos, yaw, gameProfile);
    }

    @Inject(method={"tick"}, at={@At(value="HEAD")})
    private void tick(CallbackInfo ci) {
        ++this.rulebookTick;
        if (this.rulebookTick == 4) {
            if (Rulebook.JOIN_LIST.contains(this.playerUuid)) {
                if (!PlayerData.get((class_1657)this.player).hasAccepted) {
                    if (!Rulebook.RULEBOOK_LIST.contains(this.playerUuid)) {
                        if (!(this.player.field_7512 instanceof BookScreenHandler)) {
                            Rulebook.RULEBOOK_LIST.add(this.playerUuid);
                            ServerPlayerEntityMixin.openBookGui(this.player);
                        }
                    } else if (!(this.player.field_7512 instanceof BookScreenHandler)) {
                        Rulebook.JOIN_LIST.remove(this.playerUuid);
                        Rulebook.RULEBOOK_LIST.remove(this.playerUuid);
                        this.player.field_13987.method_52396(TextParserUtils.formatText((String)Config.getConfig().kickMessages.didntAccept));
                    }
                } else {
                    Rulebook.JOIN_LIST.remove(this.playerUuid);
                    Rulebook.RULEBOOK_LIST.remove(this.playerUuid);
                    this.player.method_7346();
                }
            }
            this.rulebookTick = 0;
        }
    }

    @Unique
    private static void openBookGui(class_3222 player) {
        List<class_2561> rulesArray = ServerPlayerEntityMixin.generateBookPages();
        BookElementBuilder bookBuilder = new BookElementBuilder();
        for (class_2561 rule : rulesArray) {
            bookBuilder.addPage(rule);
        }
        bookBuilder.addPage((class_2561)TextParserUtils.formatText((String)Config.getConfig().acceptConfirmation).method_27661().method_10852(TextParserUtils.formatText((String)Config.getConfig().acceptButton)).method_27694(style -> style.method_10958(new class_2558(class_2558.class_2559.field_11750, "/rulebook accept"))));
        new BookGui(player, bookBuilder).open();
    }

    @Unique
    private static List<class_2561> generateBookPages() {
        ArrayList<class_2561> rulesList = new ArrayList<class_2561>();
        String header = Config.getConfig().rulesHeader;
        String schema = Config.getConfig().ruleSchema;
        List<Config.Rule> rules = Config.getConfig().rules;
        for (int index = 0; index < rules.size(); ++index) {
            Config.Rule rule = rules.get(index);
            String ruleTitle = rule.title;
            String ruleDescription = rule.description;
            String ruleBuilder = header + "\n" + Rulebook.parseRule(schema, index + 1, ruleTitle, ruleDescription);
            rulesList.add(TextParserUtils.formatText((String)ruleBuilder));
        }
        return rulesList;
    }
}

