/*
 * Decompiled with CFR 0.152.
 */
package me.libreh.rulebook.config;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.List;
import net.fabricmc.loader.api.FabricLoader;

public class Config {
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().disableHtmlEscaping().create();
    private static Config CONFIG;
    public String rulesHeader = "Rules Header\n";
    public String ruleSchema = "%rule_number%. %rule_title%\n%rule_description%\n";
    public String finalPage = "By closing the rulebook <bold>%player:name%</bold> you hereby agree to <underline>all the rules</underline>";
    public KickMessage kickMessages = new KickMessage();
    public List<Rule> rules = Arrays.asList(new Rule("title", "description"), new Rule("more title", "more description"));

    public static Config getConfig() {
        return CONFIG;
    }

    public static void load() {
        Config oldConfig = CONFIG;
        CONFIG = null;
        try {
            Config config;
            File configFile = new File(FabricLoader.getInstance().getConfigDir().toFile(), "rulebook.json");
            CONFIG = config = configFile.exists() ? (Config)GSON.fromJson((Reader)new InputStreamReader((InputStream)new FileInputStream(configFile), StandardCharsets.UTF_8), Config.class) : new Config();
            BufferedWriter writer = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(configFile), StandardCharsets.UTF_8));
            writer.write(GSON.toJson((Object)config));
            writer.close();
        }
        catch (IOException exception) {
            CONFIG = oldConfig;
        }
    }

    public static class KickMessage {
        public String didntAccept = "<red>You didn't accept the rules!</red>";
        public String didntRead = "<red>You didn't read all the rules!</red>";
        public String updatedRules = "<yellow>Rules updated, please reconnect!</yellow>";
    }

    public static class Rule {
        public String title;
        public String description;

        Rule(String title, String description) {
            this.title = title;
            this.description = description;
        }
    }
}

