/*
 * Decompiled with CFR 0.152.
 */
package me.libreh.rulebook;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import eu.pb4.placeholders.api.TextParserUtils;
import eu.pb4.playerdata.api.PlayerDataApi;
import eu.pb4.sgui.api.elements.BookElementBuilder;
import eu.pb4.sgui.api.gui.BookGui;
import eu.pb4.sgui.virtual.book.BookSlot;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import me.libreh.rulebook.Commands;
import me.libreh.rulebook.Config;
import me.libreh.rulebook.PlayerData;
import me.lucko.fabric.api.permissions.v0.Permissions;
import net.fabricmc.api.ModInitializer;
import net.fabricmc.fabric.api.command.v2.CommandRegistrationCallback;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerTickEvents;
import net.fabricmc.fabric.api.networking.v1.ServerPlayConnectionEvents;
import net.minecraft.class_1657;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2558;
import net.minecraft.class_2561;
import net.minecraft.class_3222;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Rulebook
implements ModInitializer {
    public static final String MOD_ID = "rulebook";
    public static final Logger LOGGER = LoggerFactory.getLogger((String)"rulebook");
    public static final Set<UUID> JOIN_LIST = new HashSet<UUID>();
    public static final Set<UUID> RULEBOOK_LIST = new HashSet<UUID>();

    public void onInitialize() {
        Config.load();
        PlayerDataApi.register(PlayerData.STORAGE);
        CommandRegistrationCallback.EVENT.register((dispatcher, access, environment) -> {
            Commands.register((CommandDispatcher<class_2168>)dispatcher);
            dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"rules").requires(Permissions.require((String)"rulebook.main", (boolean)true))).executes(context -> Rulebook.showRules((class_2168)context.getSource())));
        });
        ServerTickEvents.START_SERVER_TICK.register(server -> {
            for (class_3222 player : server.method_3760().method_14571()) {
                UUID playerUuid = player.method_5667();
                if (!JOIN_LIST.contains(playerUuid)) continue;
                if (!PlayerData.get((class_1657)player).hasAccepted) {
                    if (!RULEBOOK_LIST.contains(playerUuid)) {
                        if (player.field_7512.field_7761.getFirst() instanceof BookSlot) continue;
                        RULEBOOK_LIST.add(playerUuid);
                        Rulebook.openBookGui(player);
                        continue;
                    }
                    if (player.field_7512.field_7761.getFirst() instanceof BookSlot) continue;
                    JOIN_LIST.remove(playerUuid);
                    RULEBOOK_LIST.remove(playerUuid);
                    player.field_13987.method_52396(TextParserUtils.formatText((String)Config.getConfig().kickMessages.didntAccept));
                    continue;
                }
                JOIN_LIST.remove(playerUuid);
                RULEBOOK_LIST.remove(playerUuid);
            }
        });
        ServerPlayConnectionEvents.JOIN.register((handler, sender, server) -> JOIN_LIST.add(handler.method_32311().method_5667()));
    }

    private static void openBookGui(class_3222 player) {
        List<class_2561> rulesArray = Rulebook.generateBookPages();
        BookElementBuilder bookBuilder = new BookElementBuilder();
        for (class_2561 rule : rulesArray) {
            bookBuilder.addPage(rule);
        }
        bookBuilder.addPage((class_2561)TextParserUtils.formatText((String)Config.getConfig().acceptConfirmation).method_27661().method_10852(TextParserUtils.formatText((String)Config.getConfig().acceptButton)).method_27694(style -> style.method_10958(new class_2558(class_2558.class_2559.field_11750, "/rulebook accept"))));
        new BookGui(player, bookBuilder).open();
    }

    public static int showRules(class_2168 source) {
        source.method_9226(() -> TextParserUtils.formatText((String)Rulebook.generateRulesString()), false);
        return 1;
    }

    private static List<class_2561> generateBookPages() {
        ArrayList<class_2561> rulesList = new ArrayList<class_2561>();
        String header = Config.getConfig().rulesHeader;
        String schema = Config.getConfig().ruleSchema;
        List<Config.Rule> rules = Config.getConfig().rules;
        for (int index = 0; index < rules.size(); ++index) {
            Config.Rule rule = rules.get(index);
            String ruleTitle = rule.title;
            String ruleDescription = rule.description;
            StringBuilder ruleBuilder = new StringBuilder();
            ruleBuilder.append(header).append("\n");
            ruleBuilder.append(Rulebook.parseRule(schema, index + 1, ruleTitle, ruleDescription));
            rulesList.add(TextParserUtils.formatText((String)ruleBuilder.toString()));
        }
        return rulesList;
    }

    private static String generateRulesString() {
        StringBuilder rulesString = new StringBuilder();
        String header = Config.getConfig().rulesHeader;
        String schema = Config.getConfig().ruleSchema;
        List<Config.Rule> rules = Config.getConfig().rules;
        if (header != null && !header.isEmpty()) {
            rulesString.append(header).append("\n");
        }
        for (int index = 0; index < rules.size(); ++index) {
            Config.Rule rule = rules.get(index);
            String ruleTitle = rule.title;
            String ruleDescription = rule.description;
            rulesString.append(Rulebook.parseRule(schema, index + 1, ruleTitle, ruleDescription));
            if (index == rules.size() - 1) continue;
            rulesString.append("\n");
        }
        return rulesString.toString();
    }

    private static String parseRule(String line, int ruleNumber, String ruleTitle, String ruleDescription) {
        String rule = Rulebook.parseString(line, "rule_number", String.valueOf(ruleNumber));
        rule = Rulebook.parseString(rule, "rule_title", ruleTitle);
        rule = Rulebook.parseString(rule, "rule_description", ruleDescription);
        return rule;
    }

    private static String parseString(String string, String variableName, String variableReplacement) {
        return string.replaceAll("%" + variableName + "%", variableReplacement);
    }
}

