/*
 * Decompiled with CFR 0.152.
 */
package me.libreh.rulebook.config;

import com.google.gson.annotations.SerializedName;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.UUID;

public final class Config {
    @SerializedName(value="config_version")
    private int version = 1;
    @SerializedName(value="rules_header")
    private String rulesHeader = "Rules Header\n";
    @SerializedName(value="rule_schema")
    private String ruleSchema = "%rule_number%. %rule_title%\n%rule_description%\n";
    @SerializedName(value="final_page")
    private String finalPage = "By closing the rulebook <bold>%player:name%</bold> you hereby agree to <underline>all the rules</underline>";
    @SerializedName(value="kick_messages")
    private KickMessage kickMessages = new KickMessage();
    @SerializedName(value="rules")
    private List<Rule> rules = Arrays.asList(new Rule("title", "description"), new Rule("more title", "more description"));
    @SerializedName(value="accepted_players")
    private List<UUID> acceptedPlayers = new ArrayList<UUID>();

    public int getVersion() {
        return this.version;
    }

    public String getRulesHeader() {
        return this.rulesHeader;
    }

    public String getRuleSchema() {
        return this.ruleSchema;
    }

    public String getFinalPage() {
        return this.finalPage;
    }

    public KickMessage getKickMessages() {
        return this.kickMessages;
    }

    public List<Rule> getRules() {
        return Collections.unmodifiableList(this.rules);
    }

    public List<UUID> getAcceptedPlayers() {
        return Collections.unmodifiableList(this.acceptedPlayers);
    }

    public void setVersion(int version) {
        this.version = version;
    }

    public void addAcceptedPlayer(UUID playerUuid) {
        if (!this.acceptedPlayers.contains(playerUuid)) {
            this.acceptedPlayers.add(playerUuid);
        }
    }

    public void removeAcceptedPlayer(UUID playerUuid) {
        this.acceptedPlayers.remove(playerUuid);
    }

    public boolean isPlayerAccepted(UUID playerUuid) {
        return this.acceptedPlayers.contains(playerUuid);
    }

    public static final class KickMessage {
        @SerializedName(value="didnt_read")
        private String didntRead = "<red>You didn't read all the rules!</red>";
        @SerializedName(value="updated_rules")
        private String updatedRules = "<yellow>Rules updated, please reconnect!</yellow>";

        public String getDidntRead() {
            return this.didntRead;
        }

        public String getUpdatedRules() {
            return this.updatedRules;
        }
    }

    public static final class Rule {
        private final String title;
        private final String description;

        public Rule(String title, String description) {
            this.title = title;
            this.description = description;
        }

        public String getTitle() {
            return this.title;
        }

        public String getDescription() {
            return this.description;
        }
    }
}

