/*
 * Decompiled with CFR 0.152.
 */
package me.libreh.rulebook.config;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.io.FileInputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.UUID;
import me.libreh.rulebook.RulebookMod;
import me.libreh.rulebook.config.Config;
import net.fabricmc.loader.api.FabricLoader;

public final class ConfigManager {
    public static final int VERSION = 1;
    private final Path CONFIG_PATH = FabricLoader.getInstance().getConfigDir().resolve("rulebook.json");
    private final Path LEGACY_DATA = FabricLoader.getInstance().getGameDir().resolve("world/player-mod-data");
    private static ConfigManager instance;
    private final Gson gson = new GsonBuilder().setPrettyPrinting().disableHtmlEscaping().create();
    private final Config defaultConfig = new Config();
    private volatile Config config;

    private ConfigManager() {
    }

    public static ConfigManager getInstance() {
        if (instance == null) {
            instance = new ConfigManager();
        }
        return instance;
    }

    public Config getConfig() {
        if (this.config == null) {
            return this.defaultConfig;
        }
        return this.config;
    }

    public boolean loadConfig() {
        try {
            Files.createDirectories(this.CONFIG_PATH.getParent(), new FileAttribute[0]);
            this.config = this.CONFIG_PATH.toFile().exists() ? this.loadFromFile() : new Config();
            if (Files.exists(this.LEGACY_DATA, new LinkOption[0])) {
                this.migrateLegacyData(this.config);
            }
            this.config.setVersion(1);
            this.saveConfig();
            return true;
        }
        catch (Exception e) {
            RulebookMod.LOGGER.error("Failed to load configuration from {}", (Object)this.CONFIG_PATH, (Object)e);
            return false;
        }
    }

    public void saveConfig() {
        try {
            if (this.config != null) {
                Files.writeString(this.CONFIG_PATH, (CharSequence)this.gson.toJson((Object)this.config), StandardCharsets.UTF_8, new OpenOption[0]);
                RulebookMod.LOGGER.debug("Configuration saved successfully to {}", (Object)this.CONFIG_PATH);
            }
        }
        catch (Exception e) {
            RulebookMod.LOGGER.error("Failed to save configuration to {}", (Object)this.CONFIG_PATH, (Object)e);
        }
    }

    private Config loadFromFile() throws IOException {
        try (InputStreamReader reader = new InputStreamReader((InputStream)new FileInputStream(this.CONFIG_PATH.toFile()), StandardCharsets.UTF_8);){
            Config config = (Config)this.gson.fromJson((Reader)reader, Config.class);
            return config;
        }
    }

    private void migrateLegacyData(Config config) throws IOException {
        RulebookMod.LOGGER.info("Legacy PlayerDataAPI directory found, starting migration...");
        Files.walk(this.LEGACY_DATA, new FileVisitOption[0]).filter(x$0 -> Files.isRegularFile(x$0, new LinkOption[0])).filter(path -> path.toString().endsWith(".json")).forEach(jsonFilePath -> {
            try {
                UUID playerUuid = this.extractPlayerUuid((Path)jsonFilePath);
                if (playerUuid != null && !config.isPlayerAccepted(playerUuid)) {
                    if (this.hasAcceptedRules((Path)jsonFilePath)) {
                        config.addAcceptedPlayer(playerUuid);
                        RulebookMod.LOGGER.info("Migrated player data for UUID: {}", (Object)playerUuid);
                    }
                } else if (playerUuid != null) {
                    RulebookMod.LOGGER.debug("Skipping UUID {} as player has already accepted the rules", (Object)playerUuid);
                }
            }
            catch (Exception e) {
                RulebookMod.LOGGER.warn("Error migrating player data from {}", jsonFilePath, (Object)e);
            }
        });
    }

    private UUID extractPlayerUuid(Path jsonFilePath) {
        try {
            String fileName = jsonFilePath.getParent().getFileName().toString();
            return UUID.fromString(fileName);
        }
        catch (IllegalArgumentException e) {
            RulebookMod.LOGGER.warn("Invalid UUID format in path: {}", (Object)jsonFilePath);
            return null;
        }
    }

    private boolean hasAcceptedRules(Path jsonFilePath) {
        boolean bl;
        FileReader reader = new FileReader(jsonFilePath.toFile());
        try {
            JsonObject jsonObject = JsonParser.parseReader((Reader)reader).getAsJsonObject();
            bl = jsonObject.has("hasAccepted") && jsonObject.get("hasAccepted").getAsBoolean();
        }
        catch (Throwable throwable) {
            try {
                try {
                    reader.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (Exception e) {
                RulebookMod.LOGGER.warn("Failed to parse legacy player data from {}", (Object)jsonFilePath, (Object)e);
                return false;
            }
        }
        reader.close();
        return bl;
    }
}

