/*
 * Decompiled with CFR 0.152.
 */
package me.libreh.rulebook.mixin;

import com.mojang.authlib.GameProfile;
import eu.pb4.sgui.virtual.book.BookScreenHandler;
import java.util.UUID;
import me.libreh.rulebook.RulebookMod;
import me.libreh.rulebook.services.PlayerService;
import me.libreh.rulebook.util.Utils;
import net.minecraft.class_1657;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_3222;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={class_3222.class})
public abstract class ServerPlayerEntityMixin
extends class_1657 {
    @Unique
    private static final int TICK_INTERVAL = 4;
    @Unique
    private final class_3222 player = (class_3222)this;
    @Unique
    private final UUID playerUuid = this.method_5667();
    @Unique
    private int rulebookTick;

    public ServerPlayerEntityMixin(class_1937 world, class_2338 pos, float yaw, GameProfile gameProfile) {
        super(world, pos, yaw, gameProfile);
    }

    @Inject(method={"tick"}, at={@At(value="HEAD")})
    private void onTick(CallbackInfo ci) {
        ++this.rulebookTick;
        if (this.rulebookTick >= 4) {
            this.handleRulebookLogic();
            this.rulebookTick = 0;
        }
    }

    @Unique
    private void handleRulebookLogic() {
        PlayerService playerService = RulebookMod.getPlayerService();
        if (!playerService.hasPlayerJoined(this.playerUuid)) {
            return;
        }
        if (Utils.hasAccepted(this.player)) {
            this.handleAcceptedPlayer(playerService);
            return;
        }
        if (playerService.isPlayerViewingRulebook(this.playerUuid)) {
            return;
        }
        if (this.player.field_7512 instanceof BookScreenHandler) {
            return;
        }
        this.showRulebookToPlayer(playerService);
    }

    @Unique
    private void handleAcceptedPlayer(PlayerService playerService) {
        playerService.removePlayer(this.playerUuid);
        this.player.method_7346();
        RulebookMod.LOGGER.debug("Player {} has already accepted rules, removing from tracking", (Object)this.player.method_5477().getString());
    }

    @Unique
    private void showRulebookToPlayer(PlayerService playerService) {
        playerService.addRulebookPlayer(this.playerUuid);
        Utils.openBookGui(this.player, true);
        RulebookMod.LOGGER.debug("Showing rulebook to player {}", (Object)this.player.method_5477().getString());
    }
}

