/*
 * Decompiled with CFR 0.152.
 */
package me.libreh.rulebook.ui;

import eu.pb4.placeholders.api.PlaceholderContext;
import eu.pb4.placeholders.api.Placeholders;
import eu.pb4.placeholders.api.node.TextNode;
import eu.pb4.sgui.api.elements.BookElementBuilder;
import eu.pb4.sgui.api.gui.BookGui;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import me.libreh.rulebook.RulebookMod;
import me.libreh.rulebook.config.Config;
import me.libreh.rulebook.config.ConfigManager;
import me.libreh.rulebook.services.PlayerService;
import me.libreh.rulebook.util.Utils;
import net.minecraft.class_1799;
import net.minecraft.class_2561;
import net.minecraft.class_3222;
import net.minecraft.class_9302;
import net.minecraft.class_9334;

public final class RulebookGui
extends BookGui {
    private final boolean shouldKickOnIncomplete;
    private final Map<Integer, Boolean> viewedPages;
    private final PlayerService playerService;

    public RulebookGui(class_3222 player, BookElementBuilder book, boolean shouldKickOnIncomplete) {
        super(player, book);
        this.shouldKickOnIncomplete = shouldKickOnIncomplete;
        this.viewedPages = new HashMap<Integer, Boolean>();
        this.playerService = RulebookMod.getPlayerService();
    }

    public void onTakeBookButton() {
        super.onTakeBookButton();
        this.handleBookAcceptance();
        if (this.hasViewedAllPages()) {
            this.giveRulebookToPlayer();
        }
        this.closeGui();
    }

    public void onTick() {
        super.onTick();
        this.trackCurrentPage();
    }

    public void close(boolean screenHandlerIsClosed) {
        this.handleBookAcceptance();
        if (this.isOpen() && !this.reOpen) {
            this.reOpen = false;
            if (!screenHandlerIsClosed && this.player.field_7512 == this.screenHandler) {
                this.player.method_7346();
            }
            this.onClose();
        } else {
            this.reOpen = false;
        }
    }

    private void handleBookAcceptance() {
        if (this.hasViewedAllPages()) {
            this.acceptPlayer();
        } else if (this.shouldKickOnIncomplete) {
            this.kickPlayerForIncompleteReading();
        }
    }

    private boolean hasViewedAllPages() {
        class_9302 data = (class_9302)this.book.method_58694(class_9334.field_49606);
        if (data == null) {
            RulebookMod.LOGGER.warn("Book content is null for player {}", (Object)this.player.method_5477().getString());
            return false;
        }
        List pages = data.method_57525(false);
        return this.viewedPages.size() >= pages.size();
    }

    private void acceptPlayer() {
        Utils.accept(this.player);
        UUID playerUuid = this.player.method_5667();
        this.playerService.removePlayer(playerUuid);
        RulebookMod.LOGGER.info("Player {} accepted the rules", (Object)this.player.method_5477().getString());
    }

    private void kickPlayerForIncompleteReading() {
        UUID playerUuid = this.player.method_5667();
        Config config = ConfigManager.getInstance().getConfig();
        this.playerService.removePlayer(playerUuid);
        class_2561 kickMessage = Placeholders.parseText((TextNode)RulebookMod.PARSER.parseNode(config.getKickMessages().getDidntRead()), (PlaceholderContext)PlaceholderContext.of((class_3222)this.player));
        this.player.field_13987.method_52396(kickMessage);
        RulebookMod.LOGGER.info("Player {} kicked for not reading all rules", (Object)this.player.method_5477().getString());
    }

    private void giveRulebookToPlayer() {
        class_1799 rulebook = Utils.getRulebookStack(this.player);
        this.player.method_7270(rulebook);
        RulebookMod.LOGGER.debug("Gave rulebook to player {}", (Object)this.player.method_5477().getString());
    }

    private void closeGui() {
        this.player.method_7346();
    }

    private void trackCurrentPage() {
        this.viewedPages.put(this.page, true);
    }
}

