/*
 * Decompiled with CFR 0.152.
 */
package me.libreh.rulebook.util;

import eu.pb4.placeholders.api.PlaceholderContext;
import eu.pb4.placeholders.api.Placeholders;
import eu.pb4.placeholders.api.node.TextNode;
import eu.pb4.sgui.api.elements.BookElementBuilder;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import me.libreh.rulebook.RulebookMod;
import me.libreh.rulebook.config.Config;
import me.libreh.rulebook.config.ConfigManager;
import me.libreh.rulebook.ui.RulebookGui;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1935;
import net.minecraft.class_2168;
import net.minecraft.class_2561;
import net.minecraft.class_3222;
import net.minecraft.class_9262;
import net.minecraft.class_9302;
import net.minecraft.class_9334;

public final class Utils {
    private Utils() {
    }

    public static boolean hasAccepted(class_3222 player) {
        return ConfigManager.getInstance().getConfig().isPlayerAccepted(player.method_5667());
    }

    public static void accept(class_3222 player) {
        UUID playerUuid;
        Config config = ConfigManager.getInstance().getConfig();
        if (!config.isPlayerAccepted(playerUuid = player.method_5667())) {
            config.addAcceptedPlayer(playerUuid);
            ConfigManager.getInstance().saveConfig();
            RulebookMod.LOGGER.debug("Player {} accepted the rules", (Object)player.method_5477().getString());
        }
    }

    public static void unaccept(class_3222 player) {
        Config config = ConfigManager.getInstance().getConfig();
        UUID playerUuid = player.method_5667();
        config.removeAcceptedPlayer(playerUuid);
        ConfigManager.getInstance().saveConfig();
        class_2561 kickMessage = Placeholders.parseText((TextNode)RulebookMod.PARSER.parseNode(config.getKickMessages().getUpdatedRules()), (PlaceholderContext)PlaceholderContext.of((class_3222)player));
        player.field_13987.method_52396(kickMessage);
        RulebookMod.LOGGER.debug("Player {} unaccepted and kicked", (Object)player.method_5477().getString());
    }

    public static int showRules(class_2168 source) {
        class_2561 rulesText = Placeholders.parseText((TextNode)RulebookMod.PARSER.parseNode(RuleGenerator.generateRulesString()), (PlaceholderContext)PlaceholderContext.of((class_2168)source));
        source.method_9226(() -> rulesText, false);
        return 1;
    }

    public static void openBookGui(class_3222 player, boolean kick) {
        List<class_2561> rulesArray = RuleGenerator.generateBookPages(player);
        BookElementBuilder bookBuilder = new BookElementBuilder();
        for (class_2561 rule : rulesArray) {
            bookBuilder.addPage(rule);
        }
        Config config = ConfigManager.getInstance().getConfig();
        class_2561 finalPage = Placeholders.parseText((TextNode)RulebookMod.PARSER.parseNode(config.getFinalPage()), (PlaceholderContext)PlaceholderContext.of((class_3222)player));
        bookBuilder.addPage(finalPage);
        new RulebookGui(player, bookBuilder, kick).open();
        RulebookMod.LOGGER.debug("Opened rulebook GUI for player {}", (Object)player.method_5477().getString());
    }

    public static class_1799 getRulebookStack(class_3222 player) {
        class_1799 book = new class_1799((class_1935)class_1802.field_8360);
        List<class_2561> bookPages = RuleGenerator.generateBookPages(player);
        ArrayList<class_9262> texts = new ArrayList<class_9262>();
        for (class_2561 page : bookPages) {
            texts.add(class_9262.method_57137((Object)page));
        }
        class_9302 data = new class_9302(class_9262.method_57137((Object)"Rulebook"), "", 0, texts, true);
        book.method_57379(class_9334.field_49606, (Object)data);
        return book;
    }

    public static final class RuleGenerator {
        private RuleGenerator() {
        }

        public static List<class_2561> generateBookPages(class_3222 player) {
            Config config = ConfigManager.getInstance().getConfig();
            ArrayList<class_2561> rulesList = new ArrayList<class_2561>();
            String header = config.getRulesHeader();
            String schema = config.getRuleSchema();
            List<Config.Rule> rules = config.getRules();
            for (int index = 0; index < rules.size(); ++index) {
                Config.Rule rule = rules.get(index);
                String ruleBuilder = header + "\n" + RuleGenerator.parseRule(schema, index + 1, rule.getTitle(), rule.getDescription());
                rulesList.add(Placeholders.parseText((TextNode)RulebookMod.PARSER.parseNode(ruleBuilder), (PlaceholderContext)PlaceholderContext.of((class_3222)player)));
            }
            return rulesList;
        }

        public static String generateRulesString() {
            Config config = ConfigManager.getInstance().getConfig();
            StringBuilder rulesString = new StringBuilder();
            String header = config.getRulesHeader();
            String schema = config.getRuleSchema();
            List<Config.Rule> rules = config.getRules();
            if (header != null && !header.isEmpty()) {
                rulesString.append(header).append("\n");
            }
            for (int index = 0; index < rules.size(); ++index) {
                Config.Rule rule = rules.get(index);
                rulesString.append(RuleGenerator.parseRule(schema, index + 1, rule.getTitle(), rule.getDescription()));
                if (index == rules.size() - 1) continue;
                rulesString.append("\n");
            }
            return rulesString.toString();
        }

        public static String parseRule(String template, int ruleNumber, String ruleTitle, String ruleDescription) {
            String result = RuleGenerator.parseString(template, "rule_number", String.valueOf(ruleNumber));
            result = RuleGenerator.parseString(result, "rule_title", ruleTitle);
            result = RuleGenerator.parseString(result, "rule_description", ruleDescription);
            return result;
        }

        private static String parseString(String template, String variableName, String replacement) {
            return template.replaceAll("%" + variableName + "%", replacement);
        }
    }
}

