/*
 * Decompiled with CFR 0.152.
 */
package me.libreh.rulebook;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import eu.pb4.placeholders.api.PlaceholderContext;
import eu.pb4.placeholders.api.Placeholders;
import eu.pb4.placeholders.api.TextParserUtils;
import eu.pb4.sgui.api.elements.BookElementBuilder;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import me.libreh.rulebook.commands.Commands;
import me.libreh.rulebook.config.Config;
import me.libreh.rulebook.config.ConfigManager;
import me.libreh.rulebook.gui.RulebookGui;
import me.lucko.fabric.api.permissions.v0.Permissions;
import net.fabricmc.api.ModInitializer;
import net.fabricmc.fabric.api.command.v2.CommandRegistrationCallback;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerLifecycleEvents;
import net.fabricmc.fabric.api.networking.v1.ServerPlayConnectionEvents;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2561;
import net.minecraft.class_3222;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Rulebook
implements ModInitializer {
    public static final String MOD_ID = "rulebook";
    public static final Logger LOGGER = LoggerFactory.getLogger((String)"rulebook");
    public static final Set<UUID> JOIN_LIST = new HashSet<UUID>();
    public static final Set<UUID> RULEBOOK_LIST = new HashSet<UUID>();

    public void onInitialize() {
        ServerLifecycleEvents.SERVER_STARTING.register(server -> ConfigManager.loadConfig());
        CommandRegistrationCallback.EVENT.register((dispatcher, access, environment) -> {
            Commands.register((CommandDispatcher<class_2168>)dispatcher);
            dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"rules").requires(Permissions.require((String)"rulebook.main", (boolean)true))).executes(context -> Rulebook.showRules((class_2168)context.getSource()))).then(((LiteralArgumentBuilder)class_2170.method_9247((String)"open").requires(Permissions.require((String)"rulebook.main", (boolean)true))).executes(context -> {
                Rulebook.openBookGui(((class_2168)context.getSource()).method_44023());
                return 1;
            })));
        });
        ServerPlayConnectionEvents.JOIN.register((handler, sender, server) -> JOIN_LIST.add(handler.method_32311().method_5667()));
    }

    public static int showRules(class_2168 source) {
        source.method_9226(() -> Placeholders.parseText((class_2561)TextParserUtils.formatText((String)Rulebook.generateRulesString()), (PlaceholderContext)PlaceholderContext.of((class_2168)source)), false);
        return 1;
    }

    public static void openBookGui(class_3222 player) {
        List<class_2561> rulesArray = Rulebook.generateBookPages(player);
        BookElementBuilder bookBuilder = new BookElementBuilder();
        for (class_2561 rule : rulesArray) {
            bookBuilder.addPage(rule);
        }
        bookBuilder.addPage(Placeholders.parseText((class_2561)TextParserUtils.formatText((String)ConfigManager.getConfig().finalPage), (PlaceholderContext)PlaceholderContext.of((class_3222)player)));
        new RulebookGui(player, bookBuilder).open();
    }

    public static List<class_2561> generateBookPages(class_3222 player) {
        Config config = ConfigManager.getConfig();
        ArrayList<class_2561> rulesList = new ArrayList<class_2561>();
        String header = config.rulesHeader;
        String schema = config.ruleSchema;
        List<Config.Rule> rules = config.rules;
        for (int index = 0; index < rules.size(); ++index) {
            Config.Rule rule = rules.get(index);
            String ruleTitle = rule.title;
            String ruleDescription = rule.description;
            String ruleBuilder = header + "\n" + Rulebook.parseRule(schema, index + 1, ruleTitle, ruleDescription);
            rulesList.add(Placeholders.parseText((class_2561)TextParserUtils.formatText((String)ruleBuilder), (PlaceholderContext)PlaceholderContext.of((class_3222)player)));
        }
        return rulesList;
    }

    private static String generateRulesString() {
        Config config = ConfigManager.getConfig();
        StringBuilder rulesString = new StringBuilder();
        String header = config.rulesHeader;
        String schema = config.ruleSchema;
        List<Config.Rule> rules = config.rules;
        if (header != null && !header.isEmpty()) {
            rulesString.append(header).append("\n");
        }
        for (int index = 0; index < rules.size(); ++index) {
            Config.Rule rule = rules.get(index);
            String ruleTitle = rule.title;
            String ruleDescription = rule.description;
            rulesString.append(Rulebook.parseRule(schema, index + 1, ruleTitle, ruleDescription));
            if (index == rules.size() - 1) continue;
            rulesString.append("\n");
        }
        return rulesString.toString();
    }

    public static String parseRule(String line, int ruleNumber, String ruleTitle, String ruleDescription) {
        String rule = Rulebook.parseString(line, "rule_number", String.valueOf(ruleNumber));
        rule = Rulebook.parseString(rule, "rule_title", ruleTitle);
        rule = Rulebook.parseString(rule, "rule_description", ruleDescription);
        return rule;
    }

    private static String parseString(String string, String variableName, String variableReplacement) {
        return string.replaceAll("%" + variableName + "%", variableReplacement);
    }
}

