/*
 * Decompiled with CFR 0.152.
 */
package me.libreh.rulebook.config;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import eu.pb4.placeholders.api.PlaceholderContext;
import eu.pb4.placeholders.api.Placeholders;
import eu.pb4.placeholders.api.TextParserUtils;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import me.libreh.rulebook.Rulebook;
import me.libreh.rulebook.config.Config;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_2561;
import net.minecraft.class_3222;

public class ConfigManager {
    public static int VERSION = 1;
    private static final Path CONFIG_PATH = FabricLoader.getInstance().getConfigDir().resolve("rulebook.json");
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().disableHtmlEscaping().create();
    private static Config CONFIG;

    public static Config getConfig() {
        if (CONFIG == null) {
            return Config.DEFAULT;
        }
        return CONFIG;
    }

    public static boolean loadConfig() {
        boolean ENABLED;
        try {
            Config config = CONFIG;
            if (Files.exists(CONFIG_PATH, new LinkOption[0])) {
                if (config == null) {
                    config = (Config)GSON.fromJson(Files.readString(CONFIG_PATH), Config.class);
                }
            } else {
                config = new Config();
            }
            config.version = VERSION;
            ConfigManager.overrideConfig(config);
            CONFIG = config;
            ENABLED = true;
        }
        catch (Throwable exception) {
            ENABLED = false;
            Rulebook.LOGGER.error("Something went wrong while reading config!");
            exception.printStackTrace();
        }
        return ENABLED;
    }

    public static void overrideConfig(Config configData) {
        try {
            Files.writeString(CONFIG_PATH, (CharSequence)GSON.toJson((Object)configData), new OpenOption[0]);
            CONFIG = configData;
        }
        catch (Exception e) {
            Rulebook.LOGGER.error("Something went wrong while saving config!");
            e.printStackTrace();
        }
    }

    public static boolean hasAccepted(class_3222 player) {
        return ConfigManager.getConfig().acceptedPlayers.contains(player.method_5667());
    }

    public static void accept(class_3222 player) {
        if (!ConfigManager.getConfig().acceptedPlayers.contains(player.method_5667())) {
            ConfigManager.getConfig().acceptedPlayers.add(player.method_5667());
            ConfigManager.loadConfig();
        }
    }

    public static void unaccept(class_3222 player) {
        ConfigManager.getConfig().acceptedPlayers.remove(player.method_5667());
        ConfigManager.loadConfig();
        player.field_13987.method_52396(Placeholders.parseText((class_2561)TextParserUtils.formatText((String)ConfigManager.CONFIG.kickMessages.updatedRules), (PlaceholderContext)PlaceholderContext.of((class_3222)player)));
    }
}

