/*
 * Decompiled with CFR 0.152.
 */
package me.libreh.rulebook.config;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import eu.pb4.placeholders.api.PlaceholderContext;
import eu.pb4.placeholders.api.Placeholders;
import eu.pb4.placeholders.api.node.TextNode;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.UUID;
import me.libreh.rulebook.Rulebook;
import me.libreh.rulebook.config.Config;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_3222;

public class ConfigManager {
    public static int VERSION = 1;
    private static final Path CONFIG_PATH = FabricLoader.getInstance().getConfigDir().resolve("rulebook.json");
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().disableHtmlEscaping().create();
    private static Config CONFIG;

    public static Config getConfig() {
        if (CONFIG == null) {
            return Config.DEFAULT;
        }
        return CONFIG;
    }

    public static boolean loadConfig() {
        boolean ENABLED;
        try {
            Config config = Files.exists(CONFIG_PATH, new LinkOption[0]) ? (Config)GSON.fromJson(Files.readString(CONFIG_PATH), Config.class) : new Config();
            config.version = VERSION;
            Path playerModDataDir = FabricLoader.getInstance().getGameDir().resolve("world/player-mod-data");
            if (Files.exists(playerModDataDir, new LinkOption[0])) {
                Rulebook.LOGGER.info("PlayerDataAPI directory exists, starting migration...");
                Files.walk(playerModDataDir, new FileVisitOption[0]).filter(x$0 -> Files.isRegularFile(x$0, new LinkOption[0])).filter(path -> path.toString().endsWith(".json")).forEach(jsonFilePath -> {
                    UUID playerUuid = UUID.fromString(jsonFilePath.getParent().getFileName().toString());
                    if (!config.acceptedPlayers.contains(playerUuid)) {
                        try (FileReader reader = new FileReader(jsonFilePath.toFile());){
                            JsonObject jsonObject = JsonParser.parseReader((Reader)reader).getAsJsonObject();
                            if (jsonObject.has("hasAccepted") && jsonObject.get("hasAccepted").getAsBoolean()) {
                                config.acceptedPlayers.add(playerUuid);
                                Rulebook.LOGGER.info("Migrating " + jsonFilePath.getParent().getFileName().toString());
                            }
                        }
                        catch (IOException e) {
                            Rulebook.LOGGER.info("Error migrating UUID " + String.valueOf(jsonFilePath.getParent().getFileName()));
                            e.printStackTrace();
                        }
                    } else {
                        Rulebook.LOGGER.info("Skipping UUID " + String.valueOf(jsonFilePath.getParent().getFileName()) + " as player has already accepted the rules");
                    }
                });
            }
            ConfigManager.overrideConfig(config);
            CONFIG = config;
            ENABLED = true;
        }
        catch (Throwable exception) {
            ENABLED = false;
            Rulebook.LOGGER.error("Something went wrong while reading config!");
            exception.printStackTrace();
        }
        return ENABLED;
    }

    public static void overrideConfig() {
        ConfigManager.overrideConfig(CONFIG);
    }

    public static void overrideConfig(Config configData) {
        try {
            Files.writeString(CONFIG_PATH, (CharSequence)GSON.toJson((Object)configData), new OpenOption[0]);
            CONFIG = configData;
        }
        catch (Exception e) {
            Rulebook.LOGGER.error("Something went wrong while saving config!");
            e.printStackTrace();
        }
    }

    public static boolean hasAccepted(class_3222 player) {
        return ConfigManager.getConfig().acceptedPlayers.contains(player.method_5667());
    }

    public static void accept(class_3222 player) {
        if (!ConfigManager.getConfig().acceptedPlayers.contains(player.method_5667())) {
            ConfigManager.getConfig().acceptedPlayers.add(player.method_5667());
            ConfigManager.overrideConfig();
        }
    }

    public static void unaccept(class_3222 player) {
        ConfigManager.getConfig().acceptedPlayers.remove(player.method_5667());
        ConfigManager.overrideConfig();
        player.field_13987.method_52396(Placeholders.parseText((TextNode)Rulebook.PARSER.parseNode(ConfigManager.CONFIG.kickMessages.updatedRules), (PlaceholderContext)PlaceholderContext.of((class_3222)player)));
    }
}

