/*
 * Decompiled with CFR 0.152.
 */
package com.jolly.serversentials.commands.teleports;

import com.jolly.serversentials.Scheduler;
import com.jolly.serversentials.Serversentials;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import net.kyori.adventure.text.minimessage.MiniMessage;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.command.TabCompleter;
import org.bukkit.entity.Player;
import org.bukkit.permissions.PermissionAttachmentInfo;

public class HomeManager
implements CommandExecutor,
TabCompleter {
    private final Serversentials plugin;
    private final Scheduler scheduler;
    private final MiniMessage mm = MiniMessage.miniMessage();
    private final Map<UUID, Map<String, HomeLocation>> homeCache = new ConcurrentHashMap<UUID, Map<String, HomeLocation>>();
    private final Map<UUID, Object> teleportTasks = new ConcurrentHashMap<UUID, Object>();
    private final Map<UUID, Location> moveCheck = new ConcurrentHashMap<UUID, Location>();
    private final Map<UUID, Long> homeCooldowns = new HashMap<UUID, Long>();

    public HomeManager(Serversentials plugin, Scheduler scheduler) {
        this.plugin = plugin;
        this.scheduler = scheduler;
    }

    public boolean onCommand(CommandSender sender, Command command, String label, String[] args) {
        if (!(sender instanceof Player)) {
            sender.sendMessage(this.mm.deserialize((Object)"<red>Only players can use this command!"));
            return true;
        }
        Player player = (Player)sender;
        switch (command.getName().toLowerCase(Locale.ROOT)) {
            case "sethome": {
                this.handleSetHome(player, args);
                break;
            }
            case "home": {
                this.handleHome(player, args);
                break;
            }
            case "delhome": {
                this.handleDelHome(player, args);
                break;
            }
            case "homes": {
                this.handleListHomes(player);
                break;
            }
            default: {
                player.sendActionBar(this.mm.deserialize((Object)"<red>Unknown command."));
            }
        }
        return true;
    }

    private void handleSetHome(Player player, String[] args) {
        if (!player.hasPermission("serversentials.home")) {
            player.sendActionBar(this.mm.deserialize((Object)Serversentials.prefixMessage("messages.no-permission")));
            return;
        }
        if (args.length == 0) {
            player.sendActionBar(this.mm.deserialize((Object)"<red>Usage: /sethome <name>"));
            return;
        }
        String homeName = args[0].toLowerCase(Locale.ROOT);
        int maxHomes = this.getHomeLimit(player);
        this.scheduler.runAsync(() -> {
            Object[] params;
            String sql;
            Map<String, HomeLocation> homes = this.getHomes(player);
            if (homes.size() >= maxHomes && !homes.containsKey(homeName)) {
                this.scheduler.run(player, () -> player.sendActionBar(this.mm.deserialize((Object)("<red>You have reached your home limit (" + maxHomes + ")."))));
                return;
            }
            Location loc = player.getLocation();
            String server = this.plugin.getConfig().getString("server-name", "unknown");
            boolean isMySQL = this.plugin.getDatabase().isMySQL();
            if (isMySQL) {
                sql = "    INSERT INTO homes (uuid, name, world, x, y, z, yaw, pitch, server)\n    VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?)\n    ON DUPLICATE KEY UPDATE\n    world=VALUES(world),\n    x=VALUES(x),\n    y=VALUES(y),\n    z=VALUES(z),\n    yaw=VALUES(yaw),\n    pitch=VALUES(pitch),\n    server=VALUES(server)\n";
                params = new Object[]{player.getUniqueId().toString(), homeName, loc.getWorld().getName(), loc.getX(), loc.getY(), loc.getZ(), Float.valueOf(loc.getYaw()), Float.valueOf(loc.getPitch()), server};
            } else {
                sql = "    INSERT INTO homes (uuid, name, world, x, y, z, yaw, pitch, server)\n    VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?)\n    ON CONFLICT(uuid, name) DO UPDATE SET\n    world=excluded.world,\n    x=excluded.x,\n    y=excluded.y,\n    z=excluded.z,\n    yaw=excluded.yaw,\n    pitch=excluded.pitch,\n    server=excluded.server\n";
                params = new Object[]{player.getUniqueId().toString(), homeName, loc.getWorld().getName(), loc.getX(), loc.getY(), loc.getZ(), Float.valueOf(loc.getYaw()), Float.valueOf(loc.getPitch()), server};
            }
            this.plugin.getDatabase().updateSafe(sql, params);
            homes.put(homeName, new HomeLocation(server, loc.getX(), loc.getY(), loc.getZ(), loc.getYaw(), loc.getPitch(), loc.getWorld().getName()));
            this.homeCache.put(player.getUniqueId(), homes);
            this.scheduler.run(player, () -> player.sendActionBar(this.mm.deserialize((Object)("<green>Home <yellow>" + homeName + "</yellow> set!"))));
        });
    }

    private void handleHome(Player player, String[] args) {
        long elapsed;
        if (!player.hasPermission("serversentials.home")) {
            player.sendActionBar(this.mm.deserialize((Object)Serversentials.prefixMessage("messages.no-permission")));
            return;
        }
        if (args.length == 0) {
            player.sendActionBar(this.mm.deserialize((Object)"<red>Usage: /home <name>"));
            return;
        }
        long cooldownSeconds = this.plugin.getConfig().getLong("modules.home.cooldown", 30L);
        long now = System.currentTimeMillis();
        Long lastUsed = this.homeCooldowns.get(player.getUniqueId());
        if (lastUsed != null && (elapsed = (now - lastUsed) / 1000L) < cooldownSeconds) {
            long remaining = cooldownSeconds - elapsed;
            player.sendActionBar(this.mm.deserialize((Object)("<red>You must wait <yellow>" + remaining + "s <red>before using /home again.")));
            return;
        }
        String homeName = args[0].toLowerCase(Locale.ROOT);
        this.scheduler.runAsync(() -> {
            Map<String, HomeLocation> homes = this.getHomes(player);
            HomeLocation home = homes.get(homeName);
            if (home == null) {
                this.scheduler.run(player, () -> player.sendActionBar(this.mm.deserialize((Object)("<red>Home <yellow>" + homeName + "</yellow> not found."))));
                return;
            }
            String currentServer = this.plugin.getConfig().getString("server-name", "unknown");
            if (!currentServer.equalsIgnoreCase(home.server)) {
                this.scheduler.run(player, () -> player.sendActionBar(this.mm.deserialize((Object)("<red>This home is set on another server: <yellow>" + home.server))));
                return;
            }
            this.startTeleportCountdown(player, homeName, home);
        });
    }

    private void startTeleportCountdown(Player player, String homeName, HomeLocation home) {
        int countdownSeconds = this.getHomeCountdown(player);
        Location startLoc = player.getLocation().clone();
        this.moveCheck.put(player.getUniqueId(), startLoc);
        this.scheduler.run(player, () -> player.sendActionBar(this.mm.deserialize((Object)("<gray>Teleporting to <yellow>" + homeName + "</yellow> in <green>" + countdownSeconds + "</green> seconds..."))));
        for (int i = 1; i <= countdownSeconds; ++i) {
            int remaining = countdownSeconds - i;
            this.scheduler.runLater(player, () -> {
                Location current = player.getLocation();
                Location initial = this.moveCheck.get(player.getUniqueId());
                if (this.hasMoved(initial, current)) {
                    this.teleportTasks.remove(player.getUniqueId());
                    this.moveCheck.remove(player.getUniqueId());
                    player.sendActionBar(this.mm.deserialize((Object)"<red>Teleport cancelled because you moved!"));
                    return;
                }
                if (remaining > 0) {
                    player.sendActionBar(this.mm.deserialize((Object)("<gray>Teleporting in <green>" + remaining + "</green>...")));
                } else {
                    this.performTeleport(player, homeName, home);
                    this.moveCheck.remove(player.getUniqueId());
                    this.teleportTasks.remove(player.getUniqueId());
                }
            }, (long)i * 20L);
        }
    }

    private void performTeleport(Player player, String homeName, HomeLocation home) {
        long now = System.currentTimeMillis();
        long lastUsed = this.homeCooldowns.getOrDefault(player.getUniqueId(), 0L);
        int cooldown = this.getHomeCooldown(player);
        long cooldownMillis = (long)cooldown * 1000L;
        if (!player.hasPermission("serversentials.home.bypasscooldown") && now - lastUsed < cooldownMillis) {
            long remaining = (cooldownMillis - (now - lastUsed)) / 1000L;
            player.sendActionBar(this.mm.deserialize((Object)("<red>You must wait <yellow>" + remaining + "s</yellow> before teleporting again.")));
            return;
        }
        this.scheduler.run(player, () -> {
            Location loc = new Location(Bukkit.getWorld((String)home.world), home.x, home.y, home.z, home.yaw, home.pitch);
            player.teleportAsync(loc).thenRun(() -> {
                player.sendActionBar(this.mm.deserialize((Object)("<green>Teleported to home <yellow>" + homeName + "</yellow>!")));
                this.homeCooldowns.put(player.getUniqueId(), System.currentTimeMillis());
            });
        });
    }

    private boolean hasMoved(Location from, Location to) {
        return from.getWorld() != to.getWorld() || from.distanceSquared(to) > 0.1;
    }

    private void handleDelHome(Player player, String[] args) {
        if (args.length == 0) {
            player.sendActionBar(this.mm.deserialize((Object)"<red>Usage: /delhome <name>"));
            return;
        }
        String homeName = args[0].toLowerCase(Locale.ROOT);
        this.scheduler.runAsync(() -> {
            Map<String, HomeLocation> homes = this.getHomes(player);
            if (!homes.containsKey(homeName)) {
                this.scheduler.run(player, () -> player.sendActionBar(this.mm.deserialize((Object)("<red>Home <yellow>" + homeName + "</yellow> does not exist."))));
                return;
            }
            this.plugin.getDatabase().updateSafe("DELETE FROM homes WHERE uuid=? AND name=?", player.getUniqueId().toString(), homeName);
            homes.remove(homeName);
            this.homeCache.put(player.getUniqueId(), homes);
            this.scheduler.run(player, () -> player.sendActionBar(this.mm.deserialize((Object)("<green>Home <yellow>" + homeName + "</yellow> deleted."))));
        });
    }

    private void handleListHomes(Player player) {
        this.scheduler.runAsync(() -> {
            Map<String, HomeLocation> homes = this.getHomes(player);
            if (homes.isEmpty()) {
                this.scheduler.run(player, () -> player.sendMessage(this.mm.deserialize((Object)"<gray>You have no homes set.")));
                return;
            }
            StringBuilder list = new StringBuilder();
            for (Map.Entry<String, HomeLocation> entry : homes.entrySet()) {
                String name = entry.getKey();
                HomeLocation loc = entry.getValue();
                list.append("<yellow>").append(name).append("</yellow> - <gray>").append(String.format("(x: %.1f, z: %.1f) || ", loc.x(), loc.z()));
            }
            this.scheduler.run(player, () -> player.sendActionBar(this.mm.deserialize((Object)list.toString())));
        });
    }

    private int getHomeLimit(Player player) {
        int result = 1;
        for (PermissionAttachmentInfo perm : player.getEffectivePermissions()) {
            String[] parts;
            String p = perm.getPermission();
            if (!p.startsWith("serversentials.sethome.") || (parts = p.split("\\.")).length < 3) continue;
            String part = parts[2];
            try {
                int value = Integer.parseInt(part);
                result = Math.max(result, value);
            }
            catch (NumberFormatException numberFormatException) {}
        }
        return result;
    }

    private int getHomeCooldown(Player player) {
        int result = Integer.MAX_VALUE;
        for (PermissionAttachmentInfo perm : player.getEffectivePermissions()) {
            String[] parts;
            String p = perm.getPermission();
            if (!p.startsWith("serversentials.home.cooldown.") || (parts = p.split("\\.")).length < 4) continue;
            try {
                int value = Integer.parseInt(parts[3]);
                result = Math.min(result, value);
            }
            catch (NumberFormatException numberFormatException) {}
        }
        if (result == Integer.MAX_VALUE) {
            result = 5;
        }
        return result;
    }

    private int getHomeCountdown(Player player) {
        int result = Integer.MAX_VALUE;
        for (PermissionAttachmentInfo perm : player.getEffectivePermissions()) {
            String[] parts;
            String p = perm.getPermission();
            if (!p.startsWith("serversentials.home.countdown.") || (parts = p.split("\\.")).length < 4) continue;
            try {
                int value = Integer.parseInt(parts[3]);
                result = Math.min(result, value);
            }
            catch (NumberFormatException numberFormatException) {}
        }
        if (result == Integer.MAX_VALUE) {
            result = 5;
        }
        return result;
    }

    private Map<String, HomeLocation> getHomes(Player player) {
        return this.homeCache.computeIfAbsent(player.getUniqueId(), uuid -> {
            HashMap map = new HashMap();
            this.plugin.getDatabase().querySafe("SELECT name, world, x, y, z, yaw, pitch, server FROM homes WHERE uuid=?", rs -> {
                while (rs.next()) {
                    map.put(rs.getString("name").toLowerCase(Locale.ROOT), new HomeLocation(rs.getString("server"), rs.getDouble("x"), rs.getDouble("y"), rs.getDouble("z"), rs.getFloat("yaw"), rs.getFloat("pitch"), rs.getString("world")));
                }
                return null;
            }, player.getUniqueId().toString());
            return map;
        });
    }

    public List<String> onTabComplete(CommandSender sender, Command command, String alias, String[] args) {
        if (!(sender instanceof Player)) {
            return List.of();
        }
        Player player = (Player)sender;
        if (command.getName().equalsIgnoreCase("home") && args.length == 1) {
            String partial = args[0].toLowerCase(Locale.ROOT);
            Map homes = this.homeCache.getOrDefault(player.getUniqueId(), Map.of());
            return homes.keySet().stream().filter(name -> name.startsWith(partial)).sorted().toList();
        }
        return List.of();
    }

    private record HomeLocation(String server, double x, double y, double z, float yaw, float pitch, String world) {
    }
}

