/*
 * Decompiled with CFR 0.152.
 */
package com.jolly.serversentials.commands.teleports;

import com.jolly.serversentials.Scheduler;
import com.jolly.serversentials.Serversentials;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import net.kyori.adventure.text.minimessage.MiniMessage;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.command.TabCompleter;
import org.bukkit.entity.Player;
import org.bukkit.permissions.PermissionAttachmentInfo;

public class WarpManager
implements CommandExecutor,
TabCompleter {
    private final Serversentials plugin;
    private final Scheduler scheduler;
    private final MiniMessage mm = MiniMessage.miniMessage();
    private final Map<String, Warp> warpCache = new ConcurrentHashMap<String, Warp>();
    private final Map<UUID, Object> teleportTasks = new ConcurrentHashMap<UUID, Object>();
    private final long defaultCountdown;
    private final long defaultCooldown;

    public WarpManager(Serversentials plugin, Scheduler scheduler) {
        this.plugin = plugin;
        this.scheduler = scheduler;
        this.defaultCountdown = plugin.getConfig().getLong("modules.warp.default-countdown", 5L);
        this.defaultCooldown = plugin.getConfig().getLong("modules.warp.default-cooldown", 0L);
        this.createTables();
        this.loadAllWarpsAsync();
    }

    public boolean onCommand(CommandSender sender, Command command, String label, String[] args) {
        String cmd;
        if (!(sender instanceof Player)) {
            sender.sendMessage(this.mm.deserialize((Object)"<red>Only players can use this command!"));
            return true;
        }
        Player player = (Player)sender;
        switch (cmd = command.getName().toLowerCase(Locale.ROOT)) {
            case "warp": {
                this.handleWarp(player, args);
                break;
            }
            case "setwarp": {
                this.handleSetWarp(player, args);
                break;
            }
            case "delwarp": {
                this.handleDelWarp(player, args);
                break;
            }
            case "warps": {
                this.handleListWarps(player, args);
                break;
            }
            default: {
                player.sendActionBar(this.mm.deserialize((Object)"<red>Unknown command."));
            }
        }
        return true;
    }

    public List<String> onTabComplete(CommandSender sender, Command command, String alias, String[] args) {
        if (!(sender instanceof Player)) {
            return Collections.emptyList();
        }
        Player player = (Player)sender;
        if (args.length == 1 && (command.getName().equalsIgnoreCase("warp") || command.getName().equalsIgnoreCase("delwarp"))) {
            String partial = args[0].toLowerCase(Locale.ROOT);
            ArrayList<String> out = new ArrayList<String>();
            for (String name : this.warpCache.keySet()) {
                if (!name.toLowerCase(Locale.ROOT).startsWith(partial)) continue;
                out.add(name);
            }
            Collections.sort(out);
            return out;
        }
        return Collections.emptyList();
    }

    private void handleListWarps(Player player, String[] args) {
        if (!player.hasPermission("serversentials.warp")) {
            player.sendActionBar(this.mm.deserialize((Object)Serversentials.prefixMessage("messages.no-permission")));
            return;
        }
        if (this.warpCache.isEmpty()) {
            player.sendActionBar(this.mm.deserialize((Object)"<gray>No warps set."));
            return;
        }
        StringBuilder sb = new StringBuilder("<aqua>Warps: ");
        boolean first = true;
        for (String name : this.warpCache.keySet()) {
            if (!first) {
                sb.append("<gray>, ");
            }
            sb.append("<yellow>").append(name);
            first = false;
        }
        player.sendMessage(this.mm.deserialize((Object)sb.toString()));
    }

    private void handleSetWarp(Player player, String[] args) {
        if (!player.hasPermission("serversentials.setwarp")) {
            player.sendActionBar(this.mm.deserialize((Object)Serversentials.prefixMessage("messages.no-permission")));
            return;
        }
        if (args.length == 0) {
            player.sendActionBar(this.mm.deserialize((Object)"<red>Usage: /setwarp <name>"));
            return;
        }
        String name = args[0].toLowerCase(Locale.ROOT);
        Location loc = player.getLocation();
        String server = this.plugin.getConfig().getString("server-name", "unknown");
        this.scheduler.runAsync(() -> {
            boolean isMySQL = this.plugin.getDatabase().isMySQL();
            if (isMySQL) {
                this.plugin.getDatabase().updateSafe("INSERT INTO warps (name, world, x, y, z, yaw, pitch, server) VALUES (?, ?, ?, ?, ?, ?, ?, ?) ON DUPLICATE KEY UPDATE world=VALUES(world), x=VALUES(x), y=VALUES(y), z=VALUES(z), yaw=VALUES(yaw), pitch=VALUES(pitch), server=VALUES(server)", name, loc.getWorld().getName(), loc.getX(), loc.getY(), loc.getZ(), Float.valueOf(loc.getYaw()), Float.valueOf(loc.getPitch()), server);
            } else {
                this.plugin.getDatabase().updateSafe("INSERT INTO warps (name, world, x, y, z, yaw, pitch, server) VALUES (?, ?, ?, ?, ?, ?, ?, ?) ON CONFLICT(name) DO UPDATE SET world=excluded.world, x=excluded.x, y=excluded.y, z=excluded.z, yaw=excluded.yaw, pitch=excluded.pitch, server=excluded.server", name, loc.getWorld().getName(), loc.getX(), loc.getY(), loc.getZ(), Float.valueOf(loc.getYaw()), Float.valueOf(loc.getPitch()), server);
            }
            this.warpCache.put(name, new Warp(name, loc.getWorld().getName(), loc.getX(), loc.getY(), loc.getZ(), loc.getYaw(), loc.getPitch(), server));
            this.scheduler.run(player, () -> player.sendActionBar(this.mm.deserialize((Object)("<green>Warp <yellow>" + name + "</yellow> has been set."))));
        });
    }

    private void handleDelWarp(Player player, String[] args) {
        if (!player.hasPermission("serversentials.setwarp")) {
            player.sendActionBar(this.mm.deserialize((Object)Serversentials.prefixMessage("messages.no-permission")));
            return;
        }
        if (args.length == 0) {
            player.sendActionBar(this.mm.deserialize((Object)"<red>Usage: /delwarp <name>"));
            return;
        }
        String name = args[0].toLowerCase(Locale.ROOT);
        this.scheduler.runAsync(() -> {
            this.plugin.getDatabase().updateSafe("DELETE FROM warps WHERE name = ?", name);
            this.warpCache.remove(name);
            this.scheduler.run(player, () -> player.sendActionBar(this.mm.deserialize((Object)("<green>Warp <yellow>" + name + "</yellow> deleted."))));
        });
    }

    private void handleWarp(Player player, String[] args) {
        if (args.length == 0) {
            player.sendActionBar(this.mm.deserialize((Object)"<red>Usage: /warp <name>"));
            return;
        }
        String name = args[0].toLowerCase(Locale.ROOT);
        if (!player.hasPermission("serversentials.warp") && !player.hasPermission("serversentials.warp." + name)) {
            player.sendActionBar(this.mm.deserialize((Object)Serversentials.prefixMessage("messages.no-permission")));
            return;
        }
        Warp warp = this.warpCache.get(name);
        if (warp == null) {
            this.scheduler.runAsync(() -> {
                Warp loaded = this.plugin.getDatabase().querySafe("SELECT world, x, y, z, yaw, pitch, server FROM warps WHERE name = ?", rs -> {
                    if (rs.next()) {
                        return new Warp(name, rs.getString("world"), rs.getDouble("x"), rs.getDouble("y"), rs.getDouble("z"), rs.getFloat("yaw"), rs.getFloat("pitch"), rs.getString("server"));
                    }
                    return null;
                }, name);
                if (loaded == null) {
                    this.scheduler.run(player, () -> player.sendActionBar(this.mm.deserialize((Object)"<red>Warp not found.")));
                    return;
                }
                this.warpCache.put(name, loaded);
                this.scheduler.run(player, () -> this.beginWarpProcess(player, name, loaded));
            });
        } else {
            this.beginWarpProcess(player, name, warp);
        }
    }

    private void beginWarpProcess(Player player, String warpName, Warp warp) {
        UUID uuid = player.getUniqueId();
        int cooldownSeconds = this.getNumericPermissionValue(player, "serversentials.warp.cooldown.", (int)this.defaultCooldown, false, Integer.MAX_VALUE);
        this.scheduler.runAsync(() -> {
            Long lastUsed = this.plugin.getDatabase().querySafe("SELECT last_used FROM warp_cooldowns WHERE uuid = ? AND warp = ?", rs -> rs.next() ? Long.valueOf(rs.getLong("last_used")) : null, uuid.toString(), warpName);
            long now = System.currentTimeMillis() / 1000L;
            if (lastUsed != null && now - lastUsed < (long)cooldownSeconds) {
                long remaining = (long)cooldownSeconds - (now - lastUsed);
                this.scheduler.run(player, () -> player.sendActionBar(this.mm.deserialize((Object)("<red>Warp cooldown: <yellow>" + remaining + "s"))));
                return;
            }
            int countdown = this.getNumericPermissionValue(player, "serversentials.warp.countdown.", (int)this.defaultCountdown, true, 0);
            if (countdown <= 0) {
                this.scheduler.run(player, () -> this.performWarpTeleport(player, warpName, warp));
                return;
            }
            Location startLoc = player.getLocation().clone();
            this.scheduler.run(player, () -> player.sendActionBar(this.mm.deserialize((Object)("<gray>Warping to <yellow>" + warpName + "</yellow> in <green>" + countdown + "</green> seconds..."))));
            for (int i = 1; i <= countdown; ++i) {
                int remaining = countdown - i;
                this.scheduler.runLater(player, () -> {
                    Location nowLoc = player.getLocation();
                    if (this.hasMovedSignificantly(startLoc, nowLoc)) {
                        this.scheduler.run(player, () -> player.sendActionBar(this.mm.deserialize((Object)"<red>Warp cancelled because you moved!")));
                        this.teleportTasks.remove(uuid);
                        return;
                    }
                    if (remaining > 0) {
                        this.scheduler.run(player, () -> player.sendActionBar(this.mm.deserialize((Object)("<gray>Warping in <green>" + remaining + "</green>..."))));
                    } else {
                        this.performWarpTeleport(player, warpName, warp);
                        this.teleportTasks.remove(uuid);
                    }
                }, (long)i * 20L);
            }
        });
    }

    private boolean hasMovedSignificantly(Location a, Location b) {
        if (a == null || b == null) {
            return true;
        }
        if (!Objects.equals(a.getWorld(), b.getWorld())) {
            return true;
        }
        return a.distanceSquared(b) > 0.09;
    }

    private void performWarpTeleport(Player player, String warpName, Warp warp) {
        Location loc = new Location(Bukkit.getWorld((String)warp.world), warp.x, warp.y, warp.z, warp.yaw, warp.pitch);
        player.teleportAsync(loc);
        player.sendActionBar(this.mm.deserialize((Object)("<green>Warped to <yellow>" + warpName + "</yellow>")));
        long now = System.currentTimeMillis() / 1000L;
        this.scheduler.runAsync(() -> {
            boolean isMySQL = this.plugin.getDatabase().isMySQL();
            if (isMySQL) {
                this.plugin.getDatabase().updateSafe("INSERT INTO warp_cooldowns (uuid, warp, last_used) VALUES (?, ?, ?) ON DUPLICATE KEY UPDATE last_used = VALUES(last_used)", player.getUniqueId().toString(), warpName, now);
            } else {
                this.plugin.getDatabase().updateSafe("INSERT INTO warp_cooldowns (uuid, warp, last_used) VALUES (?, ?, ?) ON CONFLICT(uuid, warp) DO UPDATE SET last_used = excluded.last_used", player.getUniqueId().toString(), warpName, now);
            }
        });
    }

    private void createTables() {
        this.plugin.getDatabase().updateSafe("CREATE TABLE IF NOT EXISTS warps (\n    name VARCHAR(64) PRIMARY KEY,\n    world VARCHAR(64) NOT NULL,\n    x DOUBLE NOT NULL,\n    y DOUBLE NOT NULL,\n    z DOUBLE NOT NULL,\n    yaw FLOAT NOT NULL,\n    pitch FLOAT NOT NULL,\n    server VARCHAR(64) NOT NULL\n)\n", new Object[0]);
        this.plugin.getDatabase().updateSafe("CREATE TABLE IF NOT EXISTS warp_cooldowns (\n    uuid VARCHAR(36) NOT NULL,\n    warp VARCHAR(64) NOT NULL,\n    last_used BIGINT NOT NULL,\n    PRIMARY KEY (uuid, warp)\n)\n", new Object[0]);
    }

    private void loadAllWarpsAsync() {
        this.scheduler.runAsync(() -> this.plugin.getDatabase().querySafe("SELECT name, world, x, y, z, yaw, pitch, server FROM warps", rs -> {
            while (rs.next()) {
                String name = rs.getString("name");
                this.warpCache.put(name, new Warp(name, rs.getString("world"), rs.getDouble("x"), rs.getDouble("y"), rs.getDouble("z"), rs.getFloat("yaw"), rs.getFloat("pitch"), rs.getString("server")));
            }
            return null;
        }, new Object[0]));
    }

    private int getNumericPermissionValue(Player player, String base, int defaultValue, boolean chooseLower, int maxValueIfInfinite) {
        int result = chooseLower ? Integer.MAX_VALUE : Integer.MIN_VALUE;
        boolean found = false;
        for (PermissionAttachmentInfo permInfo : player.getEffectivePermissions()) {
            String p = permInfo.getPermission();
            if (p == null || !p.startsWith(base)) continue;
            String[] parts = p.split("\\.");
            String last = parts[parts.length - 1];
            if (last.equalsIgnoreCase("infinite")) {
                return maxValueIfInfinite;
            }
            try {
                int v = Integer.parseInt(last);
                if (!found) {
                    result = v;
                    found = true;
                    continue;
                }
                result = chooseLower ? Math.min(result, v) : Math.max(result, v);
            }
            catch (NumberFormatException numberFormatException) {}
        }
        if (!found) {
            return defaultValue;
        }
        return result;
    }

    private record Warp(String name, String world, double x, double y, double z, float yaw, float pitch, String server) {
    }
}

