/*
 * Decompiled with CFR 0.152.
 */
package com.jolly.serversentials.commands.utilities;

import com.jolly.serversentials.Scheduler;
import com.jolly.serversentials.Serversentials;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.minimessage.MiniMessage;
import org.bukkit.Bukkit;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.command.TabCompleter;
import org.bukkit.entity.Player;
import org.bukkit.scoreboard.Scoreboard;
import org.bukkit.scoreboard.Team;

public class Hide
implements CommandExecutor,
TabCompleter {
    private final Serversentials plugin;
    private final Scheduler scheduler;
    private final MiniMessage mm = MiniMessage.miniMessage();
    private final Set<UUID> hiddenPlayers = new HashSet<UUID>();

    public Hide(Scheduler scheduler, Serversentials plugin) {
        this.scheduler = scheduler;
        this.plugin = plugin;
        scheduler.runAsync(() -> plugin.getDatabase().updateSafe("    CREATE TABLE IF NOT EXISTS hide_data (\n        uuid VARCHAR(36) PRIMARY KEY,\n        hidden BOOLEAN NOT NULL DEFAULT 0,\n        previous_name TEXT,\n        previous_team TEXT\n    )\n", new Object[0]));
    }

    public boolean onCommand(CommandSender sender, Command command, String label, String[] args) {
        if (!(sender instanceof Player)) {
            sender.sendMessage("Only players can use this command!");
            return true;
        }
        Player player = (Player)sender;
        if (!player.hasPermission("serversentials.hide")) {
            player.sendActionBar(this.mm.deserialize((Object)Serversentials.prefixMessage("messages.no-permission")));
            return true;
        }
        if (args.length == 0) {
            this.toggleHide(player, player);
            return true;
        }
        if (args.length == 1) {
            Player target = Bukkit.getPlayer((String)args[0]);
            if (target == null) {
                player.sendActionBar(this.mm.deserialize((Object)"<red>Player not found!"));
                return true;
            }
            if (!player.hasPermission("serversentials.hide.others")) {
                player.sendActionBar(this.mm.deserialize((Object)Serversentials.prefixMessage("messages.no-permission")));
                return true;
            }
            this.toggleHide(player, target);
            return true;
        }
        if (args.length >= 2 && args[1].equalsIgnoreCase("off")) {
            Player target = Bukkit.getPlayer((String)args[0]);
            if (target == null) {
                player.sendActionBar(this.mm.deserialize((Object)"<red>Player not found!"));
                return true;
            }
            if (!player.hasPermission("serversentials.hide.others")) {
                player.sendActionBar(this.mm.deserialize((Object)Serversentials.prefixMessage("messages.no-permission")));
                return true;
            }
            this.unhide(target);
            player.sendActionBar(this.mm.deserialize((Object)("<yellow>You have unhidden <white>" + target.getName() + "</white>.")));
            return true;
        }
        return true;
    }

    private void toggleHide(Player executor, Player target) {
        UUID uuid = target.getUniqueId();
        this.scheduler.runAsync(() -> {
            Boolean currentlyHidden = this.plugin.getDatabase().querySafe("SELECT hidden FROM hide_data WHERE uuid = ?", rs -> rs.next() && rs.getBoolean("hidden"), uuid.toString());
            if (Boolean.TRUE.equals(currentlyHidden)) {
                this.scheduler.run(target, () -> this.unhide(target));
                executor.sendActionBar(this.mm.deserialize((Object)("<yellow>" + target.getName() + " is now visible again.")));
                this.plugin.getDatabase().updateSafe("UPDATE hide_data SET hidden = 0 WHERE uuid = ?", uuid.toString());
            } else {
                String serializedCurrent = (String)this.mm.serialize((Component)(target.displayName() != null ? target.displayName() : Component.text((String)target.getName())));
                this.scheduler.run(target, () -> {
                    Component obfuscated = this.mm.deserialize((Object)("<obf>" + target.getName() + "</obf>"));
                    this.applyNickname(target, obfuscated);
                    this.hideNametag(target);
                });
                String oldTeam = this.getPlayerCurrentTeam(target);
                this.plugin.getDatabase().updateSafe("    INSERT INTO hide_data (uuid, hidden, previous_name, previous_team)\n    VALUES (?, ?, ?, ?)\n    ON CONFLICT(uuid) DO UPDATE SET hidden = excluded.hidden, previous_name = excluded.previous_name, previous_team = excluded.previous_team\n", uuid.toString(), true, serializedCurrent, oldTeam);
                this.hiddenPlayers.add(uuid);
                executor.sendActionBar(this.mm.deserialize((Object)("<green>" + target.getName() + " is now hidden!")));
            }
        });
    }

    private void unhide(Player player) {
        UUID uuid = player.getUniqueId();
        Map result = this.plugin.getDatabase().querySafe("SELECT previous_name, previous_team FROM hide_data WHERE uuid = ?", rs -> {
            if (rs.next()) {
                HashMap<String, String> map = new HashMap<String, String>();
                map.put("previous_name", rs.getString("previous_name"));
                map.put("previous_team", rs.getString("previous_team"));
                return map;
            }
            return null;
        }, uuid.toString());
        this.scheduler.run(player, () -> {
            if (result != null) {
                String prevName = (String)result.get("previous_name");
                String prevTeam = (String)result.get("previous_team");
                if (prevName != null && !prevName.isEmpty()) {
                    Component restored = this.mm.deserialize((Object)prevName);
                    player.displayName(restored);
                    player.playerListName(restored);
                } else {
                    player.displayName((Component)Component.text((String)player.getName()));
                    player.playerListName((Component)Component.text((String)player.getName()));
                }
                this.restoreNametag(player, prevTeam);
            }
            player.sendActionBar(this.mm.deserialize((Object)"<yellow>Your name is now visible."));
        });
        this.hiddenPlayers.remove(uuid);
        this.plugin.getDatabase().updateSafe("UPDATE hide_data SET hidden = 0 WHERE uuid = ?", uuid.toString());
    }

    private void hideNametag(Player player) {
        Scoreboard board = Bukkit.getScoreboardManager().getMainScoreboard();
        Team team = board.getTeam("serversentials_hidden");
        if (team == null) {
            team = board.registerNewTeam("serversentials_hidden");
            team.setOption(Team.Option.NAME_TAG_VISIBILITY, Team.OptionStatus.NEVER);
        }
        team.addEntry(player.getName());
    }

    private void restoreNametag(Player player, String previousTeam) {
        Scoreboard board = Bukkit.getScoreboardManager().getMainScoreboard();
        Team hiddenTeam = board.getTeam("serversentials_hidden");
        if (hiddenTeam != null) {
            hiddenTeam.removeEntry(player.getName());
        }
        if (previousTeam != null && !previousTeam.isEmpty() && board.getTeam(previousTeam) != null) {
            board.getTeam(previousTeam).addEntry(player.getName());
        }
    }

    private String getPlayerCurrentTeam(Player player) {
        Scoreboard board = Bukkit.getScoreboardManager().getMainScoreboard();
        Team team = board.getEntryTeam(player.getName());
        return team != null ? team.getName() : null;
    }

    public void loadHiddenStatus(Player player) {
        UUID uuid = player.getUniqueId();
        this.scheduler.runAsync(() -> this.plugin.getDatabase().querySafe("SELECT hidden, previous_name, previous_team FROM hide_data WHERE uuid = ?", rs -> {
            if (rs.next()) {
                boolean isHidden = rs.getBoolean("hidden");
                String previousName = rs.getString("previous_name");
                String previousTeam = rs.getString("previous_team");
                if (isHidden) {
                    this.hiddenPlayers.add(uuid);
                } else {
                    this.hiddenPlayers.remove(uuid);
                }
                this.scheduler.run(player, () -> {
                    if (isHidden) {
                        Component obfuscated = this.mm.deserialize((Object)("<obf>" + player.getName() + "</obf>"));
                        this.applyNickname(player, obfuscated);
                        this.hideNametag(player);
                    } else if (previousName != null && !previousName.isEmpty()) {
                        Component restored = this.mm.deserialize((Object)previousName);
                        this.applyNickname(player, restored);
                        this.restoreNametag(player, previousTeam);
                    }
                });
            }
            return null;
        }, uuid.toString()));
    }

    public boolean isHidden(Player player) {
        return this.hiddenPlayers.contains(player.getUniqueId());
    }

    private void applyNickname(Player player, Component nickname) {
        player.displayName(nickname);
        player.playerListName(nickname);
    }

    public List<String> onTabComplete(CommandSender sender, Command command, String alias, String[] args) {
        if (!command.getName().equalsIgnoreCase("hide")) {
            return null;
        }
        ArrayList<String> completions = new ArrayList<String>();
        if (args.length == 1) {
            for (Player p : Bukkit.getOnlinePlayers()) {
                completions.add(p.getName());
            }
        } else if (args.length == 2) {
            completions.add("off");
        }
        return completions;
    }
}

