/*
 * Decompiled with CFR 0.152.
 */
package com.jolly.serversentials.commands.utilities;

import com.jolly.serversentials.Scheduler;
import com.jolly.serversentials.Serversentials;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import net.kyori.adventure.text.minimessage.MiniMessage;
import org.bukkit.Bukkit;
import org.bukkit.GameMode;
import org.bukkit.Location;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.command.TabCompleter;
import org.bukkit.entity.Player;

public class Monitor
implements CommandExecutor,
TabCompleter {
    private final Serversentials plugin;
    private final Scheduler scheduler;
    private final MiniMessage mm = MiniMessage.miniMessage();
    private final Map<UUID, Location> startLocations = new HashMap<UUID, Location>();
    private final Map<UUID, GameMode> startGamemodes = new HashMap<UUID, GameMode>();
    private final Set<UUID> monitorUsers = new HashSet<UUID>();

    public Monitor(Scheduler scheduler, Serversentials plugin) {
        this.scheduler = scheduler;
        this.plugin = plugin;
    }

    public boolean onCommand(CommandSender sender, Command command, String label, String[] args) {
        if (!(sender instanceof Player)) {
            sender.sendMessage("Only players can use this command!");
            return true;
        }
        Player player = (Player)sender;
        if (!player.hasPermission("serversentials.monitor")) {
            player.sendActionBar(this.mm.deserialize((Object)Serversentials.prefixMessage("messages.no-permission")));
            return true;
        }
        UUID uuid = player.getUniqueId();
        if (args.length == 0) {
            if (!this.monitorUsers.contains(uuid)) {
                player.sendActionBar(this.mm.deserialize((Object)"<yellow>Usage:</yellow> /monitor <player>"));
                return true;
            }
            this.stopMonitoring(player);
            return true;
        }
        String targetName = args[0];
        this.scheduler.run(player, () -> {
            Player target = Bukkit.getPlayer((String)targetName);
            if (target == null) {
                player.sendActionBar(this.mm.deserialize((Object)"<red>Player not found!"));
                return;
            }
            if (!this.monitorUsers.contains(uuid)) {
                this.monitorUsers.add(uuid);
                this.startLocations.put(uuid, player.getLocation().clone());
                this.startGamemodes.put(uuid, player.getGameMode());
                player.setGameMode(GameMode.SPECTATOR);
                player.teleportAsync(target.getLocation().add(0.0, 2.0, 0.0));
                player.sendActionBar(this.mm.deserialize((Object)("<green>You are now monitoring " + target.getName() + "!")));
            } else {
                this.stopMonitoring(player);
            }
        });
        return true;
    }

    public void stopMonitoring(Player player) {
        UUID uuid = player.getUniqueId();
        this.monitorUsers.remove(uuid);
        Location loc = this.startLocations.getOrDefault(uuid, player.getWorld().getSpawnLocation());
        GameMode gm = this.startGamemodes.getOrDefault(uuid, GameMode.SURVIVAL);
        player.setGameMode(gm);
        player.teleportAsync(loc);
        player.sendActionBar(this.mm.deserialize((Object)"<yellow>Stopped monitoring."));
    }

    public List<String> onTabComplete(CommandSender sender, Command command, String alias, String[] args) {
        if (!command.getName().equalsIgnoreCase("monitor")) {
            return null;
        }
        if (args.length == 1) {
            String prefix = args[0].toLowerCase();
            ArrayList<String> completions = new ArrayList<String>();
            for (Player p : Bukkit.getOnlinePlayers()) {
                if (!p.getName().toLowerCase().startsWith(prefix)) continue;
                completions.add(p.getName());
            }
            return completions;
        }
        return Collections.emptyList();
    }
}

