/*
 * Decompiled with CFR 0.152.
 */
package com.jolly.serversentials.commands.utilities;

import com.jolly.serversentials.Scheduler;
import com.jolly.serversentials.Serversentials;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import net.kyori.adventure.text.minimessage.MiniMessage;
import org.bukkit.Bukkit;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.command.TabCompleter;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;

public class Vanish
implements CommandExecutor,
TabCompleter {
    private final Serversentials plugin;
    private final Scheduler scheduler;
    private final MiniMessage mm = MiniMessage.miniMessage();
    private final Set<UUID> vanished = new HashSet<UUID>();

    public Vanish(Scheduler scheduler, Serversentials plugin) {
        this.scheduler = scheduler;
        this.plugin = plugin;
    }

    public boolean onCommand(CommandSender sender, Command command, String label, String[] args) {
        if (!(sender instanceof Player)) {
            sender.sendMessage("Only players can use this command!");
            return true;
        }
        Player player = (Player)sender;
        if (args.length == 1) {
            this.handleVanishOthers(player, args[0]);
        } else {
            this.handleVanish(player);
        }
        return true;
    }

    private void handleVanish(Player player) {
        if (!player.hasPermission("serversentials.vanish")) {
            player.sendActionBar(this.mm.deserialize((Object)Serversentials.prefixMessage("messages.no-permission")));
            return;
        }
        if (!this.vanished.contains(player.getUniqueId())) {
            for (Player other : Bukkit.getOnlinePlayers()) {
                if (other.equals((Object)player) || other.hasPermission("serversentials.vanish.see")) continue;
                other.hidePlayer((Plugin)this.plugin, player);
            }
            this.vanished.add(player.getUniqueId());
            player.sendActionBar(this.mm.deserialize((Object)"<gray>You have <green>vanished</green>."));
            this.addOrUpdateVanishStatus(player, true);
        } else {
            for (Player other : Bukkit.getOnlinePlayers()) {
                if (other.equals((Object)player)) continue;
                other.showPlayer((Plugin)this.plugin, player);
            }
            this.vanished.remove(player.getUniqueId());
            player.sendActionBar(this.mm.deserialize((Object)"<gray>You are now <red>visible</red>."));
            this.addOrUpdateVanishStatus(player, false);
        }
    }

    private void handleVanishOthers(Player player, String targetName) {
        if (!player.hasPermission("serversentials.vanish.others")) {
            player.sendActionBar(this.mm.deserialize((Object)Serversentials.prefixMessage("messages.no-permission")));
            return;
        }
        Player target = Bukkit.getPlayer((String)targetName);
        if (target == null) {
            player.sendActionBar(this.mm.deserialize((Object)Serversentials.prefixMessage("messages.player-not-found")));
            return;
        }
        UUID uuid = target.getUniqueId();
        if (!this.vanished.contains(uuid)) {
            for (Player other : Bukkit.getOnlinePlayers()) {
                if (other.equals((Object)target) || other.hasPermission("serversentials.vanish.see")) continue;
                other.hidePlayer((Plugin)this.plugin, target);
            }
            this.vanished.add(uuid);
            player.sendActionBar(this.mm.deserialize((Object)("<yellow>" + target.getName() + "</yellow> is now <green>vanished</green>.")));
            target.sendActionBar(this.mm.deserialize((Object)("<gray>You have been vanished by <yellow>" + player.getName() + "</yellow>.")));
            this.addOrUpdateVanishStatus(target, true);
        } else {
            for (Player other : Bukkit.getOnlinePlayers()) {
                if (other.equals((Object)target)) continue;
                other.showPlayer((Plugin)this.plugin, target);
            }
            this.vanished.remove(uuid);
            player.sendActionBar(this.mm.deserialize((Object)("<yellow>" + target.getName() + "</yellow> is now <red>visible</red>.")));
            target.sendActionBar(this.mm.deserialize((Object)("<gray>You have been unvanished by <yellow>" + player.getName() + "</yellow>.")));
            this.addOrUpdateVanishStatus(target, false);
        }
    }

    private void addOrUpdateVanishStatus(Player player, boolean vanishedStatus) {
        this.scheduler.runAsync(() -> {
            String uuid = player.getUniqueId().toString();
            boolean isMySQL = this.plugin.getDatabase().isMySQL();
            String query = isMySQL ? "    INSERT INTO vanish_data (uuid, status)\n    VALUES (?, ?)\n    ON DUPLICATE KEY UPDATE status = VALUES(status)\n" : "INSERT OR REPLACE INTO vanish_data (uuid, status) VALUES (?, ?)";
            this.plugin.getDatabase().updateSafe(query, uuid, vanishedStatus);
        });
    }

    public void loadVanishStatus(Player player) {
        UUID uuid = player.getUniqueId();
        this.scheduler.runAsync(() -> {
            boolean finalStatus;
            Boolean vanishedStatus = this.plugin.getDatabase().querySafe("SELECT status FROM vanish_data WHERE uuid = ?", rs -> rs.next() && rs.getBoolean("status"), uuid.toString());
            if (vanishedStatus == null) {
                vanishedStatus = false;
            }
            if (finalStatus = vanishedStatus.booleanValue()) {
                this.vanished.add(uuid);
            } else {
                this.vanished.remove(uuid);
            }
            this.scheduler.runLater(player, () -> {
                for (Player other : Bukkit.getOnlinePlayers()) {
                    if (other.equals((Object)player)) continue;
                    Player target = player;
                    Player observer = other;
                    this.scheduler.run(observer, () -> {
                        if (finalStatus) {
                            if (!observer.hasPermission("serversentials.vanish.see")) {
                                observer.hidePlayer((Plugin)this.plugin, target);
                            }
                        } else {
                            observer.showPlayer((Plugin)this.plugin, target);
                        }
                    });
                }
            }, 40L);
        });
    }

    public Boolean isVanished(Player player) {
        return this.vanished.contains(player.getUniqueId());
    }

    public List<String> onTabComplete(CommandSender sender, Command command, String alias, String[] args) {
        if (!command.getName().equalsIgnoreCase("vanish")) {
            return null;
        }
        ArrayList<String> completions = new ArrayList<String>();
        if (args.length == 1) {
            String prefix = args[0].toLowerCase();
            for (Player p : Bukkit.getOnlinePlayers()) {
                if (!p.getName().toLowerCase().startsWith(prefix)) continue;
                completions.add(p.getName());
            }
        }
        return completions;
    }
}

