/*
 * Decompiled with CFR 0.152.
 */
package com.jolly.serversentials.economy;

import com.jolly.serversentials.Serversentials;
import com.jolly.serversentials.economy.EconomyManager;
import java.util.Collections;
import java.util.List;
import java.util.UUID;
import net.kyori.adventure.text.minimessage.MiniMessage;
import org.bukkit.Bukkit;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.command.TabCompleter;
import org.bukkit.entity.Player;

public class PayCommand
implements CommandExecutor,
TabCompleter {
    private final Serversentials plugin;
    private final EconomyManager economy;
    private final MiniMessage mm = MiniMessage.miniMessage();

    public PayCommand(Serversentials plugin, EconomyManager economy) {
        this.plugin = plugin;
        this.economy = economy;
    }

    public boolean onCommand(CommandSender sender, Command command, String label, String[] args) {
        double amount;
        if (!(sender instanceof Player)) {
            return true;
        }
        Player p = (Player)sender;
        if (args.length != 2) {
            p.sendActionBar(this.mm.deserialize((Object)this.plugin.getConfig().getString("messages.pay-usage")));
            return true;
        }
        Player target = Bukkit.getPlayer((String)args[0]);
        if (target == null || !target.isOnline()) {
            p.sendActionBar(this.mm.deserialize((Object)this.plugin.getConfig().getString("messages.player-not-found")));
            return true;
        }
        if (target.getUniqueId().equals(p.getUniqueId())) {
            p.sendActionBar(this.mm.deserialize((Object)this.plugin.getConfig().getString("messages.invalid-recipient")));
            return true;
        }
        try {
            amount = Double.parseDouble(args[1]);
            if (amount <= 0.0) {
                throw new NumberFormatException();
            }
        }
        catch (NumberFormatException ex) {
            p.sendActionBar(this.mm.deserialize((Object)this.plugin.getConfig().getString("messages.invalid-number")));
            return true;
        }
        UUID senderUUID = p.getUniqueId();
        UUID targetUUID = target.getUniqueId();
        this.economy.getBalanceAsync(senderUUID).thenAccept(balance -> {
            if (balance < amount) {
                p.sendActionBar(this.mm.deserialize((Object)this.plugin.getConfig().getString("messages.pay-insufficient")));
                return;
            }
            this.economy.deductBalanceAsync(senderUUID, amount).thenRun(() -> this.economy.addBalanceAsync(targetUUID, amount).thenRun(() -> {
                String sentMsg = this.plugin.getConfig().getString("messages.pay-sent").replace("{symbol}", this.economy.getCurrencySymbol()).replace("{amount}", String.format("%.2f", amount)).replace("{player}", target.getName());
                String receivedMsg = this.plugin.getConfig().getString("messages.pay-received").replace("{symbol}", this.economy.getCurrencySymbol()).replace("{amount}", String.format("%.2f", amount)).replace("{player}", p.getName());
                p.sendActionBar(this.mm.deserialize((Object)sentMsg));
                target.sendActionBar(this.mm.deserialize((Object)receivedMsg));
            }));
        });
        return true;
    }

    public List<String> onTabComplete(CommandSender sender, Command command, String alias, String[] args) {
        if (args.length != 1) {
            return Collections.emptyList();
        }
        return this.plugin.getServer().getOnlinePlayers().stream().map(Player::getName).filter(name -> name.toLowerCase().startsWith(args[0].toLowerCase())).toList();
    }
}

