/*
 * Decompiled with CFR 0.152.
 */
package com.jolly.serversentials;

import java.io.File;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.concurrent.CompletableFuture;
import org.bukkit.plugin.java.JavaPlugin;

public class DatabaseManager {
    private final JavaPlugin plugin;
    private Connection connection;
    private final boolean useMySQL;
    private final String host;
    private final String database;
    private final String username;
    private final String password;
    private final int port;
    private final File sqliteFile;

    public DatabaseManager(JavaPlugin plugin, boolean useMySQL, String host, int port, String database, String username, String password, File sqliteFile) {
        this.plugin = plugin;
        this.useMySQL = useMySQL;
        this.host = host;
        this.port = port;
        this.database = database;
        this.username = username;
        this.password = password;
        this.sqliteFile = sqliteFile;
    }

    public boolean isMySQL() {
        return this.useMySQL;
    }

    public Connection getConnection() throws SQLException {
        if (this.connection != null && !this.connection.isClosed()) {
            return this.connection;
        }
        if (this.useMySQL) {
            String url = "jdbc:mysql://" + this.host + ":" + this.port + "/" + this.database + "?useSSL=false&autoReconnect=true";
            this.connection = DriverManager.getConnection(url, this.username, this.password);
        } else {
            if (!this.sqliteFile.exists()) {
                try {
                    this.plugin.getDataFolder().mkdirs();
                    this.sqliteFile.createNewFile();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            String url = "jdbc:sqlite:" + this.sqliteFile.getAbsolutePath();
            this.connection = DriverManager.getConnection(url);
        }
        return this.connection;
    }

    public void close() {
        try {
            if (this.connection != null && !this.connection.isClosed()) {
                this.connection.close();
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
    }

    private void setParameters(PreparedStatement ps, Object ... params) throws SQLException {
        for (int i = 0; i < params.length; ++i) {
            ps.setObject(i + 1, params[i]);
        }
    }

    /*
     * Exception decompiling
     */
    public <T> T querySafe(String sql, ResultProcessor<T> processor, Object ... params) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Enabled aggressive exception aggregation
     */
    public int updateSafe(String sql, Object ... params) {
        try (Connection conn = this.getConnection();){
            int n;
            block14: {
                PreparedStatement ps = conn.prepareStatement(sql);
                try {
                    this.setParameters(ps, params);
                    n = ps.executeUpdate();
                    if (ps == null) break block14;
                }
                catch (Throwable throwable) {
                    if (ps != null) {
                        try {
                            ps.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                ps.close();
            }
            return n;
        }
        catch (SQLException e) {
            e.printStackTrace();
            return -1;
        }
    }

    public <T> CompletableFuture<T> querySafeAsync(String sql, ResultProcessor<T> processor, Object ... params) {
        return CompletableFuture.supplyAsync(() -> this.querySafe(sql, processor, params));
    }

    public CompletableFuture<Integer> updateSafeAsync(String sql, Object ... params) {
        return CompletableFuture.supplyAsync(() -> this.updateSafe(sql, params));
    }

    @FunctionalInterface
    public static interface ResultProcessor<T> {
        public T process(ResultSet var1) throws SQLException;
    }
}

