/*
 * Decompiled with CFR 0.152.
 */
package com.jolly.serversentials;

import com.jolly.serversentials.DatabaseManager;
import com.jolly.serversentials.Placeholder;
import com.jolly.serversentials.Scheduler;
import com.jolly.serversentials.commands.Containers;
import com.jolly.serversentials.commands.ReloadCommand;
import com.jolly.serversentials.commands.teleports.HomeManager;
import com.jolly.serversentials.commands.teleports.TpaManager;
import com.jolly.serversentials.commands.teleports.TpoManager;
import com.jolly.serversentials.commands.teleports.WarpManager;
import com.jolly.serversentials.commands.utilities.Enchant;
import com.jolly.serversentials.commands.utilities.Fly;
import com.jolly.serversentials.commands.utilities.GMC;
import com.jolly.serversentials.commands.utilities.GMS;
import com.jolly.serversentials.commands.utilities.GMSP;
import com.jolly.serversentials.commands.utilities.Generic;
import com.jolly.serversentials.commands.utilities.Hide;
import com.jolly.serversentials.commands.utilities.Item;
import com.jolly.serversentials.commands.utilities.Monitor;
import com.jolly.serversentials.commands.utilities.Nick;
import com.jolly.serversentials.commands.utilities.Vanish;
import com.jolly.serversentials.economy.BalanceCommand;
import com.jolly.serversentials.economy.BaltopCommand;
import com.jolly.serversentials.economy.EconomyCommand;
import com.jolly.serversentials.economy.EconomyManager;
import com.jolly.serversentials.economy.PayCommand;
import com.jolly.serversentials.economy.VaultHook;
import com.jolly.serversentials.listeners.GodProtectionListener;
import com.jolly.serversentials.listeners.InvseeListener;
import com.jolly.serversentials.listeners.PlayerJoinListener;
import com.jolly.serversentials.listeners.PlayerLeaveListener;
import java.io.File;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.minimessage.MiniMessage;
import net.milkbowl.vault.economy.Economy;
import org.bukkit.Bukkit;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.TabCompleter;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.server.PluginEnableEvent;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.ServicePriority;
import org.bukkit.plugin.java.JavaPlugin;

public final class Serversentials
extends JavaPlugin {
    private static MiniMessage mm;
    private static FileConfiguration config;
    private static DatabaseManager db;
    private static Scheduler scheduler;

    public void onEnable() {
        this.saveDefaultConfig();
        mm = MiniMessage.miniMessage();
        config = this.getConfig();
        ConfigurationSection dbConfig = config.getConfigurationSection("database");
        String type = dbConfig.getString("type", "sqlite").toLowerCase();
        boolean mysql = this.getConfig().getBoolean("database.mysql", false);
        if (type.equals("mysql")) {
            String host = dbConfig.getString("host", "localhost");
            int port = dbConfig.getInt("port", 3306);
            String database = dbConfig.getString("database", "serversentials");
            String username = dbConfig.getString("username", "root");
            String password = dbConfig.getString("password", "");
            db = new DatabaseManager(this, true, host, port, database, username, password, null);
            this.getLogger().info("\u2705 Using MySQL database at " + host + ":" + port);
        } else {
            String fileName = dbConfig.getString("file", "serversentials.db");
            File sqliteFile = new File(this.getDataFolder(), fileName);
            db = new DatabaseManager(this, false, "", 0, "", "", "", sqliteFile);
            this.getLogger().info("\u2705 Using SQLite database at " + sqliteFile.getAbsolutePath());
        }
        scheduler = new Scheduler(this);
        HomeManager home = new HomeManager(this, scheduler);
        TpaManager tpa = new TpaManager(this, scheduler);
        TpoManager tpo = new TpoManager(this, scheduler);
        final Fly fly = new Fly(scheduler, this);
        final Nick nick = new Nick(scheduler, this);
        GMS gms = new GMS(this);
        GMC gmc = new GMC(this);
        GMSP gmsp = new GMSP(this);
        Containers cont = new Containers(this);
        final Vanish vanish = new Vanish(scheduler, this);
        final Hide hide = new Hide(scheduler, this);
        Monitor mon = new Monitor(scheduler, this);
        Generic gen = new Generic(this, scheduler);
        WarpManager warp = new WarpManager(this, scheduler);
        Item item = new Item(this, scheduler);
        Enchant ench = new Enchant(this, scheduler);
        VaultHook vaultHook = new VaultHook(this, scheduler);
        final EconomyManager economy = new EconomyManager(db, scheduler, vaultHook, this.getConfig().getString("economy.currency-symbol", "$"), this);
        Bukkit.getServicesManager().register(Economy.class, (Object)economy, (Plugin)this, ServicePriority.Highest);
        this.getLogger().info("\u2705 Serversentials economy registered with Vault (if Vault is present)");
        this.getServer().getPluginManager().registerEvents((Listener)new PlayerJoinListener(this, fly, nick, tpa, vanish, hide, gen, scheduler, economy), (Plugin)this);
        this.getServer().getPluginManager().registerEvents((Listener)new InvseeListener(), (Plugin)this);
        this.getServer().getPluginManager().registerEvents((Listener)new PlayerLeaveListener(this, scheduler), (Plugin)this);
        this.getServer().getPluginManager().registerEvents((Listener)new GodProtectionListener(), (Plugin)this);
        this.getCommand("ssreload").setExecutor((CommandExecutor)new ReloadCommand(this));
        if (this.isModuleEnabled("fly")) {
            this.getCommand("fly").setExecutor((CommandExecutor)fly);
            this.getCommand("fly").setTabCompleter((TabCompleter)fly);
            this.getLogger().info("[Serversentials]\u2705 Fly module enabled.");
        }
        if (this.isModuleEnabled("gamemode")) {
            this.getCommand("gms").setExecutor((CommandExecutor)gms);
            this.getCommand("gms").setTabCompleter((TabCompleter)gms);
            this.getCommand("gmsp").setExecutor((CommandExecutor)gmsp);
            this.getCommand("gmsp").setTabCompleter((TabCompleter)gmsp);
            this.getCommand("gmc").setExecutor((CommandExecutor)gmc);
            this.getCommand("gmc").setTabCompleter((TabCompleter)gmc);
            this.getLogger().info("[Serversentials]\u2705 Gamemode module enabled.");
        }
        if (this.isModuleEnabled("nick.enabled")) {
            this.getCommand("nick").setExecutor((CommandExecutor)nick);
            this.getLogger().info("[Serversentials]\u2705 Nickname module enabled.");
        }
        if (this.isModuleEnabled("tpa.enabled")) {
            this.getCommand("tpa").setExecutor((CommandExecutor)tpa);
            this.getCommand("tpa").setTabCompleter((TabCompleter)tpa);
            this.getCommand("tpaccept").setExecutor((CommandExecutor)tpa);
            this.getCommand("tpdeny").setExecutor((CommandExecutor)tpa);
            this.getLogger().info("[Serversentials]\u2705 Tpa module enabled.");
        }
        if (this.isModuleEnabled("tpahere.enabled")) {
            this.getCommand("tpahere").setExecutor((CommandExecutor)tpa);
            this.getCommand("tpahere").setTabCompleter((TabCompleter)tpa);
            this.getLogger().info("[Serversentials]\u2705 Tpahere module enabled.");
        }
        if (this.isModuleEnabled("tptoggle")) {
            this.getCommand("tptoggle").setExecutor((CommandExecutor)tpa);
            this.getLogger().info("[Serversentials]\u2705 Tptoggle module enabled.");
        }
        if (this.isModuleEnabled("tpo")) {
            this.getCommand("tpo").setExecutor((CommandExecutor)tpo);
            this.getCommand("tpo").setTabCompleter((TabCompleter)tpo);
            this.getLogger().info("[Serversentials]\u2705 Tpo module enabled.");
        }
        if (this.isModuleEnabled("tpohere")) {
            this.getCommand("tpohere").setExecutor((CommandExecutor)tpo);
            this.getCommand("tpohere").setTabCompleter((TabCompleter)tpo);
            this.getLogger().info("[Serversentials]\u2705 Tpohere module enabled.");
        }
        if (this.isModuleEnabled("home")) {
            this.getCommand("home").setExecutor((CommandExecutor)home);
            this.getCommand("home").setTabCompleter((TabCompleter)home);
            this.getCommand("sethome").setExecutor((CommandExecutor)home);
            this.getCommand("sethome").setTabCompleter((TabCompleter)home);
            this.getCommand("homes").setExecutor((CommandExecutor)home);
            this.getCommand("delhome").setExecutor((CommandExecutor)home);
            this.getCommand("delhome").setTabCompleter((TabCompleter)home);
            this.getLogger().info("[Serversentials]\u2705 Home module enabled.");
        }
        if (this.isModuleEnabled("craft")) {
            this.getCommand("craft").setExecutor((CommandExecutor)cont);
            this.getLogger().info("[Serversentials]\u2705 Craft module enabled.");
        }
        if (this.isModuleEnabled("anvil")) {
            this.getCommand("anvil").setExecutor((CommandExecutor)cont);
            this.getLogger().info("[Serversentials]\u2705 Anvil module enabled.");
        }
        if (this.isModuleEnabled("loom")) {
            this.getCommand("loom").setExecutor((CommandExecutor)cont);
            this.getLogger().info("[Serversentials]\u2705 loom module enabled.");
        }
        if (this.isModuleEnabled("echest")) {
            this.getCommand("echest").setExecutor((CommandExecutor)cont);
            this.getCommand("ec").setExecutor((CommandExecutor)cont);
            this.getLogger().info("[Serversentials]\u2705 Echest module enabled.");
        }
        if (this.isModuleEnabled("invsee")) {
            this.getCommand("invsee").setExecutor((CommandExecutor)cont);
            this.getCommand("inv").setExecutor((CommandExecutor)cont);
            this.getLogger().info("[Serversentials]\u2705 Invsee module enabled.");
        }
        if (this.isModuleEnabled("stonecutter")) {
            this.getCommand("stonecutter").setExecutor((CommandExecutor)cont);
            this.getCommand("scutter").setExecutor((CommandExecutor)cont);
            this.getLogger().info("[Serversentials]\u2705 Stonecutter module enabled.");
        }
        if (this.isModuleEnabled("smithingtable")) {
            this.getCommand("smithingtable").setExecutor((CommandExecutor)cont);
            this.getCommand("smith").setExecutor((CommandExecutor)cont);
            this.getLogger().info("[Serversentials]\u2705 Smithing Table module enabled.");
        }
        if (this.isModuleEnabled("vanish")) {
            this.getCommand("vanish").setExecutor((CommandExecutor)vanish);
            this.getCommand("vanish").setTabCompleter((TabCompleter)vanish);
            this.getLogger().info("[Serversentials]\u2705 Vanish module enabled.");
        }
        if (this.isModuleEnabled("monitor")) {
            this.getCommand("monitor").setExecutor((CommandExecutor)mon);
            this.getCommand("monitor").setTabCompleter((TabCompleter)mon);
            this.getLogger().info("[Serversentials]\u2705 Monitor module enabled.");
        }
        if (this.isModuleEnabled("heal")) {
            this.getCommand("heal").setExecutor((CommandExecutor)gen);
            this.getCommand("heal").setTabCompleter((TabCompleter)gen);
            this.getLogger().info("[Serversentials]\u2705 Heal module enabled.");
        }
        if (this.isModuleEnabled("feed")) {
            this.getCommand("feed").setExecutor((CommandExecutor)gen);
            this.getCommand("feed").setTabCompleter((TabCompleter)gen);
            this.getLogger().info("[Serversentials]\u2705 Feed module enabled.");
        }
        if (this.isModuleEnabled("god")) {
            this.getCommand("god").setExecutor((CommandExecutor)gen);
            this.getCommand("god").setTabCompleter((TabCompleter)gen);
            this.getLogger().info("[Serversentials]\u2705 God module enabled.");
        }
        if (this.isModuleEnabled("warp")) {
            this.getCommand("warp").setExecutor((CommandExecutor)warp);
            this.getCommand("warps").setExecutor((CommandExecutor)warp);
            this.getCommand("setwarp").setExecutor((CommandExecutor)warp);
            this.getCommand("delwarp").setExecutor((CommandExecutor)warp);
            this.getCommand("warp").setTabCompleter((TabCompleter)warp);
            this.getCommand("warps").setTabCompleter((TabCompleter)warp);
            this.getCommand("setwarp").setTabCompleter((TabCompleter)warp);
            this.getCommand("delwarp").setTabCompleter((TabCompleter)warp);
            this.getLogger().info("[Serversentials]\u2705 Warp module enabled.");
        }
        if (this.isModuleEnabled("item.enabled")) {
            this.getCommand("item").setExecutor((CommandExecutor)item);
            this.getCommand("item").setTabCompleter((TabCompleter)item);
            this.getLogger().info("[Serversentials]\u2705 Item module enabled.");
        }
        if (this.isModuleEnabled("enchant.enabled")) {
            this.getCommand("enchant").setExecutor((CommandExecutor)ench);
            this.getCommand("enchant").setTabCompleter((TabCompleter)ench);
            this.getLogger().info("[Serversentials]\u2705 Enchant module enabled.");
        }
        if (this.isModuleEnabled("economy.enabled")) {
            this.getCommand("balance").setExecutor((CommandExecutor)new BalanceCommand(this, economy));
            this.getCommand("balance").setTabCompleter((TabCompleter)new BalanceCommand(this, economy));
            this.getCommand("pay").setExecutor((CommandExecutor)new PayCommand(this, economy));
            this.getCommand("pay").setTabCompleter((TabCompleter)new PayCommand(this, economy));
            this.getCommand("baltop").setExecutor((CommandExecutor)new BaltopCommand(this, economy));
            this.getCommand("economy").setExecutor((CommandExecutor)new EconomyCommand(this, economy));
            this.getCommand("economy").setTabCompleter((TabCompleter)new EconomyCommand(this, economy));
            this.getLogger().info("[Serversentials]\u2705 Economy module enabled.");
        }
        if (Bukkit.getPluginManager().isPluginEnabled("PlaceholderAPI")) {
            scheduler.runLater(() -> {
                new Placeholder(this, nick, fly, vanish, hide, economy).register();
                this.getLogger().info("\u2705 Registered Serversentials placeholders with PlaceholderAPI!");
            }, 20L);
        } else {
            Bukkit.getPluginManager().registerEvents(new Listener(){
                final /* synthetic */ Serversentials this$0;
                {
                    this.this$0 = this$0;
                }

                @EventHandler
                public void onPluginEnable(PluginEnableEvent event) {
                    if (event.getPlugin().getName().equals("PlaceholderAPI")) {
                        scheduler.runLater(() -> {
                            new Placeholder(this.this$0, nick, fly, vanish, hide, economy).register();
                            this.this$0.getLogger().info("\u2705 Registered Serversentials placeholders with PlaceholderAPI (delayed)!");
                        }, 20L);
                    }
                }
            }, (Plugin)this);
        }
        this.getDatabase().updateSafe("    CREATE TABLE IF NOT EXISTS fly_data (\n        uuid VARCHAR(36) PRIMARY KEY,\n        flying BOOLEAN NOT NULL DEFAULT 0\n    )\n", new Object[0]);
        this.getDatabase().updateSafe("    CREATE TABLE IF NOT EXISTS nick_data (\n        uuid VARCHAR(36) PRIMARY KEY,\n        nickname TEXT\n    )\n", new Object[0]);
        this.getDatabase().updateSafe("    CREATE TABLE IF NOT EXISTS tptoggle_data (\n        uuid VARCHAR(36) PRIMARY KEY,\n        tptoggle BOOLEAN NOT NULL DEFAULT 0\n    )\n", new Object[0]);
        this.getDatabase().updateSafe("    CREATE TABLE IF NOT EXISTS homes (\n        id INTEGER PRIMARY KEY AUTOINCREMENT,\n        uuid VARCHAR(36) NOT NULL,\n        name VARCHAR(32) NOT NULL,\n        world VARCHAR(64) NOT NULL,\n        x DOUBLE NOT NULL,\n        y DOUBLE NOT NULL,\n        z DOUBLE NOT NULL,\n        yaw FLOAT NOT NULL,\n        pitch FLOAT NOT NULL,\n        server VARCHAR(64) NOT NULL,\n        created_at TEXT DEFAULT (datetime('now')),\n        UNIQUE (uuid, name)\n    )\n", new Object[0]);
        this.getDatabase().updateSafe("    CREATE TABLE IF NOT EXISTS leave_data (\n        uuid TEXT PRIMARY KEY,\n        world TEXT NOT NULL,\n        x DOUBLE NOT NULL,\n        y DOUBLE NOT NULL,\n        z DOUBLE NOT NULL,\n        left_at TEXT DEFAULT (datetime('now'))\n    )\n", new Object[0]);
        this.getDatabase().updateSafe("    CREATE TABLE IF NOT EXISTS vanish_data (\n        uuid VARCHAR(36) PRIMARY KEY,\n        status BOOLEAN NOT NULL\n    )\n", new Object[0]);
        this.getLogger().info("\u2705 Serversentials fully initialized!");
    }

    public DatabaseManager getDatabase() {
        return db;
    }

    public void onDisable() {
        if (db != null) {
            db.close();
        }
    }

    public boolean isModuleEnabled(String module) {
        return this.getConfig().getBoolean("modules." + module, true);
    }

    public static Component mm(String string) {
        return mm.deserialize((Object)string);
    }

    public static String prefixMessage(String path) {
        return config.getString(path, path + " is not configured. Check your config.yml!");
    }
}

