/*
 * Decompiled with CFR 0.152.
 */
package com.jolly.serversentials.commands;

import com.jolly.serversentials.Serversentials;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import java.util.UUID;
import net.kyori.adventure.text.minimessage.MiniMessage;
import org.bukkit.Bukkit;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.command.TabCompleter;
import org.bukkit.entity.Player;
import org.bukkit.inventory.Inventory;
import org.jetbrains.annotations.Nullable;

public class Containers
implements CommandExecutor,
TabCompleter {
    private static Serversentials plugin;
    private final MiniMessage mm = MiniMessage.miniMessage();
    public static final Set<UUID> invseeUsers;

    public Containers(Serversentials plugin) {
        Containers.plugin = plugin;
    }

    public boolean onCommand(CommandSender sender, Command command, String s, String[] args) {
        String cmd;
        if (!(sender instanceof Player)) {
            sender.sendMessage(this.mm.deserialize((Object)"<red>Only players can use this command!"));
            return true;
        }
        Player player = (Player)sender;
        switch (cmd = command.getName().toLowerCase(Locale.ROOT)) {
            case "craft": {
                this.handleCraft(player);
                break;
            }
            case "anvil": {
                this.handleAnvil(player);
                break;
            }
            case "loom": {
                this.handleLoom(player);
                break;
            }
            case "echest": 
            case "ec": {
                this.handleEchest(player, args);
                break;
            }
            case "invsee": 
            case "inv": {
                this.handleInvsee(player, args);
                break;
            }
            case "stonecutter": 
            case "scutter": {
                this.handleStoneCutter(player);
                break;
            }
            case "smithingtable": 
            case "smith": {
                this.handleSmith(player);
            }
        }
        return true;
    }

    private void handleCraft(Player player) {
        if (!player.hasPermission("serversentials.craft")) {
            player.sendActionBar(Serversentials.mm(Serversentials.prefixMessage("messages.no-permission")));
            return;
        }
        player.openWorkbench(null, true);
    }

    private void handleAnvil(Player player) {
        if (!player.hasPermission("serversentials.anvil")) {
            player.sendActionBar(Serversentials.mm(Serversentials.prefixMessage("messages.no-permission")));
            return;
        }
        player.openAnvil(null, true);
    }

    private void handleLoom(Player player) {
        if (!player.hasPermission("serversentials.loom")) {
            player.sendActionBar(Serversentials.mm(Serversentials.prefixMessage("messages.no-permission")));
            return;
        }
        player.openLoom(null, true);
    }

    private void handleEchest(Player player, String[] args) {
        if (!player.hasPermission("serversentials.echest")) {
            player.sendActionBar(Serversentials.mm(Serversentials.prefixMessage("messages.no-permission")));
            return;
        }
        if (args.length > 0) {
            if (!player.hasPermission("serversentials.echest.others")) {
                player.sendActionBar(Serversentials.mm(Serversentials.prefixMessage("messages.no-permission")));
                return;
            }
            Player targetPlayer = Bukkit.getPlayer((String)args[0]);
            if (targetPlayer != null) {
                player.openInventory(targetPlayer.getEnderChest());
            } else {
                player.sendActionBar(Serversentials.mm("<red>Player not found!"));
            }
        } else {
            player.openInventory(player.getEnderChest());
        }
    }

    private void handleInvsee(Player player, String[] args) {
        if (!player.hasPermission("serversentials.invsee")) {
            player.sendActionBar(Serversentials.mm(Serversentials.prefixMessage("messages.no-permission")));
            return;
        }
        if (args.length > 0) {
            invseeUsers.add(player.getUniqueId());
            Player targetPlayer = Bukkit.getPlayer((String)args[0]);
            if (targetPlayer != null) {
                player.openInventory((Inventory)targetPlayer.getInventory());
            } else {
                player.sendActionBar(Serversentials.mm("<red>Player not found!"));
            }
        } else {
            player.sendActionBar(Serversentials.mm("Usage: /invsee <player>"));
        }
    }

    private void handleStoneCutter(Player player) {
        if (!player.hasPermission("serversentials.stonecutter")) {
            player.sendActionBar(Serversentials.mm(Serversentials.prefixMessage("messages.no-permission")));
            return;
        }
        player.openStonecutter(null, true);
    }

    private void handleSmith(Player player) {
        if (!player.hasPermission("serversentials.smithingtable")) {
            player.sendActionBar(Serversentials.mm(Serversentials.prefixMessage("messages.no-permission")));
            return;
        }
        player.openSmithingTable(null, true);
    }

    @Nullable
    public List<String> onTabComplete(CommandSender sender, Command command, String s, String[] args) {
        return List.of();
    }

    static {
        invseeUsers = new HashSet<UUID>();
    }
}

