/*
 * Decompiled with CFR 0.152.
 */
package com.jolly.serversentials.commands.teleports;

import com.jolly.serversentials.Scheduler;
import com.jolly.serversentials.Serversentials;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import net.kyori.adventure.text.minimessage.MiniMessage;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.command.TabCompleter;
import org.bukkit.entity.Player;

public class TpaManager
implements CommandExecutor,
TabCompleter {
    private final Serversentials plugin;
    private final Scheduler scheduler;
    private final MiniMessage mm = MiniMessage.miniMessage();
    private final Map<UUID, TPRequest> pendingRequests = new ConcurrentHashMap<UUID, TPRequest>();
    private final Map<UUID, Object> expirationTasks = new ConcurrentHashMap<UUID, Object>();
    private final Map<UUID, Boolean> tptoggleCache = new ConcurrentHashMap<UUID, Boolean>();
    private final long expirationTicks;

    public TpaManager(Serversentials plugin, Scheduler scheduler) {
        this.plugin = plugin;
        this.scheduler = scheduler;
        this.expirationTicks = plugin.getConfig().getLong("modules.tpa.expiration", 60L) * 20L;
    }

    public boolean onCommand(CommandSender sender, Command command, String label, String[] args) {
        String cmd;
        if (!(sender instanceof Player)) {
            sender.sendMessage(this.mm.deserialize((Object)"<red>Only players can use this command!"));
            return true;
        }
        Player player = (Player)sender;
        switch (cmd = command.getName().toLowerCase(Locale.ROOT)) {
            case "tpa": {
                this.handleTpa(player, args);
                break;
            }
            case "tpahere": {
                this.handleTpahere(player, args);
                break;
            }
            case "tpaccept": 
            case "tpac": {
                this.handleAccept(player);
                break;
            }
            case "tpdeny": 
            case "tpd": {
                this.handleDeny(player);
                break;
            }
            case "tptoggle": 
            case "tpt": {
                this.handleToggle(player);
                break;
            }
            default: {
                player.sendActionBar(this.mm.deserialize((Object)"<red>Unknown command."));
            }
        }
        return true;
    }

    private void handleTpa(Player sender, String[] args) {
        if (!sender.hasPermission("serversentials.tpa")) {
            sender.sendActionBar(Serversentials.mm(Serversentials.prefixMessage("messages.no-permission")));
            return;
        }
        if (args.length == 0) {
            sender.sendActionBar(this.mm.deserialize((Object)"<red>Usage: /tpa <player>"));
            return;
        }
        Player receiver = Bukkit.getPlayer((String)args[0]);
        if (!this.isValidTarget(sender, receiver)) {
            return;
        }
        this.sendRequest(sender, receiver, RequestType.TPA);
    }

    private void handleTpahere(Player sender, String[] args) {
        if (!sender.hasPermission("serversentials.tpahere")) {
            sender.sendActionBar(Serversentials.mm(Serversentials.prefixMessage("messages.no-permission")));
            return;
        }
        if (args.length == 0) {
            sender.sendActionBar(this.mm.deserialize((Object)"<red>Usage: /tpahere <player>"));
            return;
        }
        Player receiver = Bukkit.getPlayer((String)args[0]);
        if (!this.isValidTarget(sender, receiver)) {
            return;
        }
        this.sendRequest(sender, receiver, RequestType.TPAHERE);
    }

    private boolean isValidTarget(Player sender, Player receiver) {
        if (receiver == null || !receiver.isOnline()) {
            sender.sendActionBar(this.mm.deserialize((Object)"<red>That player is not online!"));
            return false;
        }
        if (receiver.getUniqueId().equals(sender.getUniqueId())) {
            sender.sendActionBar(this.mm.deserialize((Object)"<red>You cannot send a teleport request to yourself!"));
            return false;
        }
        return true;
    }

    private void sendRequest(Player sender, Player receiver, RequestType type) {
        if (!this.tptoggleCache.getOrDefault(receiver.getUniqueId(), true).booleanValue()) {
            sender.sendActionBar(this.mm.deserialize((Object)("<red>" + receiver.getName() + " is not accepting teleport requests.")));
            return;
        }
        this.pendingRequests.put(receiver.getUniqueId(), new TPRequest(sender.getUniqueId(), type));
        String typeMessage = type == RequestType.TPA ? "to teleport to you!" : "to teleport you to them!";
        sender.sendActionBar(this.mm.deserialize((Object)("<green>Teleport request sent to <yellow>" + receiver.getName())));
        receiver.sendActionBar(this.mm.deserialize((Object)("<yellow>" + sender.getName() + " <green>wants " + typeMessage)));
        receiver.sendActionBar(this.mm.deserialize((Object)"<gray>Type <aqua>/tpaccept | /tpc</aqua><gray> to accept or <red>/tpdeny | /tpd</red><gray> to deny."));
        Object expireTask = this.scheduler.runLater(receiver, () -> {
            if (this.pendingRequests.remove(receiver.getUniqueId()) != null) {
                sender.sendActionBar(this.mm.deserialize((Object)("<red>Your teleport request to <yellow>" + receiver.getName() + "</yellow> has expired.")));
                receiver.sendActionBar(this.mm.deserialize((Object)("<gray>The teleport request from <yellow>" + sender.getName() + "</yellow> has expired.")));
            }
            this.expirationTasks.remove(receiver.getUniqueId());
        }, this.expirationTicks);
        this.expirationTasks.put(receiver.getUniqueId(), expireTask);
    }

    private void handleAccept(Player receiver) {
        long countdownSeconds;
        Player monitored;
        TPRequest request = this.pendingRequests.remove(receiver.getUniqueId());
        if (request == null) {
            receiver.sendActionBar(this.mm.deserialize((Object)"<red>You have no pending teleport requests."));
            return;
        }
        Player sender = Bukkit.getPlayer((UUID)request.sender);
        if (sender == null || !sender.isOnline()) {
            receiver.sendActionBar(this.mm.deserialize((Object)"<red>The player who sent the request is no longer online."));
            return;
        }
        this.scheduler.cancelTask(this.expirationTasks.remove(receiver.getUniqueId()));
        if (request.type == RequestType.TPA) {
            sender.sendActionBar(this.mm.deserialize((Object)("<green>Your /tpa request to <yellow>" + receiver.getName() + "</yellow> was accepted!")));
            receiver.sendActionBar(this.mm.deserialize((Object)("<green>You accepted the /tpa request from <yellow>" + sender.getName() + "</yellow>.")));
            monitored = sender;
            countdownSeconds = this.plugin.getConfig().getLong("modules.tpa.countdown", 5L);
        } else {
            sender.sendActionBar(this.mm.deserialize((Object)("<green>Your /tpahere request to <yellow>" + receiver.getName() + "</yellow> was accepted!")));
            receiver.sendActionBar(this.mm.deserialize((Object)("<green>You accepted the /tpahere request from <yellow>" + sender.getName() + "</yellow>.")));
            monitored = receiver;
            countdownSeconds = this.plugin.getConfig().getLong("modules.tpahere.countdown", 5L);
        }
        Location startLoc = monitored.getLocation().clone();
        ArrayList<Object> countdownTasks = new ArrayList<Object>();
        for (long i = 0L; i < countdownSeconds; ++i) {
            long delay = i * 20L;
            long remaining = countdownSeconds - i;
            Object task = this.scheduler.runLater(monitored, () -> {
                if (!monitored.isOnline()) {
                    return;
                }
                if (!monitored.getLocation().getBlock().equals((Object)startLoc.getBlock())) {
                    monitored.sendActionBar(this.mm.deserialize((Object)"<red>Teleport canceled due to movement!"));
                    if (request.type == RequestType.TPA) {
                        sender.sendActionBar(this.mm.deserialize((Object)"<red>Teleport canceled because you moved."));
                    } else {
                        receiver.sendActionBar(this.mm.deserialize((Object)"<red>Teleport canceled because you moved."));
                    }
                    countdownTasks.forEach(this.scheduler::cancelTask);
                    countdownTasks.clear();
                    return;
                }
                monitored.sendActionBar(this.mm.deserialize((Object)("<aqua>Teleporting in <yellow>" + remaining + "s<aqua>...")));
            }, delay);
            countdownTasks.add(task);
        }
        Object teleportTask = this.scheduler.runLater(monitored, () -> {
            if (!monitored.isOnline()) {
                return;
            }
            if (!monitored.getLocation().getBlock().equals((Object)startLoc.getBlock())) {
                return;
            }
            if (request.type == RequestType.TPA) {
                sender.teleportAsync(receiver.getLocation());
            } else {
                receiver.teleportAsync(sender.getLocation());
            }
        }, countdownSeconds * 20L);
        countdownTasks.add(teleportTask);
    }

    private void handleDeny(Player receiver) {
        TPRequest request = this.pendingRequests.remove(receiver.getUniqueId());
        if (request == null) {
            receiver.sendActionBar(this.mm.deserialize((Object)"<red>You have no pending teleport requests."));
            return;
        }
        Player sender = Bukkit.getPlayer((UUID)request.sender);
        if (sender != null && sender.isOnline()) {
            sender.sendActionBar(this.mm.deserialize((Object)("<red>Your teleport request to <yellow>" + receiver.getName() + "</yellow> was denied.")));
        }
        this.scheduler.cancelTask(this.expirationTasks.remove(receiver.getUniqueId()));
        receiver.sendActionBar(this.mm.deserialize((Object)"<gray>You denied the teleport request."));
    }

    private void handleToggle(Player player) {
        if (!player.hasPermission("serversentials.tptoggle")) {
            player.sendActionBar(this.mm.deserialize((Object)Serversentials.prefixMessage("messages.no-permission")));
            return;
        }
        UUID uuid = player.getUniqueId();
        boolean currentlyEnabled = this.tptoggleCache.getOrDefault(uuid, true);
        boolean newState = !currentlyEnabled;
        this.tptoggleCache.put(uuid, newState);
        this.scheduler.runAsync(() -> this.plugin.getDatabase().updateSafe("INSERT INTO tptoggle_data (uuid, tptoggle) VALUES (?, ?) ON CONFLICT(uuid) DO UPDATE SET tptoggle = ?", uuid.toString(), newState, newState));
        player.sendActionBar(this.mm.deserialize((Object)(newState ? "<green>You can now receive TPA requests." : "<red>You will no longer receive TPA requests.")));
    }

    public List<String> onTabComplete(CommandSender sender, Command command, String alias, String[] args) {
        if (!(sender instanceof Player)) {
            return List.of();
        }
        Player player = (Player)sender;
        if (args.length == 1) {
            String partial = args[0].toLowerCase(Locale.ROOT);
            return Bukkit.getOnlinePlayers().stream().filter(p -> !p.equals((Object)player)).map(Player::getName).filter(name -> name.toLowerCase(Locale.ROOT).startsWith(partial)).sorted().toList();
        }
        return List.of();
    }

    public void loadToggleState(Player player) {
        this.scheduler.runAsync(() -> {
            Boolean enabled = this.plugin.getDatabase().querySafe("SELECT tptoggle FROM tptoggle_data WHERE uuid = ?", rs -> rs.next() ? rs.getBoolean("tptoggle") : true, player.getUniqueId().toString());
            this.tptoggleCache.put(player.getUniqueId(), enabled);
        });
    }

    public static enum RequestType {
        TPA,
        TPAHERE;

    }

    private static class TPRequest {
        UUID sender;
        RequestType type;

        TPRequest(UUID sender, RequestType type) {
            this.sender = sender;
            this.type = type;
        }
    }
}

