/*
 * Decompiled with CFR 0.152.
 */
package com.jolly.serversentials.commands.teleports;

import com.jolly.serversentials.Scheduler;
import com.jolly.serversentials.Serversentials;
import java.util.List;
import java.util.Locale;
import net.kyori.adventure.text.minimessage.MiniMessage;
import org.bukkit.Bukkit;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.command.TabCompleter;
import org.bukkit.entity.Player;

public class TpoManager
implements CommandExecutor,
TabCompleter {
    private final Serversentials plugin;
    private final Scheduler scheduler;
    private final MiniMessage mm = MiniMessage.miniMessage();

    public TpoManager(Serversentials plugin, Scheduler scheduler) {
        this.plugin = plugin;
        this.scheduler = scheduler;
    }

    public boolean onCommand(CommandSender sender, Command command, String label, String[] args) {
        String cmd;
        if (!(sender instanceof Player)) {
            sender.sendMessage(this.mm.deserialize((Object)"<red>Only players can use this command!"));
            return true;
        }
        Player player = (Player)sender;
        switch (cmd = command.getName().toLowerCase(Locale.ROOT)) {
            case "tpo": {
                this.handleTpo(player, args);
                break;
            }
            case "tpohere": {
                this.handleTpohere(player, args);
                break;
            }
            default: {
                player.sendActionBar(this.mm.deserialize((Object)"<red>Unknown command."));
            }
        }
        return true;
    }

    private void handleTpo(Player sender, String[] args) {
        if (!sender.hasPermission("serversentials.tpo")) {
            sender.sendActionBar(Serversentials.mm(Serversentials.prefixMessage("messages.no-permission")));
            return;
        }
        if (args.length == 0) {
            sender.sendActionBar(this.mm.deserialize((Object)"<red>Usage: /tpo <player>"));
            return;
        }
        Player receiver = Bukkit.getPlayer((String)args[0]);
        if (!this.isValidTarget(sender, receiver)) {
            return;
        }
        sender.teleportAsync(receiver.getLocation());
    }

    private void handleTpohere(Player sender, String[] args) {
        if (!sender.hasPermission("serversentials.tpohere")) {
            sender.sendActionBar(Serversentials.mm(Serversentials.prefixMessage("messages.no-permission")));
            return;
        }
        if (args.length == 0) {
            sender.sendActionBar(this.mm.deserialize((Object)"<red>Usage: /tpohere <player>||all"));
            return;
        }
        if (args[0].equalsIgnoreCase("all")) {
            Bukkit.getOnlinePlayers().forEach(player -> player.teleportAsync(sender.getLocation()));
            return;
        }
        Player receiver = Bukkit.getPlayer((String)args[0]);
        if (!this.isValidTarget(sender, receiver)) {
            return;
        }
        receiver.teleportAsync(sender.getLocation());
    }

    private boolean isValidTarget(Player sender, Player receiver) {
        if (receiver == null || !receiver.isOnline()) {
            sender.sendActionBar(this.mm.deserialize((Object)"<red>That player is not online!"));
            return false;
        }
        if (receiver.getUniqueId().equals(sender.getUniqueId())) {
            sender.sendActionBar(this.mm.deserialize((Object)"<red>You cannot send a teleport request to yourself!"));
            return false;
        }
        return true;
    }

    public List<String> onTabComplete(CommandSender sender, Command command, String alias, String[] args) {
        if (!(sender instanceof Player)) {
            return List.of();
        }
        Player player = (Player)sender;
        if (args.length == 1) {
            String partial = args[0].toLowerCase(Locale.ROOT);
            return Bukkit.getOnlinePlayers().stream().filter(p -> !p.equals((Object)player)).map(Player::getName).filter(name -> name.toLowerCase(Locale.ROOT).startsWith(partial)).sorted().toList();
        }
        return List.of();
    }
}

