/*
 * Decompiled with CFR 0.152.
 */
package com.jolly.serversentials.commands.utilities;

import com.jolly.serversentials.Scheduler;
import com.jolly.serversentials.Serversentials;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.stream.Collectors;
import net.kyori.adventure.text.minimessage.MiniMessage;
import org.bukkit.Bukkit;
import org.bukkit.NamespacedKey;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.command.TabCompleter;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;

public class Enchant
implements CommandExecutor,
TabCompleter {
    private final Serversentials plugin;
    private final Scheduler scheduler;
    private final MiniMessage mm = MiniMessage.miniMessage();
    private final List<String> enchantNames;

    public Enchant(Serversentials plugin, Scheduler scheduler) {
        this.plugin = plugin;
        this.scheduler = scheduler;
        this.enchantNames = Arrays.stream(Enchantment.values()).filter(Objects::nonNull).map(e -> e.getKey().getKey().toLowerCase(Locale.ROOT)).collect(Collectors.toList());
    }

    public boolean onCommand(CommandSender sender, Command command, String label, String[] args) {
        int maxLevel;
        if (!(sender instanceof Player)) {
            sender.sendMessage(this.mm.deserialize((Object)"<red>Only players can use this command!"));
            return true;
        }
        Player player = (Player)sender;
        if (!player.hasPermission("serversentials.enchant")) {
            player.sendActionBar(this.mm.deserialize((Object)Serversentials.prefixMessage("messages.no-permission")));
            return true;
        }
        if (args.length < 1) {
            player.sendActionBar(this.mm.deserialize((Object)("<red>Usage: /" + label + " <enchantment> [level] [player]")));
            return true;
        }
        String enchName = args[0].toLowerCase(Locale.ROOT);
        Enchantment enchantment = Enchantment.getByKey((NamespacedKey)NamespacedKey.minecraft((String)enchName));
        if (enchantment == null) {
            player.sendActionBar(this.mm.deserialize((Object)("<red>Invalid enchantment: <white>" + enchName + "</white>")));
            return true;
        }
        boolean respectLimits = this.plugin.getConfig().getBoolean("modules.enchant.respect-max-levels", true);
        int level = maxLevel = enchantment.getMaxLevel();
        if (args.length >= 2) {
            try {
                level = Integer.parseInt(args[1]);
            }
            catch (NumberFormatException e) {
                player.sendActionBar(this.mm.deserialize((Object)"<red>Invalid level!"));
                return true;
            }
        }
        Player target = player;
        if (args.length >= 3) {
            if (!player.hasPermission("serversentials.enchant.others")) {
                player.sendActionBar(this.mm.deserialize((Object)Serversentials.prefixMessage("messages.no-permission")));
                return true;
            }
            target = Bukkit.getPlayer((String)args[2]);
            if (target == null) {
                player.sendActionBar(this.mm.deserialize((Object)"<red>Player not found!"));
                return true;
            }
        }
        int finalLevel = level;
        Player finalTarget = target;
        Enchantment finalEnchant = enchantment;
        this.scheduler.run(finalTarget, () -> {
            ItemStack item = finalTarget.getInventory().getItemInMainHand();
            if (item == null || item.getType().isAir()) {
                finalTarget.sendActionBar(this.mm.deserialize((Object)"<red>You must hold an item in your hand!"));
                return;
            }
            if (finalLevel == 0) {
                if (item.containsEnchantment(finalEnchant)) {
                    item.removeEnchantment(finalEnchant);
                    finalTarget.sendActionBar(this.mm.deserialize((Object)("<yellow>Removed <white>" + finalEnchant.getKey().getKey() + "</white> from your item.")));
                    if (!finalTarget.equals((Object)player)) {
                        player.sendActionBar(this.mm.deserialize((Object)("<yellow>Removed <white>" + finalEnchant.getKey().getKey() + "</white> from <white>" + finalTarget.getName() + "</white>'s item.")));
                    }
                } else {
                    finalTarget.sendActionBar(this.mm.deserialize((Object)"<red>That item doesn\u2019t have that enchantment."));
                }
                return;
            }
            int appliedLevel = respectLimits ? Math.min(finalLevel, finalEnchant.getMaxLevel()) : finalLevel;
            try {
                item.addUnsafeEnchantment(finalEnchant, appliedLevel);
            }
            catch (Exception e) {
                finalTarget.sendActionBar(this.mm.deserialize((Object)"<red>Failed to apply enchantment!"));
                return;
            }
            String enchKey = finalEnchant.getKey().getKey();
            if (finalTarget.equals((Object)player)) {
                player.sendActionBar(this.mm.deserialize((Object)("<green>Applied <white>" + enchKey + " " + appliedLevel + "</white> to your held item.")));
            } else {
                player.sendActionBar(this.mm.deserialize((Object)("<green>Applied <white>" + enchKey + " " + appliedLevel + "</white> to <white>" + finalTarget.getName() + "</white>'s held item.")));
                finalTarget.sendActionBar(this.mm.deserialize((Object)("<green>You received <white>" + enchKey + " " + appliedLevel + "</white> from <white>" + player.getName() + "</white>.")));
            }
        });
        return true;
    }

    public List<String> onTabComplete(CommandSender sender, Command command, String alias, String[] args) {
        if (args.length == 1) {
            String input = args[0].toLowerCase(Locale.ROOT);
            return this.enchantNames.stream().filter(name -> name.startsWith(input)).limit(50L).toList();
        }
        if (args.length == 3) {
            String input = args[2].toLowerCase(Locale.ROOT);
            ArrayList<String> players = new ArrayList<String>();
            for (Player p : Bukkit.getOnlinePlayers()) {
                if (!p.getName().toLowerCase(Locale.ROOT).startsWith(input)) continue;
                players.add(p.getName());
            }
            return players;
        }
        return Collections.emptyList();
    }
}

