/*
 * Decompiled with CFR 0.152.
 */
package com.jolly.serversentials.commands.utilities;

import com.jolly.serversentials.Scheduler;
import com.jolly.serversentials.Serversentials;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import org.bukkit.Bukkit;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.command.TabCompleter;
import org.bukkit.entity.Player;

public class Fly
implements CommandExecutor,
TabCompleter {
    private final Scheduler scheduler;
    private final Serversentials plugin;
    private final Set<UUID> flying = new HashSet<UUID>();

    public Fly(Scheduler scheduler, Serversentials plugin) {
        this.scheduler = scheduler;
        this.plugin = plugin;
    }

    public Set<UUID> getFlying() {
        return this.flying;
    }

    public boolean onCommand(CommandSender sender, Command command, String label, String[] args) {
        if (!(sender instanceof Player)) {
            sender.sendMessage("Only players can use this command!");
            return true;
        }
        Player player = (Player)sender;
        if (!command.getName().equalsIgnoreCase("fly")) {
            return false;
        }
        if (!player.hasPermission("serversentials.fly")) {
            player.sendActionBar(Serversentials.mm(Serversentials.prefixMessage("messages.no-permission")));
            return true;
        }
        UUID uuid = player.getUniqueId();
        if (args.length == 1) {
            if (!player.hasPermission("serversentials.fly.others")) {
                player.sendActionBar(Serversentials.mm(Serversentials.prefixMessage("messages.no-permission")));
                return true;
            }
            Player target = Bukkit.getPlayerExact((String)args[0]);
            if (target == null || !target.isOnline()) {
                player.sendActionBar(Serversentials.mm("<red>Player not found!"));
                return true;
            }
            this.toggleFly(target, true);
            player.sendActionBar(Serversentials.mm("<gold>Toggled fly for <gray>" + target.getName()));
            return true;
        }
        this.toggleFly(player, false);
        return true;
    }

    private void toggleFly(Player player, boolean isTarget) {
        UUID uuid = player.getUniqueId();
        boolean currentlyFlying = this.flying.contains(uuid);
        if (currentlyFlying) {
            this.flying.remove(uuid);
            player.setAllowFlight(false);
            player.sendActionBar(Serversentials.mm("<gray>Disabled flying"));
            this.saveFlyStateAsync(uuid, false);
        } else {
            this.flying.add(uuid);
            player.setAllowFlight(true);
            player.sendActionBar(Serversentials.mm("<gold>Enabled flying"));
            this.saveFlyStateAsync(uuid, true);
        }
    }

    public boolean isFlying(Player player) {
        return this.flying.contains(player.getUniqueId());
    }

    private void saveFlyStateAsync(UUID uuid, boolean flying) {
        this.plugin.getDatabase().updateSafeAsync("    INSERT INTO fly_data (uuid, flying)\n    VALUES (?, ?)\n    ON CONFLICT(uuid) DO UPDATE SET flying = excluded.flying\n", uuid.toString(), flying);
    }

    public CompletableFuture<Void> loadFlyStateAsync(Player player) {
        Bukkit.getLogger().info("[Serversentials] Querying fly state for " + player.getName());
        UUID uuid = player.getUniqueId();
        return this.plugin.getDatabase().querySafeAsync("SELECT flying FROM fly_data WHERE uuid = ?", rs -> {
            if (!rs.next()) {
                return null;
            }
            boolean isFlying = rs.getBoolean("flying");
            Bukkit.getLogger().info("[Serversentials] Flying value in DB: " + isFlying);
            if (isFlying) {
                this.scheduler.run(player, () -> {
                    Bukkit.getLogger().info("[Serversentials] Setting flight for " + player.getName());
                    this.flying.add(uuid);
                    player.setAllowFlight(true);
                    boolean onAir = player.getLocation().clone().subtract(0.0, 0.1, 0.0).getBlock().isPassable();
                    if (onAir) {
                        player.setFlying(true);
                    }
                });
            }
            return null;
        }, uuid.toString());
    }

    public List<String> onTabComplete(CommandSender sender, Command command, String alias, String[] args) {
        if (!command.getName().equalsIgnoreCase("fly")) {
            return null;
        }
        if (args.length == 1) {
            String prefix = args[0].toLowerCase();
            ArrayList<String> completions = new ArrayList<String>();
            for (Player p : Bukkit.getOnlinePlayers()) {
                if (!p.getName().toLowerCase().startsWith(prefix)) continue;
                completions.add(p.getName());
            }
            return completions;
        }
        return Collections.emptyList();
    }
}

