/*
 * Decompiled with CFR 0.152.
 */
package com.jolly.serversentials.commands.utilities;

import com.jolly.serversentials.Scheduler;
import com.jolly.serversentials.Serversentials;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import java.util.UUID;
import net.kyori.adventure.text.minimessage.MiniMessage;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.command.TabCompleter;
import org.bukkit.entity.Player;

public class Generic
implements CommandExecutor,
TabCompleter {
    private final Serversentials plugin;
    private final Scheduler scheduler;
    private final MiniMessage mm = MiniMessage.miniMessage();
    public static final Set<UUID> godUsers = new HashSet<UUID>();

    public Generic(Serversentials plugin, Scheduler scheduler) {
        this.plugin = plugin;
        this.scheduler = scheduler;
        this.createTable();
    }

    private void createTable() {
        this.plugin.getDatabase().updateSafe("        CREATE TABLE IF NOT EXISTS god_mode (\n            uuid TEXT PRIMARY KEY,\n            status BOOLEAN\n        )\n", new Object[0]);
    }

    public boolean onCommand(CommandSender sender, Command command, String s, String[] args) {
        if (!(sender instanceof Player)) {
            sender.sendMessage(this.mm.deserialize((Object)"<red>Only players can use this command!"));
            return true;
        }
        Player player = (Player)sender;
        switch (command.getName().toLowerCase(Locale.ROOT)) {
            case "heal": {
                this.handleHeal(player, args);
                break;
            }
            case "feed": {
                this.handleFeed(player, args);
                break;
            }
            case "god": {
                this.handleGod(player, args);
                break;
            }
            case "top": {
                this.handleTop(player);
                break;
            }
            default: {
                player.sendActionBar(this.mm.deserialize((Object)"<red>Unknown command!"));
            }
        }
        return true;
    }

    private void handleHeal(Player player, String[] args) {
        if (!player.hasPermission("serversentials.heal")) {
            player.sendActionBar(this.mm.deserialize((Object)Serversentials.prefixMessage("messages.no-permission")));
            return;
        }
        if (args.length == 1 && player.hasPermission("serversentials.heal.others")) {
            Player target = Bukkit.getPlayer((String)args[0]);
            if (target == null) {
                player.sendActionBar(this.mm.deserialize((Object)"<red>Player not found!"));
                return;
            }
            target.setHealth(target.getMaxHealth());
            player.sendActionBar(this.mm.deserialize((Object)("<green>You healed <white>" + target.getName() + "</white>.")));
            target.sendActionBar(this.mm.deserialize((Object)"<green>You have been healed!"));
            return;
        }
        player.setHealth(player.getMaxHealth());
        player.sendActionBar(this.mm.deserialize((Object)"<green>You have been healed!"));
    }

    private void handleFeed(Player player, String[] args) {
        if (!player.hasPermission("serversentials.feed")) {
            player.sendActionBar(this.mm.deserialize((Object)Serversentials.prefixMessage("messages.no-permission")));
            return;
        }
        if (args.length == 1 && player.hasPermission("serversentials.feed.others")) {
            Player target = Bukkit.getPlayer((String)args[0]);
            if (target == null) {
                player.sendActionBar(this.mm.deserialize((Object)"<red>Player not found!"));
                return;
            }
            target.setFoodLevel(20);
            target.setSaturation(20.0f);
            player.sendActionBar(this.mm.deserialize((Object)("<green>You fed <white>" + target.getName() + "</white>.")));
            target.sendActionBar(this.mm.deserialize((Object)"<green>You have been fed!"));
            return;
        }
        player.setFoodLevel(20);
        player.setSaturation(20.0f);
        player.sendActionBar(this.mm.deserialize((Object)"<green>You have been fed!"));
    }

    private void handleGod(Player player, String[] args) {
        boolean enabled;
        if (!player.hasPermission("serversentials.god")) {
            player.sendActionBar(this.mm.deserialize((Object)Serversentials.prefixMessage("messages.no-permission")));
            return;
        }
        Player target = player;
        if (args.length == 1 && player.hasPermission("serversentials.god.others") && (target = Bukkit.getPlayer((String)args[0])) == null) {
            player.sendActionBar(this.mm.deserialize((Object)"<red>Player not found!"));
            return;
        }
        UUID targetId = target.getUniqueId();
        boolean bl = enabled = !godUsers.contains(targetId);
        if (enabled) {
            godUsers.add(targetId);
            target.setInvulnerable(true);
            this.saveGodStatus(targetId, true);
            target.sendActionBar(this.mm.deserialize((Object)"<green>God mode enabled."));
            if (!target.equals((Object)player)) {
                player.sendActionBar(this.mm.deserialize((Object)("<green>Enabled god mode for <white>" + target.getName() + "</white>.")));
            }
        } else {
            godUsers.remove(targetId);
            target.setInvulnerable(false);
            this.saveGodStatus(targetId, false);
            target.sendActionBar(this.mm.deserialize((Object)"<yellow>God mode disabled."));
            if (!target.equals((Object)player)) {
                player.sendActionBar(this.mm.deserialize((Object)("<yellow>Disabled god mode for <white>" + target.getName() + "</white>.")));
            }
        }
    }

    private void handleTop(Player player) {
        if (!player.hasPermission("serversentials.top")) {
            player.sendActionBar(this.mm.deserialize((Object)Serversentials.prefixMessage("messages.no-permission")));
            return;
        }
        World world = player.getWorld();
        Block topBlock = world.getHighestBlockAt(player.getLocation());
        while (!topBlock.getType().isSolid() && topBlock.getY() > 0) {
            topBlock = topBlock.getRelative(BlockFace.DOWN);
        }
        Location teleportLoc = topBlock.getLocation().add(0.5, 1.0, 0.5);
        player.teleport(teleportLoc);
    }

    private void saveGodStatus(UUID uuid, boolean status) {
        this.scheduler.runAsync(() -> this.plugin.getDatabase().updateSafe("REPLACE INTO god_mode (uuid, status) VALUES (?, ?)", uuid.toString(), status));
    }

    public void loadGodStatus(Player player) {
        UUID uuid = player.getUniqueId();
        this.scheduler.runAsync(() -> this.plugin.getDatabase().querySafe("SELECT status FROM god_mode WHERE uuid = ?", rs -> {
            if (rs.next() && rs.getBoolean("status")) {
                godUsers.add(uuid);
                this.scheduler.run(player, () -> {
                    player.setInvulnerable(true);
                    player.sendActionBar(this.mm.deserialize((Object)"<green>God mode restored."));
                });
            }
            return null;
        }, uuid.toString()));
    }

    public List<String> onTabComplete(CommandSender sender, Command command, String alias, String[] args) {
        if (args.length == 1) {
            ArrayList<String> completions = new ArrayList<String>();
            for (Player p : Bukkit.getOnlinePlayers()) {
                if (p.getName().equalsIgnoreCase(sender.getName())) continue;
                completions.add(p.getName());
            }
            return completions;
        }
        return Collections.emptyList();
    }
}

