/*
 * Decompiled with CFR 0.152.
 */
package com.jolly.serversentials.commands.utilities;

import com.jolly.serversentials.Scheduler;
import com.jolly.serversentials.Serversentials;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import net.kyori.adventure.text.minimessage.MiniMessage;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.command.TabCompleter;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;

public class Item
implements CommandExecutor,
TabCompleter {
    private final Serversentials plugin;
    private final Scheduler scheduler;
    private final MiniMessage mm = MiniMessage.miniMessage();
    private final List<String> materialNames;

    public Item(Serversentials plugin, Scheduler scheduler) {
        this.plugin = plugin;
        this.scheduler = scheduler;
        this.materialNames = Arrays.stream(Material.values()).filter(Material::isItem).map(mat -> mat.name().toLowerCase(Locale.ROOT)).toList();
    }

    public boolean onCommand(CommandSender sender, Command command, String label, String[] args) {
        int maxStack;
        if (!(sender instanceof Player)) {
            sender.sendMessage(this.mm.deserialize((Object)"<red>Only players can use this command!"));
            return true;
        }
        Player player = (Player)sender;
        if (!player.hasPermission("serversentials.item")) {
            player.sendActionBar(this.mm.deserialize((Object)Serversentials.prefixMessage("messages.no-permission")));
            return true;
        }
        if (args.length < 1) {
            player.sendActionBar(this.mm.deserialize((Object)("<red>Usage: /" + label + " <material> [amount] [player]")));
            return true;
        }
        Material material = Material.matchMaterial((String)args[0].toUpperCase(Locale.ROOT));
        if (material == null || !material.isItem()) {
            player.sendActionBar(this.mm.deserialize((Object)("<red>Invalid material: <white>" + args[0] + "</white>")));
            return true;
        }
        boolean respectMaxStack = this.plugin.getConfig().getBoolean("modules.item.respect-max-stack-size", true);
        int amount = maxStack = material.getMaxStackSize();
        if (args.length >= 2) {
            try {
                amount = Math.max(1, Integer.parseInt(args[1]));
            }
            catch (NumberFormatException e) {
                player.sendActionBar(this.mm.deserialize((Object)"<red>Invalid amount!"));
                return true;
            }
        }
        Player target = player;
        if (args.length >= 3) {
            if (!player.hasPermission("serversentials.item.others")) {
                player.sendActionBar(this.mm.deserialize((Object)Serversentials.prefixMessage("messages.no-permission")));
                return true;
            }
            target = Bukkit.getPlayer((String)args[2]);
            if (target == null) {
                player.sendActionBar(this.mm.deserialize((Object)"<red>Player not found!"));
                return true;
            }
        }
        Player finalTarget = target;
        int finalAmount = amount;
        this.scheduler.run(finalTarget, () -> {
            if (respectMaxStack) {
                int giveAmount;
                for (int remaining = finalAmount; remaining > 0; remaining -= giveAmount) {
                    giveAmount = Math.min(remaining, maxStack);
                    finalTarget.getInventory().addItem(new ItemStack[]{new ItemStack(material, giveAmount)});
                }
            } else {
                finalTarget.getInventory().addItem(new ItemStack[]{new ItemStack(material, finalAmount)});
            }
            String itemName = material.name().toLowerCase(Locale.ROOT);
            if (finalTarget.equals((Object)player)) {
                player.sendActionBar(this.mm.deserialize((Object)("<green>Gave yourself <white>" + finalAmount + "x " + itemName + "</white>.")));
            } else {
                player.sendActionBar(this.mm.deserialize((Object)("<green>Gave <white>" + finalAmount + "x " + itemName + "</white> to <white>" + finalTarget.getName() + "</white>.")));
                finalTarget.sendActionBar(this.mm.deserialize((Object)("<green>You received <white>" + finalAmount + "x " + itemName + "</white> from <white>" + player.getName() + "</white>.")));
            }
        });
        return true;
    }

    public List<String> onTabComplete(CommandSender sender, Command command, String alias, String[] args) {
        if (args.length == 1) {
            String input = args[0].toLowerCase(Locale.ROOT);
            return this.materialNames.stream().filter(name -> name.startsWith(input)).limit(50L).toList();
        }
        if (args.length == 3) {
            String input = args[2].toLowerCase(Locale.ROOT);
            ArrayList<String> players = new ArrayList<String>();
            for (Player p : Bukkit.getOnlinePlayers()) {
                if (!p.getName().toLowerCase(Locale.ROOT).startsWith(input)) continue;
                players.add(p.getName());
            }
            return players;
        }
        return Collections.emptyList();
    }
}

