/*
 * Decompiled with CFR 0.152.
 */
package com.jolly.serversentials.commands.utilities;

import com.jolly.serversentials.Scheduler;
import com.jolly.serversentials.Serversentials;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.minimessage.MiniMessage;
import org.bukkit.Bukkit;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.command.TabCompleter;
import org.bukkit.entity.Player;

public class Nick
implements CommandExecutor,
TabCompleter {
    private final Serversentials plugin;
    private final Scheduler scheduler;
    private final MiniMessage mm = MiniMessage.miniMessage();

    public Nick(Scheduler scheduler, Serversentials plugin) {
        this.scheduler = scheduler;
        this.plugin = plugin;
    }

    public boolean onCommand(CommandSender sender, Command command, String label, String[] args) {
        if (!(sender instanceof Player)) {
            sender.sendMessage("Only players can use this command!");
            return true;
        }
        Player player = (Player)sender;
        if (!player.hasPermission("serversentials.nick")) {
            player.sendActionBar(this.mm.deserialize((Object)Serversentials.prefixMessage("messages.no-permission")));
            return true;
        }
        int maxNickLength = this.plugin.getConfig().getInt("modules.nick.maxlength");
        if (args.length == 0) {
            this.resetNickname(player);
            player.sendActionBar(this.mm.deserialize((Object)"<gold>Nickname reset"));
            return true;
        }
        if (args.length == 1 && args[0].equalsIgnoreCase("reset")) {
            this.resetNickname(player);
            player.sendActionBar(this.mm.deserialize((Object)"<gold>Nickname reset"));
            return true;
        }
        if (args.length == 1) {
            String newNick = args[0];
            if (newNick.length() > maxNickLength) {
                player.sendActionBar(this.mm.deserialize((Object)("<red>Nickname must be" + maxNickLength + "characters or less!")));
                return true;
            }
            Component displayName = this.mm.deserialize((Object)newNick);
            this.scheduler.runAsync(() -> {
                this.plugin.getDatabase().updateSafe("INSERT INTO nick_data (uuid, nickname) VALUES (?, ?) ON CONFLICT(uuid) DO UPDATE SET nickname = ?", player.getUniqueId().toString(), newNick, newNick);
                this.scheduler.run(player, () -> this.applyNickname(player, displayName));
            });
            player.sendActionBar(this.mm.deserialize((Object)("<green>Your nickname has been changed to <white>" + newNick)));
            return true;
        }
        if (args.length >= 2) {
            if (!player.hasPermission("serversentials.nick.others")) {
                player.sendActionBar(this.mm.deserialize((Object)"<red>You don't have permission to change others' nicknames!"));
                return true;
            }
            String newNick = args[0];
            String targetName = args[1];
            Player target = Bukkit.getPlayerExact((String)targetName);
            if (target == null) {
                player.sendActionBar(this.mm.deserialize((Object)"<red>Player not found!"));
                return true;
            }
            if (newNick.length() > maxNickLength) {
                player.sendActionBar(this.mm.deserialize((Object)("<red>Nickname must be" + maxNickLength + "characters or less!")));
                return true;
            }
            Component displayName = this.mm.deserialize((Object)newNick);
            this.scheduler.runAsync(() -> {
                this.plugin.getDatabase().updateSafe("INSERT INTO nick_data (uuid, nickname) VALUES (?, ?) ON CONFLICT(uuid) DO UPDATE SET nickname = ?", target.getUniqueId().toString(), newNick, newNick);
                this.scheduler.run(target, () -> this.applyNickname(target, displayName));
            });
            player.sendActionBar(this.mm.deserialize((Object)("<green>You changed <white>" + target.getName() + "'s <green>nickname to <white>" + newNick)));
            target.sendActionBar(this.mm.deserialize((Object)("<yellow>Your nickname has been changed to <white>" + newNick + "<yellow> by " + player.getName())));
            return true;
        }
        return true;
    }

    private void resetNickname(Player player) {
        this.scheduler.runAsync(() -> {
            this.plugin.getDatabase().updateSafe("DELETE FROM nick_data WHERE uuid = ?", player.getUniqueId().toString());
            this.scheduler.run(player, () -> {
                player.displayName((Component)Component.text((String)player.getName()));
                player.playerListName((Component)Component.text((String)player.getName()));
                player.sendMessage(this.mm.deserialize((Object)"<yellow>Your nickname has been reset."));
            });
        });
    }

    public String getNick(Player player) {
        UUID uuid = player.getUniqueId();
        return this.plugin.getDatabase().querySafe("SELECT nickname FROM nick_data WHERE uuid = ?", rs -> {
            String nickname;
            if (rs.next() && (nickname = rs.getString("nickname")) != null && !nickname.isEmpty()) {
                return nickname;
            }
            return null;
        }, uuid.toString());
    }

    public void loadNicknameAsync(Player player) {
        UUID uuid = player.getUniqueId();
        this.scheduler.runAsync(() -> this.plugin.getDatabase().querySafe("SELECT nickname FROM nick_data WHERE uuid = ?", rs -> {
            String nickname;
            if (rs.next() && (nickname = rs.getString("nickname")) != null && !nickname.isEmpty()) {
                this.scheduler.run(player, () -> this.applyNickname(player, this.mm.deserialize((Object)nickname)));
            }
            return null;
        }, uuid.toString()));
    }

    private void applyNickname(Player player, Component nickname) {
        player.displayName(nickname);
        player.playerListName(nickname);
    }

    public List<String> onTabComplete(CommandSender sender, Command command, String alias, String[] args) {
        if (!command.getName().equalsIgnoreCase("nick")) {
            return null;
        }
        ArrayList<String> completions = new ArrayList<String>();
        if (args.length == 1) {
            completions.add("reset");
        }
        if (args.length == 2) {
            String prefix = args[1].toLowerCase();
            for (Player p : Bukkit.getOnlinePlayers()) {
                if (!p.getName().toLowerCase().startsWith(prefix)) continue;
                completions.add(p.getName());
            }
        }
        return completions;
    }
}

