/*
 * Decompiled with CFR 0.152.
 */
package com.jolly.serversentials.economy;

import com.jolly.serversentials.Serversentials;
import com.jolly.serversentials.economy.EconomyManager;
import java.util.Collections;
import java.util.List;
import net.kyori.adventure.text.minimessage.MiniMessage;
import org.bukkit.Bukkit;
import org.bukkit.OfflinePlayer;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.command.TabCompleter;
import org.bukkit.entity.Player;

public class BalanceCommand
implements CommandExecutor,
TabCompleter {
    private final Serversentials plugin;
    private final EconomyManager economy;
    private final MiniMessage mm = MiniMessage.miniMessage();

    public BalanceCommand(Serversentials plugin, EconomyManager economy) {
        this.plugin = plugin;
        this.economy = economy;
    }

    public boolean onCommand(CommandSender sender, Command command, String label, String[] args) {
        Player p;
        Player p2;
        if (!this.plugin.getConfig().getBoolean("economy.enabled", true)) {
            return true;
        }
        Player target = null;
        if (args.length == 0) {
            if (!(sender instanceof Player)) {
                return true;
            }
            Player p3 = (Player)sender;
            target = p3;
        } else if (args.length == 1) {
            OfflinePlayer offline = Bukkit.getOfflinePlayer((String)args[0]);
            if (offline == null || offline.getUniqueId() == null) {
                sender.sendActionBar(this.mm.deserialize((Object)this.plugin.getConfig().getString("messages.player-not-found")));
                return true;
            }
            target = offline.getPlayer() != null ? offline.getPlayer() : (Player)sender;
        }
        Player display = target instanceof Player ? (p2 = target) : null;
        Player offlineTarget = target instanceof Player ? (p = target) : target;
        this.economy.getBalanceAsync(offlineTarget.getUniqueId()).thenAccept(arg_0 -> this.lambda$onCommand$0((OfflinePlayer)offlineTarget, display, sender, arg_0));
        return true;
    }

    public List<String> onTabComplete(CommandSender sender, Command command, String alias, String[] args) {
        if (args.length != 1) {
            return Collections.emptyList();
        }
        return this.plugin.getServer().getOnlinePlayers().stream().map(Player::getName).filter(name -> name.toLowerCase().startsWith(args[0].toLowerCase())).toList();
    }

    private /* synthetic */ void lambda$onCommand$0(OfflinePlayer offlineTarget, Player display, CommandSender sender, Double balance) {
        String msg = this.plugin.getConfig().getString("messages.balance-display").replace("{player}", offlineTarget.getName()).replace("{symbol}", this.economy.getCurrencySymbol()).replace("{balance}", String.format("%.2f", balance));
        if (display != null) {
            display.sendActionBar(this.mm.deserialize((Object)msg));
        } else {
            sender.sendActionBar(this.mm.deserialize((Object)msg));
        }
    }
}

