/*
 * Decompiled with CFR 0.152.
 */
package com.jolly.serversentials.economy;

import com.jolly.serversentials.Serversentials;
import com.jolly.serversentials.economy.EconomyManager;
import java.util.Map;
import java.util.UUID;
import net.kyori.adventure.text.minimessage.MiniMessage;
import org.bukkit.Bukkit;
import org.bukkit.OfflinePlayer;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

public class BaltopCommand
implements CommandExecutor {
    private final Serversentials plugin;
    private final EconomyManager economy;
    private final MiniMessage mm = MiniMessage.miniMessage();
    private final int perPage = 10;

    public BaltopCommand(Serversentials plugin, EconomyManager economy) {
        this.plugin = plugin;
        this.economy = economy;
    }

    public boolean onCommand(CommandSender sender, Command command, String label, String[] args) {
        int page = 1;
        if (args.length >= 1) {
            try {
                page = Math.max(1, Integer.parseInt(args[0]));
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        int finalPage = page;
        this.economy.getTopBalancesAsync(page, 10).thenAccept(list -> {
            if (list.isEmpty()) {
                sender.sendMessage(this.mm.deserialize((Object)this.plugin.getConfig().getString("messages.baltop-empty")));
                return;
            }
            sender.sendMessage(this.mm.deserialize((Object)this.plugin.getConfig().getString("messages.baltop-header").replace("{page}", String.valueOf(finalPage))));
            for (int i = 0; i < list.size(); ++i) {
                OfflinePlayer offline;
                Map.Entry entry = (Map.Entry)list.get(i);
                UUID uuid = (UUID)entry.getKey();
                double balance = (Double)entry.getValue();
                Player online = Bukkit.getPlayer((UUID)uuid);
                String playerName = online != null ? online.getName() : ((offline = Bukkit.getOfflinePlayer((UUID)uuid)).getName() != null ? offline.getName() : uuid.toString());
                String line = this.plugin.getConfig().getString("baltop-line", "<yellow>{rank}. {player} - {symbol}{balance}").replace("{rank}", String.valueOf((finalPage - 1) * 10 + i + 1)).replace("{player}", playerName).replace("{symbol}", this.economy.getCurrencySymbol()).replace("{balance}", String.format("%.2f", balance));
                sender.sendMessage(this.mm.deserialize((Object)line));
            }
        });
        return true;
    }
}

