/*
 * Decompiled with CFR 0.152.
 */
package com.jolly.serversentials.economy;

import com.jolly.serversentials.Serversentials;
import com.jolly.serversentials.economy.EconomyManager;
import java.util.Collections;
import java.util.List;
import java.util.UUID;
import net.kyori.adventure.text.minimessage.MiniMessage;
import org.bukkit.Bukkit;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.command.TabCompleter;
import org.bukkit.entity.Player;

public class EconomyCommand
implements CommandExecutor,
TabCompleter {
    private final Serversentials plugin;
    private final EconomyManager economy;
    private final MiniMessage mm = MiniMessage.miniMessage();

    public EconomyCommand(Serversentials plugin, EconomyManager economy) {
        this.plugin = plugin;
        this.economy = economy;
    }

    public boolean onCommand(CommandSender sender, Command command, String label, String[] args) {
        double amount;
        if (args.length != 3) {
            sender.sendActionBar(this.mm.deserialize((Object)this.plugin.getConfig().getString("messages.economy-usage")));
            return true;
        }
        String action = args[0].toLowerCase();
        Player target = Bukkit.getOfflinePlayer((String)args[1]).getPlayer();
        if (target == null) {
            sender.sendActionBar(this.mm.deserialize((Object)Serversentials.prefixMessage(this.plugin.getConfig().getString("messages.player-not-found"))));
            return true;
        }
        try {
            amount = Double.parseDouble(args[2]);
        }
        catch (NumberFormatException e) {
            sender.sendActionBar(this.mm.deserialize((Object)this.plugin.getConfig().getString("messages.invalid-number")));
            return true;
        }
        UUID targetUUID = target.getUniqueId();
        switch (action) {
            case "set": {
                this.economy.setBalanceAsync(targetUUID, amount).thenRun(() -> sender.sendActionBar(this.mm.deserialize((Object)this.plugin.getConfig().getString("messages.economy-success").replace("{action}", "Set").replace("{symbol}", this.economy.getCurrencySymbol()).replace("{amount}", String.format("%.2f", amount)).replace("{player}", target.getName()))));
                break;
            }
            case "give": {
                this.economy.addBalanceAsync(targetUUID, amount).thenRun(() -> sender.sendActionBar(this.mm.deserialize((Object)this.plugin.getConfig().getString("messages.economy-success").replace("{action}", "Gave").replace("{symbol}", this.economy.getCurrencySymbol()).replace("{amount}", String.format("%.2f", amount)).replace("{player}", target.getName()))));
                break;
            }
            case "deduct": {
                this.economy.deductBalanceAsync(targetUUID, amount).thenRun(() -> sender.sendActionBar(this.mm.deserialize((Object)this.plugin.getConfig().getString("messages.economy-success").replace("{action}", "Deducted").replace("{symbol}", this.economy.getCurrencySymbol()).replace("{amount}", String.format("%.2f", amount)).replace("{player}", target.getName()))));
                break;
            }
            default: {
                sender.sendActionBar(this.mm.deserialize((Object)this.plugin.getConfig().getString("messages.economy-usage")));
            }
        }
        return true;
    }

    public List<String> onTabComplete(CommandSender sender, Command command, String alias, String[] args) {
        if (args.length != 2) {
            return Collections.emptyList();
        }
        return this.plugin.getServer().getOnlinePlayers().stream().map(Player::getName).filter(name -> name.toLowerCase().startsWith(args[1].toLowerCase())).toList();
    }
}

