/*
 * Decompiled with CFR 0.152.
 */
package com.jolly.serversentials.economy;

import com.jolly.serversentials.DatabaseManager;
import com.jolly.serversentials.Scheduler;
import com.jolly.serversentials.Serversentials;
import com.jolly.serversentials.economy.VaultHook;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import net.kyori.adventure.text.minimessage.MiniMessage;
import net.milkbowl.vault.economy.Economy;
import net.milkbowl.vault.economy.EconomyResponse;
import org.bukkit.Bukkit;
import org.bukkit.OfflinePlayer;
import org.bukkit.entity.Player;

public class EconomyManager
implements Economy {
    private final DatabaseManager db;
    private final Scheduler scheduler;
    private final VaultHook vaultHook;
    private final MiniMessage mm = MiniMessage.miniMessage();
    private String currencySymbol;
    private final Serversentials plugin;
    private List<Map.Entry<UUID, Double>> cachedTopBalances = new ArrayList<Map.Entry<UUID, Double>>();
    private long cacheExpire = 0L;

    public EconomyManager(DatabaseManager db, Scheduler scheduler, VaultHook vaultHook, String currencySymbol, Serversentials plugin) {
        this.db = db;
        this.scheduler = scheduler;
        this.vaultHook = vaultHook;
        this.currencySymbol = currencySymbol;
        this.plugin = plugin;
        scheduler.runAsync(() -> db.updateSafe("    CREATE TABLE IF NOT EXISTS economy (\n        uuid VARCHAR(36) PRIMARY KEY,\n        balance DOUBLE NOT NULL DEFAULT 0\n    )\n", new Object[0]));
    }

    public CompletableFuture<Double> getBalanceAsync(UUID uuid) {
        if (this.vaultHook.isHooked()) {
            return CompletableFuture.supplyAsync(() -> this.vaultHook.getEconomy().getBalance(Bukkit.getOfflinePlayer((UUID)uuid)));
        }
        return this.db.querySafeAsync("SELECT balance FROM economy WHERE uuid = ?", rs -> rs.next() ? rs.getDouble("balance") : 0.0, uuid.toString());
    }

    public CompletableFuture<Void> setBalanceAsync(UUID uuid, double amount) {
        if (this.vaultHook.isHooked()) {
            return CompletableFuture.runAsync(() -> {
                OfflinePlayer player = Bukkit.getOfflinePlayer((UUID)uuid);
                double current = this.vaultHook.getEconomy().getBalance(player);
                this.vaultHook.getEconomy().depositPlayer(player, -current + amount);
            });
        }
        return this.db.updateSafeAsync("INSERT INTO economy (uuid, balance) VALUES (?, ?)\nON CONFLICT(uuid) DO UPDATE SET balance = excluded.balance\n", uuid.toString(), amount).thenApply(i -> null);
    }

    public CompletableFuture<Void> addBalanceAsync(UUID uuid, double amount) {
        if (this.vaultHook.isHooked()) {
            return CompletableFuture.runAsync(() -> this.vaultHook.getEconomy().depositPlayer(Bukkit.getOfflinePlayer((UUID)uuid), amount));
        }
        return this.getBalanceAsync(uuid).thenCompose(balance -> this.setBalanceAsync(uuid, balance + amount));
    }

    public CompletableFuture<Void> deductBalanceAsync(UUID uuid, double amount) {
        if (this.vaultHook.isHooked()) {
            return CompletableFuture.runAsync(() -> this.vaultHook.getEconomy().withdrawPlayer(Bukkit.getOfflinePlayer((UUID)uuid), amount));
        }
        return this.getBalanceAsync(uuid).thenCompose(balance -> this.setBalanceAsync(uuid, balance - amount));
    }

    public CompletableFuture<List<Map.Entry<UUID, Double>>> getTopBalancesAsync(int page, int perPage) {
        long now = System.currentTimeMillis();
        if (this.cacheExpire > now && !this.cachedTopBalances.isEmpty()) {
            int start = Math.max(0, (page - 1) * perPage);
            int end = Math.min(start + perPage, this.cachedTopBalances.size());
            return CompletableFuture.completedFuture(this.cachedTopBalances.subList(start, end));
        }
        return this.db.querySafeAsync("SELECT uuid, balance FROM economy ORDER BY balance DESC", rs -> {
            ArrayList<Map.Entry<UUID, Double>> all = new ArrayList<Map.Entry<UUID, Double>>();
            while (rs.next()) {
                all.add(new AbstractMap.SimpleEntry<UUID, Double>(UUID.fromString(rs.getString("uuid")), rs.getDouble("balance")));
            }
            this.cachedTopBalances = all;
            this.cacheExpire = System.currentTimeMillis() + 30000L;
            int start = Math.max(0, (page - 1) * perPage);
            int end = Math.min(start + perPage, all.size());
            return all.subList(start, end);
        }, new Object[0]);
    }

    public String getCurrencySymbol() {
        return this.currencySymbol;
    }

    public void setStartingBalance(Player player) {
        if (!player.hasPlayedBefore()) {
            double start = this.plugin.getConfig().getDouble("economy.starting-balance");
            if (start == 0.0) {
                return;
            }
            this.setBalanceAsync(player.getUniqueId(), start).thenRun(() -> {
                String msg = this.plugin.getConfig().getString("messages.starting-balance").replace("{symbol}", this.getCurrencySymbol()).replace("{amount}", String.format("%.2f", start));
                player.sendActionBar(this.mm.deserialize((Object)msg));
            });
        }
    }

    public boolean isEnabled() {
        return true;
    }

    public String getName() {
        return "Serversentials-Economy";
    }

    public boolean hasBankSupport() {
        return false;
    }

    public int fractionalDigits() {
        return 2;
    }

    public String format(double amount) {
        return this.currencySymbol + String.format("%.2f", amount);
    }

    public String currencyNamePlural() {
        return "Coins";
    }

    public String currencyNameSingular() {
        return "Coin";
    }

    public boolean hasAccount(String playerName) {
        return true;
    }

    public boolean hasAccount(OfflinePlayer player) {
        return true;
    }

    public boolean hasAccount(String playerName, String worldName) {
        return true;
    }

    public boolean hasAccount(OfflinePlayer player, String worldName) {
        return true;
    }

    public boolean createPlayerAccount(String playerName) {
        return true;
    }

    public boolean createPlayerAccount(OfflinePlayer player) {
        return true;
    }

    public boolean createPlayerAccount(String playerName, String worldName) {
        return true;
    }

    public boolean createPlayerAccount(OfflinePlayer player, String worldName) {
        return true;
    }

    public double getBalance(String playerName, String world) {
        return this.getBalance(playerName);
    }

    public double getBalance(OfflinePlayer player, String world) {
        return this.getBalance(player);
    }

    public boolean has(String playerName, String world, double amount) {
        return this.has(playerName, amount);
    }

    public boolean has(OfflinePlayer player, String world, double amount) {
        return this.has(player, amount);
    }

    public EconomyResponse withdrawPlayer(String playerName, String world, double amount) {
        OfflinePlayer player = Bukkit.getOfflinePlayer((String)playerName);
        this.deductBalanceAsync(player.getUniqueId(), amount).join();
        return new EconomyResponse(amount, this.getBalance(player), EconomyResponse.ResponseType.SUCCESS, "Withdraw successful");
    }

    public EconomyResponse withdrawPlayer(OfflinePlayer player, String world, double amount) {
        this.deductBalanceAsync(player.getUniqueId(), amount).join();
        return new EconomyResponse(amount, this.getBalance(player), EconomyResponse.ResponseType.SUCCESS, "Withdraw successful");
    }

    public EconomyResponse depositPlayer(String playerName, String world, double amount) {
        return this.depositPlayer(playerName, amount);
    }

    public EconomyResponse depositPlayer(OfflinePlayer player, String world, double amount) {
        return this.depositPlayer(player, amount);
    }

    public double getBalance(String playerName) {
        OfflinePlayer p = Bukkit.getOfflinePlayer((String)playerName);
        return this.vaultHook.isHooked() ? this.vaultHook.getEconomy().getBalance(p) : this.getBalanceAsync(p.getUniqueId()).join().doubleValue();
    }

    public double getBalance(OfflinePlayer player) {
        return this.vaultHook.isHooked() ? this.vaultHook.getEconomy().getBalance(player) : this.getBalanceAsync(player.getUniqueId()).join().doubleValue();
    }

    public boolean has(String playerName, double amount) {
        return this.getBalance(playerName) >= amount;
    }

    public boolean has(OfflinePlayer player, double amount) {
        return this.getBalance(player) >= amount;
    }

    public EconomyResponse withdrawPlayer(OfflinePlayer player, double amount) {
        if (amount < 0.0) {
            return new EconomyResponse(amount, this.getBalance(player), EconomyResponse.ResponseType.FAILURE, "Amount must be positive");
        }
        try {
            boolean success = (Boolean)((CompletableFuture)((CompletableFuture)this.deductBalanceAsync(player.getUniqueId(), amount).thenApply(v -> true)).exceptionally(ex -> false)).get();
            double newBalance = this.getBalance(player);
            if (!success || newBalance < 0.0) {
                this.addBalanceAsync(player.getUniqueId(), amount).join();
                return new EconomyResponse(amount, this.getBalance(player), EconomyResponse.ResponseType.FAILURE, "Insufficient funds");
            }
            return new EconomyResponse(amount, newBalance, EconomyResponse.ResponseType.SUCCESS, "Withdraw successful");
        }
        catch (Exception ex2) {
            this.plugin.getLogger().warning("Withdraw failed for " + player.getName() + ": " + ex2.getMessage());
            return new EconomyResponse(amount, this.getBalance(player), EconomyResponse.ResponseType.FAILURE, ex2.getMessage());
        }
    }

    public EconomyResponse withdrawPlayer(String playerName, double amount) {
        return this.withdrawPlayer(Bukkit.getOfflinePlayer((String)playerName), amount);
    }

    public EconomyResponse depositPlayer(OfflinePlayer player, double amount) {
        if (amount < 0.0) {
            return new EconomyResponse(amount, this.getBalance(player), EconomyResponse.ResponseType.FAILURE, "Amount must be positive");
        }
        try {
            boolean success = (Boolean)((CompletableFuture)((CompletableFuture)this.addBalanceAsync(player.getUniqueId(), amount).thenApply(v -> true)).exceptionally(ex -> false)).get();
            double newBalance = this.getBalance(player);
            if (!success) {
                return new EconomyResponse(amount, newBalance, EconomyResponse.ResponseType.FAILURE, "Deposit failed");
            }
            return new EconomyResponse(amount, newBalance, EconomyResponse.ResponseType.SUCCESS, "Deposit successful");
        }
        catch (Exception ex2) {
            this.plugin.getLogger().warning("Deposit failed for " + player.getName() + ": " + ex2.getMessage());
            double balance = this.getBalance(player);
            return new EconomyResponse(amount, balance, EconomyResponse.ResponseType.FAILURE, ex2.getMessage());
        }
    }

    public EconomyResponse depositPlayer(String playerName, double amount) {
        return this.depositPlayer(Bukkit.getOfflinePlayer((String)playerName), amount);
    }

    public EconomyResponse createBank(String name, String player) {
        return null;
    }

    public EconomyResponse createBank(String name, OfflinePlayer player) {
        return null;
    }

    public EconomyResponse deleteBank(String name) {
        return null;
    }

    public EconomyResponse bankBalance(String name) {
        return null;
    }

    public EconomyResponse bankHas(String name, double amount) {
        return null;
    }

    public EconomyResponse bankWithdraw(String name, double amount) {
        return null;
    }

    public EconomyResponse bankDeposit(String name, double amount) {
        return null;
    }

    public EconomyResponse isBankOwner(String name, String playerName) {
        return null;
    }

    public EconomyResponse isBankOwner(String name, OfflinePlayer player) {
        return null;
    }

    public EconomyResponse isBankMember(String name, String playerName) {
        return null;
    }

    public EconomyResponse isBankMember(String name, OfflinePlayer player) {
        return null;
    }

    public double getBankBalance(String name) {
        return 0.0;
    }

    public List<String> getBanks() {
        return Collections.emptyList();
    }
}

