/*
 * Decompiled with CFR 0.152.
 */
package com.jolly.serversentials.economy;

import com.jolly.serversentials.Scheduler;
import com.jolly.serversentials.Serversentials;
import net.milkbowl.vault.economy.Economy;
import org.bukkit.Bukkit;
import org.bukkit.plugin.RegisteredServiceProvider;

public class VaultHook {
    private Economy economy;
    private boolean hooked = false;
    private final Serversentials plugin;
    private final Scheduler scheduler;

    public VaultHook(Serversentials plugin, Scheduler scheduler) {
        this.plugin = plugin;
        this.scheduler = scheduler;
    }

    public void hook() {
        this.scheduler.runLater(() -> {
            try {
                RegisteredServiceProvider rsp = Bukkit.getServicesManager().getRegistration(Economy.class);
                if (rsp != null) {
                    this.economy = (Economy)rsp.getProvider();
                    this.hooked = true;
                    this.plugin.getLogger().info("\u2705 Vault hooked successfully! Using " + this.economy.getName());
                } else {
                    this.plugin.getLogger().warning("\u26a0\ufe0f Vault found but no Economy provider registered! Falling back to internal economy.");
                }
            }
            catch (Exception e) {
                this.plugin.getLogger().warning("\u26a0\ufe0f Vault hook failed: " + e.getMessage());
            }
        }, 1L);
    }

    public boolean isHooked() {
        return this.hooked && this.economy != null;
    }

    public Economy getEconomy() {
        return this.economy;
    }
}

