/*
 * Decompiled with CFR 0.152.
 */
package com.github.teamfusion.summonerscrolls.client.render.entity.models;

import com.github.teamfusion.summonerscrolls.common.entity.summons.piglin.PiglinSummon;
import java.util.function.Supplier;
import net.minecraft.client.model.AnimationUtils;
import net.minecraft.client.model.PlayerModel;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.monster.piglin.Piglin;
import net.minecraft.world.entity.monster.piglin.PiglinArmPose;

public class PiglinSummonModel<T extends Mob>
extends PlayerModel<T> {
    public static final ModelLayerLocation LAYER_LOCATION = new ModelLayerLocation(new ResourceLocation("summonerscrolls", "piglin"), "main");
    public final ModelPart rightEar;
    private final ModelPart leftEar;
    private final PartPose bodyDefault;
    private final PartPose headDefault;
    private final PartPose leftArmDefault;
    private final PartPose rightArmDefault;

    public PiglinSummonModel(ModelPart modelPart) {
        super(modelPart, false);
        this.rightEar = this.f_102808_.m_171324_("right_ear");
        this.leftEar = this.f_102808_.m_171324_("left_ear");
        this.bodyDefault = this.f_102810_.m_171308_();
        this.headDefault = this.f_102808_.m_171308_();
        this.leftArmDefault = this.f_102812_.m_171308_();
        this.rightArmDefault = this.f_102811_.m_171308_();
    }

    public static Supplier<LayerDefinition> createMesh() {
        CubeDeformation cubeDeformation = CubeDeformation.f_171458_;
        MeshDefinition meshDefinition = PlayerModel.m_170825_((CubeDeformation)cubeDeformation, (boolean)false);
        PartDefinition partDefinition = meshDefinition.m_171576_();
        partDefinition.m_171599_("body", CubeListBuilder.m_171558_().m_171514_(16, 16).m_171488_(-4.0f, 0.0f, -2.0f, 8.0f, 12.0f, 4.0f, cubeDeformation), PartPose.f_171404_);
        PiglinSummonModel.addHead(cubeDeformation, meshDefinition);
        partDefinition.m_171599_("hat", CubeListBuilder.m_171558_(), PartPose.f_171404_);
        return () -> LayerDefinition.m_171565_((MeshDefinition)meshDefinition, (int)64, (int)64);
    }

    public static void addHead(CubeDeformation cubeDeformation, MeshDefinition meshDefinition) {
        PartDefinition partDefinition = meshDefinition.m_171576_();
        PartDefinition partDefinition2 = partDefinition.m_171599_("head", CubeListBuilder.m_171558_().m_171514_(0, 0).m_171488_(-5.0f, -8.0f, -4.0f, 10.0f, 8.0f, 8.0f, cubeDeformation).m_171514_(31, 1).m_171488_(-2.0f, -4.0f, -5.0f, 4.0f, 4.0f, 1.0f, cubeDeformation).m_171514_(2, 4).m_171488_(2.0f, -2.0f, -5.0f, 1.0f, 2.0f, 1.0f, cubeDeformation).m_171514_(2, 0).m_171488_(-3.0f, -2.0f, -5.0f, 1.0f, 2.0f, 1.0f, cubeDeformation), PartPose.f_171404_);
        partDefinition2.m_171599_("left_ear", CubeListBuilder.m_171558_().m_171514_(51, 6).m_171488_(0.0f, 0.0f, -2.0f, 1.0f, 5.0f, 4.0f, cubeDeformation), PartPose.m_171423_((float)4.5f, (float)-6.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)-0.5235988f));
        partDefinition2.m_171599_("right_ear", CubeListBuilder.m_171558_().m_171514_(39, 6).m_171488_(-1.0f, 0.0f, -2.0f, 1.0f, 5.0f, 4.0f, cubeDeformation), PartPose.m_171423_((float)-4.5f, (float)-6.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.5235988f));
    }

    public void setupAnim(T mob, float f, float g, float h, float i, float j) {
        this.f_102810_.m_171322_(this.bodyDefault);
        this.f_102808_.m_171322_(this.headDefault);
        this.f_102812_.m_171322_(this.leftArmDefault);
        this.f_102811_.m_171322_(this.rightArmDefault);
        super.m_6973_(mob, f, g, h, i, j);
        float k = 0.5235988f;
        float l = h * 0.1f + f * 0.5f;
        float m = 0.08f + g * 0.4f;
        this.leftEar.f_104205_ = -0.5235988f - Mth.m_14089_((float)(l * 1.2f)) * m;
        this.rightEar.f_104205_ = 0.5235988f + Mth.m_14089_((float)l) * m;
        if (mob instanceof PiglinSummon) {
            PiglinSummon abstractPiglin = (PiglinSummon)mob;
            PiglinArmPose piglinArmPose = abstractPiglin.getArmPose();
            if (piglinArmPose == PiglinArmPose.DANCING) {
                float n = h / 60.0f;
                this.rightEar.f_104205_ = 0.5235988f + (float)Math.PI / 180 * Mth.m_14031_((float)(n * 30.0f)) * 10.0f;
                this.leftEar.f_104205_ = -0.5235988f - (float)Math.PI / 180 * Mth.m_14089_((float)(n * 30.0f)) * 10.0f;
                this.f_102808_.f_104200_ = Mth.m_14031_((float)(n * 10.0f));
                this.f_102808_.f_104201_ = Mth.m_14031_((float)(n * 40.0f)) + 0.4f;
                this.f_102811_.f_104205_ = (float)Math.PI / 180 * (70.0f + Mth.m_14089_((float)(n * 40.0f)) * 10.0f);
                this.f_102812_.f_104205_ = this.f_102811_.f_104205_ * -1.0f;
                this.f_102811_.f_104201_ = Mth.m_14031_((float)(n * 40.0f)) * 0.5f + 1.5f;
                this.f_102812_.f_104201_ = Mth.m_14031_((float)(n * 40.0f)) * 0.5f + 1.5f;
                this.f_102810_.f_104201_ = Mth.m_14031_((float)(n * 40.0f)) * 0.35f;
            } else if (piglinArmPose == PiglinArmPose.ATTACKING_WITH_MELEE_WEAPON && this.f_102608_ == 0.0f) {
                this.holdWeaponHigh(mob);
            } else if (piglinArmPose == PiglinArmPose.CROSSBOW_HOLD) {
                AnimationUtils.m_102097_((ModelPart)this.f_102811_, (ModelPart)this.f_102812_, (ModelPart)this.f_102808_, (!mob.m_21526_() ? 1 : 0) != 0);
            } else if (piglinArmPose == PiglinArmPose.CROSSBOW_CHARGE) {
                AnimationUtils.m_102086_((ModelPart)this.f_102811_, (ModelPart)this.f_102812_, mob, (!mob.m_21526_() ? 1 : 0) != 0);
            } else if (piglinArmPose == PiglinArmPose.ADMIRING_ITEM) {
                this.f_102808_.f_104203_ = 0.5f;
                this.f_102808_.f_104204_ = 0.0f;
                if (mob.m_21526_()) {
                    this.f_102811_.f_104204_ = -0.5f;
                    this.f_102811_.f_104203_ = -0.9f;
                } else {
                    this.f_102812_.f_104204_ = 0.5f;
                    this.f_102812_.f_104203_ = -0.9f;
                }
            }
        }
        this.f_103376_.m_104315_(this.f_102814_);
        this.f_103377_.m_104315_(this.f_102813_);
        this.f_103374_.m_104315_(this.f_102812_);
        this.f_103375_.m_104315_(this.f_102811_);
        this.f_103378_.m_104315_(this.f_102810_);
        this.f_102809_.m_104315_(this.f_102808_);
    }

    protected void setupAttackAnimation(T mob, float f) {
        if (this.f_102608_ > 0.0f && mob instanceof Piglin && ((Piglin)mob).m_6389_() == PiglinArmPose.ATTACKING_WITH_MELEE_WEAPON) {
            AnimationUtils.m_102091_((ModelPart)this.f_102811_, (ModelPart)this.f_102812_, mob, (float)this.f_102608_, (float)f);
        } else {
            super.m_7884_(mob, f);
        }
    }

    private void holdWeaponHigh(T mob) {
        if (mob.m_21526_()) {
            this.f_102812_.f_104203_ = -1.8f;
        } else {
            this.f_102811_.f_104203_ = -1.8f;
        }
    }
}

